/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.EOFException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import wvlet.airframe.control.CircuitBreakerOpenException;
import wvlet.airframe.control.ResultClass;
import wvlet.airframe.control.ResultClass$;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.HttpStatus$BadRequest_400$;
import wvlet.airframe.http.HttpStatus$ClientClosedRequest_499$;
import wvlet.airframe.http.HttpStatus$Gone_410$;
import wvlet.airframe.http.HttpStatus$RequestTimeout_408$;
import wvlet.airframe.http.HttpStatus$ServiceUnavailable_503$;
import wvlet.airframe.http.HttpStatus$TooManyRequests_429$;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCException$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClientException$
implements LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    private volatile Object logger$lzy1;
    private static final Set finagleRetryableExceptionClasses;
    public static final HttpClientException$ MODULE$;

    private HttpClientException$() {
    }

    static {
        MODULE$ = new HttpClientException$();
        finagleRetryableExceptionClasses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"com.twitter.finagle.ChannelClosedException", "com.twitter.finagle.ReadTimedOutException", "com.twitter.finagle.WriteTimedOutException"}));
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, HttpClientException.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, HttpClientException.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, HttpClientException.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, HttpClientException.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClientException$.class);
    }

    private <Resp> HttpClientException requestFailure(Resp response, HttpResponseAdapter<Resp> adapter) {
        HttpStatus status = adapter.statusOf(response);
        boolean isRPCException = adapter.headerOf(response).get("x-airframe-rpc-status").isDefined();
        if (isRPCException) {
            RPCException cause = RPCException$.MODULE$.fromResponse(adapter.httpResponseOf(response));
            return new HttpClientException(adapter.wrap(response), status, cause);
        }
        String content = adapter.contentStringOf(response);
        if (content == null || content.isEmpty() || isRPCException) {
            return new HttpClientException(adapter.wrap(response), status);
        }
        return new HttpClientException(adapter.wrap(response), status, new StringBuilder(16).append("Request failed: ").append(content).toString());
    }

    public <Resp> ResultClass classifyHttpResponse(Resp response, HttpResponseAdapter<Resp> adapter) {
        ResultClass.Succeeded$ succeeded$;
        HttpStatus status = adapter.statusOf(response);
        HttpStatus httpStatus = status;
        HttpStatus s = httpStatus;
        if (s.isSuccessful()) {
            succeeded$ = ResultClass.Succeeded$.MODULE$;
        } else {
            HttpStatus s2 = httpStatus;
            if (s2.isServerError()) {
                ResultClass.Failed f = ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
                HttpStatus httpStatus2 = status;
                HttpStatus$ServiceUnavailable_503$ httpStatus$ServiceUnavailable_503$ = HttpStatus$ServiceUnavailable_503$.MODULE$;
                succeeded$ = !(httpStatus2 != null ? !httpStatus2.equals(httpStatus$ServiceUnavailable_503$) : httpStatus$ServiceUnavailable_503$ != null) ? f.withExtraWaitFactor(0.5, f.withExtraWaitFactor$default$2()) : f;
            } else {
                HttpStatus httpStatus3;
                HttpStatus s3 = httpStatus;
                succeeded$ = s3.isClientError() ? (HttpStatus$BadRequest_400$.MODULE$.equals(httpStatus3 = s3) && this.isRetryable400ErrorMessage(adapter.contentStringOf(response)) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : (HttpStatus$RequestTimeout_408$.MODULE$.equals(httpStatus3) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : (HttpStatus$Gone_410$.MODULE$.equals(httpStatus3) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : (HttpStatus$TooManyRequests_429$.MODULE$.equals(httpStatus3) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : (HttpStatus$ClientClosedRequest_499$.MODULE$.equals(httpStatus3) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : ResultClass$.MODULE$.nonRetryableFailure((Throwable)this.requestFailure(response, adapter))))))) : ResultClass$.MODULE$.nonRetryableFailure((Throwable)this.requestFailure(response, adapter));
            }
        }
        return (ResultClass)succeeded$;
    }

    private boolean isRetryable400ErrorMessage(String m) {
        Seq retriable400ErrorMessage = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Regex[]{StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Idle connections will be closed"))}));
        return retriable400ErrorMessage.find((Function1 & Serializable)pattern -> pattern.findFirstIn((CharSequence)m).isDefined()).isDefined();
    }

    public ResultClass.Failed classifyExecutionFailure(Throwable ex) {
        return (ResultClass.Failed)this.executionFailureClassifier().applyOrElse((Object)ex, this.nonRetryable());
    }

    public ResultClass.Failed classifyExecutionFailureScalaJS(Throwable ex) {
        return (ResultClass.Failed)this.scalajsCompatibleFailureClassifier().orElse(this.rootCauseExceptionClassifierScalaJS()).applyOrElse((Object)ex, this.nonRetryable());
    }

    public PartialFunction<Throwable, ResultClass.Failed> executionFailureClassifier() {
        return this.scalajsCompatibleFailureClassifier().orElse(this.connectionExceptionClassifier()).orElse(this.sslExceptionClassifier()).orElse(this.rootCauseExceptionClassifier());
    }

    public PartialFunction<Throwable, ResultClass.Failed> scalajsCompatibleFailureClassifier() {
        return new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof CircuitBreakerOpenException) {
                    CircuitBreakerOpenException e = (CircuitBreakerOpenException)throwable;
                    return true;
                }
                if (throwable instanceof EOFException) {
                    EOFException e = (EOFException)throwable;
                    return true;
                }
                if (throwable instanceof TimeoutException) {
                    TimeoutException e = (TimeoutException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof CircuitBreakerOpenException) {
                    CircuitBreakerOpenException e = (CircuitBreakerOpenException)throwable;
                    return ResultClass$.MODULE$.nonRetryableFailure((Throwable)e);
                }
                if (throwable instanceof EOFException) {
                    EOFException e = (EOFException)throwable;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e);
                }
                if (throwable instanceof TimeoutException) {
                    TimeoutException e = (TimeoutException)throwable;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e);
                }
                return function1.apply((Object)x);
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> connectionExceptionClassifier() {
        return new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable e;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e2 = (InterruptedException)throwable;
                    return true;
                }
                if (throwable instanceof ProtocolException) {
                    ProtocolException e3 = (ProtocolException)throwable;
                    return true;
                }
                if (throwable instanceof ConnectException) {
                    ConnectException e4 = (ConnectException)throwable;
                    return true;
                }
                if (throwable instanceof ClosedChannelException) {
                    ClosedChannelException e5 = (ClosedChannelException)throwable;
                    return true;
                }
                if (throwable instanceof SocketTimeoutException) {
                    SocketTimeoutException e6 = (SocketTimeoutException)throwable;
                    return true;
                }
                if (throwable instanceof SocketException) {
                    SocketException e7 = (SocketException)throwable;
                    return true;
                }
                return throwable != null && HttpClientException$.MODULE$.isRetryableFinagleException(e = throwable);
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable e;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e2 = (InterruptedException)throwable;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e2);
                }
                if (throwable instanceof ProtocolException) {
                    ProtocolException e3 = (ProtocolException)throwable;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e3);
                }
                if (throwable instanceof ConnectException) {
                    ConnectException e4 = (ConnectException)throwable;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e4);
                }
                if (throwable instanceof ClosedChannelException) {
                    ClosedChannelException e5 = (ClosedChannelException)throwable;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e5);
                }
                if (throwable instanceof SocketTimeoutException) {
                    SocketTimeoutException e6 = (SocketTimeoutException)throwable;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e6);
                }
                if (throwable instanceof SocketException) {
                    SocketException e7 = (SocketException)throwable;
                    SocketException socketException = e7;
                    if (socketException instanceof BindException) {
                        BindException se = (BindException)socketException;
                        return ResultClass$.MODULE$.retryableFailure((Throwable)e7);
                    }
                    if (socketException instanceof ConnectException) {
                        ConnectException se = (ConnectException)socketException;
                        return ResultClass$.MODULE$.retryableFailure((Throwable)e7);
                    }
                    if (socketException instanceof NoRouteToHostException) {
                        NoRouteToHostException se = (NoRouteToHostException)socketException;
                        return ResultClass$.MODULE$.retryableFailure((Throwable)e7);
                    }
                    if (socketException instanceof PortUnreachableException) {
                        PortUnreachableException se = (PortUnreachableException)socketException;
                        return ResultClass$.MODULE$.retryableFailure((Throwable)e7);
                    }
                    SocketException se = socketException;
                    String string = se.getMessage();
                    String string2 = "Socket closed";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return ResultClass$.MODULE$.retryableFailure((Throwable)e7);
                    }
                    SocketException other = socketException;
                    return ResultClass$.MODULE$.nonRetryableFailure((Throwable)e7);
                }
                if (throwable != null && HttpClientException$.MODULE$.isRetryableFinagleException(e = throwable)) {
                    return ResultClass$.MODULE$.retryableFailure(e);
                }
                return function1.apply((Object)x);
            }
        };
    }

    public Set<String> finagleRetryableExceptionClasses() {
        return finagleRetryableExceptionClasses;
    }

    public boolean isRetryableFinagleException(Throwable e) {
        return this.iter$1(e);
    }

    public PartialFunction<Throwable, ResultClass.Failed> sslExceptionClassifier() {
        return new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof SSLException) {
                    SSLException e = (SSLException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof SSLException) {
                    SSLException e = (SSLException)throwable;
                    SSLException sSLException = e;
                    if (sSLException instanceof SSLHandshakeException) {
                        SSLHandshakeException se = (SSLHandshakeException)sSLException;
                        return ResultClass$.MODULE$.nonRetryableFailure((Throwable)e);
                    }
                    if (sSLException instanceof SSLKeyException) {
                        SSLKeyException se = (SSLKeyException)sSLException;
                        return ResultClass$.MODULE$.nonRetryableFailure((Throwable)e);
                    }
                    if (sSLException instanceof SSLPeerUnverifiedException) {
                        SSLPeerUnverifiedException s3 = (SSLPeerUnverifiedException)sSLException;
                        return ResultClass$.MODULE$.nonRetryableFailure((Throwable)e);
                    }
                    SSLException other = sSLException;
                    return ResultClass$.MODULE$.retryableFailure((Throwable)e);
                }
                return function1.apply((Object)x);
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> rootCauseExceptionClassifier() {
        return new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                ExecutionException e;
                Throwable throwable = x;
                if (throwable instanceof ExecutionException && (e = (ExecutionException)throwable).getCause() != null) {
                    return true;
                }
                if (throwable instanceof InvocationTargetException) {
                    InvocationTargetException e2 = (InvocationTargetException)throwable;
                    return true;
                }
                Throwable e3 = throwable;
                return e3.getCause() != null;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                ExecutionException e;
                Throwable throwable = x;
                if (throwable instanceof ExecutionException && (e = (ExecutionException)throwable).getCause() != null) {
                    return HttpClientException$.MODULE$.classifyExecutionFailure(e.getCause());
                }
                if (throwable instanceof InvocationTargetException) {
                    InvocationTargetException e2 = (InvocationTargetException)throwable;
                    return HttpClientException$.MODULE$.classifyExecutionFailure(e2.getTargetException());
                }
                Throwable e3 = throwable;
                if (e3.getCause() != null) {
                    return HttpClientException$.MODULE$.classifyExecutionFailure(e3.getCause());
                }
                return function1.apply((Object)x);
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> rootCauseExceptionClassifierScalaJS() {
        return new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                ExecutionException e;
                Throwable throwable = x;
                if (throwable instanceof ExecutionException && (e = (ExecutionException)throwable).getCause() != null) {
                    return true;
                }
                Throwable e2 = throwable;
                return e2.getCause() != null;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                ExecutionException e;
                Throwable throwable = x;
                if (throwable instanceof ExecutionException && (e = (ExecutionException)throwable).getCause() != null) {
                    return HttpClientException$.MODULE$.classifyExecutionFailureScalaJS(e.getCause());
                }
                Throwable e2 = throwable;
                if (e2.getCause() != null) {
                    return HttpClientException$.MODULE$.classifyExecutionFailureScalaJS(e2.getCause());
                }
                return function1.apply((Object)x);
            }
        };
    }

    public Function1<Throwable, ResultClass.Failed> nonRetryable() {
        return (Function1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable e = throwable = x$1;
            return ResultClass$.MODULE$.nonRetryableFailure(e);
        };
    }

    private final boolean iter$1(Object cl) {
        while (true) {
            Class cl2;
            Class<?> clazz;
            if ((clazz = cl) == null) {
                return false;
            }
            if (clazz instanceof Throwable) {
                Throwable e = (Throwable)((Object)clazz);
                cl = e.getClass();
                continue;
            }
            if (!(clazz instanceof Class) || !Throwable.class.isAssignableFrom(cl2 = (Class)clazz)) break;
            if (this.finagleRetryableExceptionClasses().contains((Object)cl2.getName())) {
                return true;
            }
            cl = cl2.getSuperclass();
        }
        return false;
    }
}

