/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.control.Retry;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpClientMaxRetryException$;
import wvlet.airframe.http.HttpResponse;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.HttpStatus$InternalServerError_500$;

public class HttpClientMaxRetryException
extends HttpClientException
implements Product {
    private final HttpResponse response;
    private final Retry.RetryContext retryContext;
    private final Throwable cause;

    public static HttpClientMaxRetryException apply(HttpResponse<?> httpResponse, Retry.RetryContext retryContext, Throwable throwable) {
        return HttpClientMaxRetryException$.MODULE$.apply(httpResponse, retryContext, throwable);
    }

    public static HttpClientMaxRetryException fromProduct(Product product) {
        return HttpClientMaxRetryException$.MODULE$.fromProduct(product);
    }

    public static HttpClientMaxRetryException unapply(HttpClientMaxRetryException httpClientMaxRetryException) {
        return HttpClientMaxRetryException$.MODULE$.unapply(httpClientMaxRetryException);
    }

    public HttpClientMaxRetryException(HttpResponse<?> response, Retry.RetryContext retryContext, Throwable cause) {
        HttpStatus httpStatus;
        this.response = response;
        this.retryContext = retryContext;
        this.cause = cause;
        Throwable throwable = cause;
        if (throwable instanceof HttpClientException) {
            HttpClientException e = (HttpClientException)throwable;
            httpStatus = e.status();
        } else {
            httpStatus = HttpStatus$InternalServerError_500$.MODULE$;
        }
        super(response, httpStatus, new StringBuilder(31).append("Reached the max retry count ").append(retryContext.retryCount()).append("/").append(retryContext.maxRetry()).append(": ").append(cause.getMessage()).toString(), cause);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HttpClientMaxRetryException)) return false;
        HttpClientMaxRetryException httpClientMaxRetryException = (HttpClientMaxRetryException)object;
        HttpResponse<?> httpResponse = this.response();
        HttpResponse<?> httpResponse2 = httpClientMaxRetryException.response();
        if (httpResponse == null) {
            if (httpResponse2 != null) {
                return false;
            }
        } else if (!httpResponse.equals(httpResponse2)) return false;
        Retry.RetryContext retryContext = this.retryContext();
        Retry.RetryContext retryContext2 = httpClientMaxRetryException.retryContext();
        if (retryContext == null) {
            if (retryContext2 != null) {
                return false;
            }
        } else if (!retryContext.equals(retryContext2)) return false;
        Throwable throwable = this.cause();
        Throwable throwable2 = httpClientMaxRetryException.cause();
        if (throwable == null) {
            if (throwable2 != null) {
                return false;
            }
        } else if (!throwable.equals(throwable2)) return false;
        if (!httpClientMaxRetryException.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof HttpClientMaxRetryException;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "HttpClientMaxRetryException";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "response";
            }
            case 1: {
                return "retryContext";
            }
            case 2: {
                return "cause";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public HttpResponse<?> response() {
        return this.response;
    }

    public Retry.RetryContext retryContext() {
        return this.retryContext;
    }

    public Throwable cause() {
        return this.cause;
    }

    public HttpClientMaxRetryException copy(HttpResponse<?> response, Retry.RetryContext retryContext, Throwable cause) {
        return new HttpClientMaxRetryException(response, retryContext, cause);
    }

    public HttpResponse<?> copy$default$1() {
        return this.response();
    }

    public Retry.RetryContext copy$default$2() {
        return this.retryContext();
    }

    public Throwable copy$default$3() {
        return this.cause();
    }

    public HttpResponse<?> _1() {
        return this.response();
    }

    public Retry.RetryContext _2() {
        return this.retryContext();
    }

    public Throwable _3() {
        return this.cause();
    }
}

