/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.concurrent.Future;
import wvlet.airframe.http.HttpBackend;
import wvlet.airframe.http.HttpContext$;
import wvlet.airframe.http.HttpContextBase;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpMessage;

public interface HttpContext<Req, Resp, F>
extends HttpContextBase {
    public static HttpContext<HttpMessage.Request, HttpMessage.Response, Future> mockContext() {
        return HttpContext$.MODULE$.mockContext();
    }

    public static <Req, Resp, F> HttpContext<Req, Resp, F> newContext(HttpBackend<Req, Resp, F> httpBackend, Function1<Req, Object> function1) {
        return HttpContext$.MODULE$.newContext(httpBackend, function1);
    }

    public HttpBackend<Req, Resp, F> backend();

    public static String backendName$(HttpContext $this) {
        return $this.backendName();
    }

    default public String backendName() {
        return this.backend().name();
    }

    public F apply(Req var1);

    public static Object withThreadLocalStore$(HttpContext $this, Function0 body) {
        return $this.withThreadLocalStore(body);
    }

    default public F withThreadLocalStore(Function0<F> body) {
        return this.backend().withThreadLocalStore(body);
    }

    public static void setThreadLocal$(HttpContext $this, String key, Object value) {
        $this.setThreadLocal(key, value);
    }

    default public <A> void setThreadLocal(String key, A value) {
        this.backend().setThreadLocal(key, value);
    }

    public static Option getThreadLocal$(HttpContext $this, String key) {
        return $this.getThreadLocal(key);
    }

    default public <A> Option<A> getThreadLocal(String key) {
        return this.backend().getThreadLocal(key);
    }

    public static class FilterAndThenContext<Req, Resp, F>
    implements HttpContext<Req, Resp, F> {
        private final HttpBackend backend;
        private final HttpFilter<Req, Resp, F> filter;
        private final HttpContext<Req, Resp, F> context;

        public FilterAndThenContext(HttpBackend<Req, Resp, F> backend, HttpFilter<Req, Resp, F> filter, HttpContext<Req, Resp, F> context) {
            this.backend = backend;
            this.filter = filter;
            this.context = context;
        }

        @Override
        public HttpBackend<Req, Resp, F> backend() {
            return this.backend;
        }

        @Override
        public F apply(Req request) {
            return this.backend().rescue(() -> this.apply$$anonfun$2(request));
        }

        private final Object apply$$anonfun$2(Object request$2) {
            return this.filter.apply(request$2, new SafeHttpContext<Req, Resp, F>(this.backend(), this.context));
        }
    }

    public static class SafeHttpContext<Req, Resp, F>
    implements HttpContext<Req, Resp, F> {
        private final HttpBackend backend;
        private final HttpContext<Req, Resp, F> context;

        public SafeHttpContext(HttpBackend<Req, Resp, F> backend, HttpContext<Req, Resp, F> context) {
            this.backend = backend;
            this.context = context;
        }

        @Override
        public HttpBackend<Req, Resp, F> backend() {
            return this.backend;
        }

        @Override
        public F apply(Req request) {
            return this.backend().rescue(() -> this.apply$$anonfun$3(request));
        }

        private final Object apply$$anonfun$3(Object request$3) {
            return this.context.apply(request$3);
        }
    }
}

