/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import scala.Function1;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.LazyVals$;
import wvlet.airframe.http.HttpLogger$;
import wvlet.airframe.http.HttpLoggerConfig;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.Logger;

public interface HttpLogger
extends AutoCloseable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HttpLogger$.class.getDeclaredField("logger$lzy1"));

    public static Set<String> defaultExcludeHeaders() {
        return HttpLogger$.MODULE$.defaultExcludeHeaders();
    }

    public static HttpLogger emptyLogger(HttpLoggerConfig httpLoggerConfig) {
        return HttpLogger$.MODULE$.emptyLogger(httpLoggerConfig);
    }

    public static Function1<Map<String, Object>, String> jsonFormatter() {
        return HttpLogger$.MODULE$.jsonFormatter();
    }

    public HttpLoggerConfig config();

    public static void write$(HttpLogger $this, Map log) {
        $this.write((Map<String, Object>)log);
    }

    default public void write(Map<String, Object> log) {
        this.writeInternal((Map<String, Object>)((Map)this.config().logFilter().apply((Object)this.config().extraTags().$plus$plus(log))));
    }

    public void writeInternal(Map<String, Object> var1);

    public static class ConsoleHttpLogger
    implements HttpLogger {
        private final HttpLoggerConfig config;

        public ConsoleHttpLogger(HttpLoggerConfig config) {
            this.config = config;
        }

        @Override
        public HttpLoggerConfig config() {
            return this.config;
        }

        @Override
        public void writeInternal(Map<String, Object> log) {
            String msg = (String)this.config().logFormatter().apply(log);
            Logger LoggerBase_this = HttpLogger$.MODULE$.logger();
            if (LoggerBase_this.isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                LoggerBase_this.log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "HttpLogger.scala", 141, 23), (Object)msg);
                return;
            }
        }

        @Override
        public void close() {
        }
    }

    public static class InMemoryHttpLogger
    implements HttpLogger {
        private final HttpLoggerConfig config;
        private final Builder<Map<String, Object>, Seq<Map<String, Object>>> logs;

        public InMemoryHttpLogger(HttpLoggerConfig config) {
            this.config = config;
            this.logs = package$.MODULE$.Seq().newBuilder();
        }

        @Override
        public HttpLoggerConfig config() {
            return this.config;
        }

        public Seq<Map<String, Object>> getLogs() {
            return (Seq)this.logs.result();
        }

        public void clear() {
            this.logs.clear();
        }

        @Override
        public void writeInternal(Map<String, Object> log) {
            InMemoryHttpLogger inMemoryHttpLogger = this;
            synchronized (inMemoryHttpLogger) {
                Builder cfr_ignored_0 = (Builder)this.logs.$plus$eq(log);
            }
        }

        @Override
        public void close() {
        }
    }
}

