/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpMessage$;
import wvlet.airframe.http.HttpMessage$ByteArrayMessage$;
import wvlet.airframe.http.HttpMessage$HttpMessageRequestAdapter$;
import wvlet.airframe.http.HttpMessage$HttpMessageResponseAdapter$;
import wvlet.airframe.http.HttpMessage$Message$;
import wvlet.airframe.http.HttpMessage$Request$;
import wvlet.airframe.http.HttpMessage$Response$;
import wvlet.airframe.http.HttpMessage$StringMessage$;
import wvlet.airframe.http.HttpMessageBase;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpRequest;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.HttpResponse;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.ServerAddress;

public interface HttpMessage<Raw>
extends HttpMessageBase<Raw> {
    public static HttpMessageRequestWrapper HttpMessageRequestWrapper(Request request) {
        return HttpMessage$.MODULE$.HttpMessageRequestWrapper(request);
    }

    public static HttpMessageResponseWrapper HttpMessageResponseWrapper(Response response) {
        return HttpMessage$.MODULE$.HttpMessageResponseWrapper(response);
    }

    public static Message byteArrayMessage(byte[] byArray) {
        return HttpMessage$.MODULE$.byteArrayMessage(byArray);
    }

    public static HttpMultiMap extractQueryFromUri(String string) {
        return HttpMessage$.MODULE$.extractQueryFromUri(string);
    }

    public static Message stringMessage(String string) {
        return HttpMessage$.MODULE$.stringMessage(string);
    }

    public HttpMultiMap header();

    public static Option getHeader$(HttpMessage $this, String key) {
        return $this.getHeader(key);
    }

    default public Option<String> getHeader(String key) {
        return this.header().get(key);
    }

    public static Seq getAllHeader$(HttpMessage $this, String key) {
        return $this.getAllHeader(key);
    }

    default public Seq<String> getAllHeader(String key) {
        return this.header().getAll(key);
    }

    public static Option allow$(HttpMessage $this) {
        return $this.allow();
    }

    default public Option<String> allow() {
        return this.header().get("Allow");
    }

    public static Seq accept$(HttpMessage $this) {
        return $this.accept();
    }

    default public Seq<String> accept() {
        return Http$.MODULE$.parseAcceptHeader(this.header().get("Accept"));
    }

    public static Option authorization$(HttpMessage $this) {
        return $this.authorization();
    }

    default public Option<String> authorization() {
        return this.header().get("Authorization");
    }

    public static Option cacheControl$(HttpMessage $this) {
        return $this.cacheControl();
    }

    default public Option<String> cacheControl() {
        return this.header().get("Cache-Control");
    }

    public static Option contentType$(HttpMessage $this) {
        return $this.contentType();
    }

    default public Option<String> contentType() {
        return this.header().get("Content-Type");
    }

    public static Option contentEncoding$(HttpMessage $this) {
        return $this.contentEncoding();
    }

    default public Option<String> contentEncoding() {
        return this.header().get("Content-Encoding");
    }

    public static Option contentLength$(HttpMessage $this) {
        return $this.contentLength();
    }

    default public Option<Object> contentLength() {
        return this.header().get("Content-Length").map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$1)));
    }

    public static Option date$(HttpMessage $this) {
        return $this.date();
    }

    default public Option<String> date() {
        return this.header().get("Date");
    }

    public static Option expires$(HttpMessage $this) {
        return $this.expires();
    }

    default public Option<String> expires() {
        return this.header().get("Expires");
    }

    public static Option host$(HttpMessage $this) {
        return $this.host();
    }

    default public Option<String> host() {
        return this.header().get("Host");
    }

    public static Option lastModified$(HttpMessage $this) {
        return $this.lastModified();
    }

    default public Option<String> lastModified() {
        return this.header().get("Last-Modified");
    }

    public static Option referer$(HttpMessage $this) {
        return $this.referer();
    }

    default public Option<String> referer() {
        return this.header().get("Referer");
    }

    public static Option userAgent$(HttpMessage $this) {
        return $this.userAgent();
    }

    default public Option<String> userAgent() {
        return this.header().get("User-Agent");
    }

    public static Option xForwardedFor$(HttpMessage $this) {
        return $this.xForwardedFor();
    }

    default public Option<String> xForwardedFor() {
        return this.header().get("X-Forwarded-For");
    }

    public static Option xForwardedProto$(HttpMessage $this) {
        return $this.xForwardedProto();
    }

    default public Option<String> xForwardedProto() {
        return this.header().get("X-Forwarded-Proto");
    }

    public Message message();

    public Raw copyWith(HttpMultiMap var1);

    public Raw copyWith(Message var1);

    public static Object withHeader$(HttpMessage $this, String key, String value) {
        return $this.withHeader(key, value);
    }

    default public Raw withHeader(String key, String value) {
        return this.copyWith(this.header().set(key, value));
    }

    public static Object withHeader$(HttpMessage $this, HttpMultiMap newHeader) {
        return $this.withHeader(newHeader);
    }

    default public Raw withHeader(HttpMultiMap newHeader) {
        return this.copyWith(newHeader);
    }

    public static Object withHeader$(HttpMessage $this, Function1 f) {
        return $this.withHeader((Function1<HttpMultiMap, HttpMultiMap>)f);
    }

    default public Raw withHeader(Function1<HttpMultiMap, HttpMultiMap> f) {
        return this.copyWith((HttpMultiMap)f.apply((Object)this.header()));
    }

    public static Object addHeader$(HttpMessage $this, String key, String value) {
        return $this.addHeader(key, value);
    }

    default public Raw addHeader(String key, String value) {
        return this.copyWith(this.header().add(key, value));
    }

    public static Object removeHeader$(HttpMessage $this, String key) {
        return $this.removeHeader(key);
    }

    default public Raw removeHeader(String key) {
        return this.copyWith(this.header().remove(key));
    }

    public static Object withContent$(HttpMessage $this, Message content) {
        return $this.withContent(content);
    }

    default public Raw withContent(Message content) {
        return this.copyWith(content);
    }

    public static Object withContent$(HttpMessage $this, String content) {
        return $this.withContent(content);
    }

    default public Raw withContent(String content) {
        return this.copyWith(HttpMessage$StringMessage$.MODULE$.apply(content));
    }

    public static Object withContent$(HttpMessage $this, byte[] content) {
        return $this.withContent(content);
    }

    default public Raw withContent(byte[] content) {
        return this.copyWith(HttpMessage$.MODULE$.byteArrayMessage(content));
    }

    public static Object withJson$(HttpMessage $this, String json) {
        return $this.withJson(json);
    }

    default public Raw withJson(String json) {
        return ((HttpMessage)this.copyWith(HttpMessage$.MODULE$.stringMessage(json))).withContentTypeJson();
    }

    public static Object withJson$(HttpMessage $this, byte[] json) {
        return $this.withJson(json);
    }

    default public Raw withJson(byte[] json) {
        return ((HttpMessage)this.copyWith(HttpMessage$.MODULE$.byteArrayMessage(json))).withContentTypeJson();
    }

    public static Object withMsgPack$(HttpMessage $this, byte[] msgPack) {
        return $this.withMsgPack(msgPack);
    }

    default public Raw withMsgPack(byte[] msgPack) {
        return ((HttpMessage)this.copyWith(HttpMessage$.MODULE$.byteArrayMessage(msgPack))).withContentTypeMsgPack();
    }

    public static String contentString$(HttpMessage $this) {
        return $this.contentString();
    }

    default public String contentString() {
        return this.message().toContentString();
    }

    public static byte[] contentBytes$(HttpMessage $this) {
        return $this.contentBytes();
    }

    default public byte[] contentBytes() {
        return this.message().toContentBytes();
    }

    public static Object withAccept$(HttpMessage $this, String acceptType) {
        return $this.withAccept(acceptType);
    }

    default public Raw withAccept(String acceptType) {
        return this.withHeader("Accept", acceptType);
    }

    public static Object withAcceptMsgPack$(HttpMessage $this) {
        return $this.withAcceptMsgPack();
    }

    default public Raw withAcceptMsgPack() {
        return this.withHeader("Accept", "application/msgpack");
    }

    public static Object withAcceptJson$(HttpMessage $this) {
        return $this.withAcceptJson();
    }

    default public Raw withAcceptJson() {
        return this.withHeader("Accept", "application/json;charset=utf-8");
    }

    public static Object withAllow$(HttpMessage $this, String allow) {
        return $this.withAllow(allow);
    }

    default public Raw withAllow(String allow) {
        return this.withHeader("Allow", allow);
    }

    public static Object withAuthorization$(HttpMessage $this, String authorization) {
        return $this.withAuthorization(authorization);
    }

    default public Raw withAuthorization(String authorization) {
        return this.withHeader("Authorization", authorization);
    }

    public static Object withCacheControl$(HttpMessage $this, String cacheControl) {
        return $this.withCacheControl(cacheControl);
    }

    default public Raw withCacheControl(String cacheControl) {
        return this.withHeader("Cache-Control", cacheControl);
    }

    public static Object withContentType$(HttpMessage $this, String contentType) {
        return $this.withContentType(contentType);
    }

    default public Raw withContentType(String contentType) {
        return this.withHeader("Content-Type", contentType);
    }

    public static Object withContentTypeJson$(HttpMessage $this) {
        return $this.withContentTypeJson();
    }

    default public Raw withContentTypeJson() {
        return this.withContentType("application/json;charset=utf-8");
    }

    public static Object withContentTypeMsgPack$(HttpMessage $this) {
        return $this.withContentTypeMsgPack();
    }

    default public Raw withContentTypeMsgPack() {
        return this.withContentType("application/msgpack");
    }

    public static Object withContentLength$(HttpMessage $this, long length) {
        return $this.withContentLength(length);
    }

    default public Raw withContentLength(long length) {
        return this.withHeader("Content-Length", BoxesRunTime.boxToLong((long)length).toString());
    }

    public static Object withDate$(HttpMessage $this, String date) {
        return $this.withDate(date);
    }

    default public Raw withDate(String date) {
        return this.withHeader("Date", date);
    }

    public static Object withDate$(HttpMessage $this, Instant date) {
        return $this.withDate(date);
    }

    default public Raw withDate(Instant date) {
        return this.withHeader("Date", Http$.MODULE$.formatInstant(date));
    }

    public static Object withExpires$(HttpMessage $this, String expires) {
        return $this.withExpires(expires);
    }

    default public Raw withExpires(String expires) {
        return this.withHeader("Expires", expires);
    }

    public static Object withHost$(HttpMessage $this, String host) {
        return $this.withHost(host);
    }

    default public Raw withHost(String host) {
        return this.withHeader("Host", host);
    }

    public static Object noHost$(HttpMessage $this) {
        return $this.noHost();
    }

    default public Raw noHost() {
        return this.removeHeader("Host");
    }

    public static Object withLastModified$(HttpMessage $this, String lastModified) {
        return $this.withLastModified(lastModified);
    }

    default public Raw withLastModified(String lastModified) {
        return this.withHeader("Last-Modified", lastModified);
    }

    public static Object withReferer$(HttpMessage $this, String referer) {
        return $this.withReferer(referer);
    }

    default public Raw withReferer(String referer) {
        return this.withHeader("Referer", referer);
    }

    public static Object withUserAgent$(HttpMessage $this, String userAgent) {
        return $this.withUserAgent(userAgent);
    }

    default public Raw withUserAgent(String userAgent) {
        return this.withHeader("User-Agent", userAgent);
    }

    public static Object withXForwardedFor$(HttpMessage $this, String xForwardedFor) {
        return $this.withXForwardedFor(xForwardedFor);
    }

    default public Raw withXForwardedFor(String xForwardedFor) {
        return this.withHeader("X-Forwarded-For", xForwardedFor);
    }

    public static Object withXForwardedProto$(HttpMessage $this, String xForwardedProto) {
        return $this.withXForwardedProto(xForwardedProto);
    }

    default public Raw withXForwardedProto(String xForwardedProto) {
        return this.withHeader("X-Forwarded-Proto", xForwardedProto);
    }

    public static boolean isContentTypeJson$(HttpMessage $this) {
        return $this.isContentTypeJson();
    }

    default public boolean isContentTypeJson() {
        return this.contentType().exists((Function1 & Serializable)_$2 -> _$2.startsWith("application/json"));
    }

    public static boolean isContentTypeMsgPack$(HttpMessage $this) {
        return $this.isContentTypeMsgPack();
    }

    default public boolean isContentTypeMsgPack() {
        return this.contentType().exists((Function1 & Serializable)x -> {
            String string = x;
            String string2 = "application/msgpack";
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = x;
            String string4 = "application/x-msgpack";
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        });
    }

    public static boolean acceptsJson$(HttpMessage $this) {
        return $this.acceptsJson();
    }

    default public boolean acceptsJson() {
        return this.accept().exists((Function1 & Serializable)x -> {
            String string = x;
            String string2 = "application/json;charset=utf-8";
            return !(string == null ? string2 != null : !string.equals(string2)) || x.startsWith("application/json");
        });
    }

    public static boolean acceptsMsgPack$(HttpMessage $this) {
        return $this.acceptsMsgPack();
    }

    default public boolean acceptsMsgPack() {
        return this.accept().exists((Function1 & Serializable)x -> {
            String string = x;
            String string2 = "application/msgpack";
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = x;
            String string4 = "application/x-msgpack";
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        });
    }

    public static class ByteArrayMessage
    implements Message,
    Product,
    Serializable {
        private final byte[] content;

        public static ByteArrayMessage apply(byte[] byArray) {
            return HttpMessage$ByteArrayMessage$.MODULE$.apply(byArray);
        }

        public static ByteArrayMessage fromProduct(Product product) {
            return HttpMessage$ByteArrayMessage$.MODULE$.fromProduct(product);
        }

        public static ByteArrayMessage unapply(ByteArrayMessage byteArrayMessage) {
            return HttpMessage$ByteArrayMessage$.MODULE$.unapply(byteArrayMessage);
        }

        public ByteArrayMessage(byte[] content) {
            this.content = content;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ByteArrayMessage)) return false;
            ByteArrayMessage byteArrayMessage = (ByteArrayMessage)object;
            if (this.content() != byteArrayMessage.content()) return false;
            if (!byteArrayMessage.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ByteArrayMessage;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ByteArrayMessage";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "content";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte[] content() {
            return this.content;
        }

        @Override
        public boolean isEmpty() {
            Object object = Predef$.MODULE$.byteArrayOps(this.content());
            return ArrayOps$.MODULE$.isEmpty$extension(object);
        }

        public String toString() {
            return this.toContentString();
        }

        @Override
        public String toContentString() {
            return new String(this.content(), StandardCharsets.UTF_8);
        }

        @Override
        public byte[] toContentBytes() {
            return this.content();
        }

        public ByteArrayMessage copy(byte[] content) {
            return new ByteArrayMessage(content);
        }

        public byte[] copy$default$1() {
            return this.content();
        }

        public byte[] _1() {
            return this.content();
        }
    }

    public static class HttpMessageRequestWrapper
    implements HttpRequest<Request> {
        private final Request raw;

        public HttpMessageRequestWrapper(Request raw) {
            this.raw = raw;
        }

        public Request raw() {
            return this.raw;
        }

        @Override
        public HttpRequestAdapter<Request> adapter() {
            return HttpMessage$HttpMessageRequestAdapter$.MODULE$;
        }

        @Override
        public Request toRaw() {
            return this.raw();
        }
    }

    public static class HttpMessageResponseWrapper
    implements HttpResponse<Response> {
        private final Response raw;

        public HttpMessageResponseWrapper(Response raw) {
            this.raw = raw;
        }

        public Response raw() {
            return this.raw;
        }

        @Override
        public HttpResponseAdapter<Response> adapter() {
            return HttpMessage$HttpMessageResponseAdapter$.MODULE$;
        }

        @Override
        public Response toRaw() {
            return this.raw();
        }
    }

    public static class LazyByteArrayMessage
    implements Message {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LazyByteArrayMessage.class.getDeclaredField("content$lzy1"));
        private Function0<byte[]> contentReader;
        private volatile Object content$lzy1;

        public LazyByteArrayMessage(Function0<byte[]> contentReader) {
            this.contentReader = contentReader;
        }

        private byte[] content() {
            Object object = this.content$lzy1;
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (byte[])this.content$lzyINIT1();
        }

        private Object content$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.content$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        byte[] byArray = null;
                        try {
                            byArray = (byte[])this.contentReader.apply();
                            object2 = byArray == null ? LazyVals.NullValue$.MODULE$ : (Object)byArray;
                            this.contentReader = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.content$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return byArray;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public boolean isEmpty() {
            Object object = Predef$.MODULE$.byteArrayOps(this.content());
            return ArrayOps$.MODULE$.isEmpty$extension(object);
        }

        public String toString() {
            return this.toContentString();
        }

        @Override
        public String toContentString() {
            return new String(this.content(), StandardCharsets.UTF_8);
        }

        @Override
        public byte[] toContentBytes() {
            return this.content();
        }
    }

    public static interface Message {
        public static Option<Message> unapply(String string) {
            return HttpMessage$Message$.MODULE$.unapply(string);
        }

        public static boolean isEmpty$(Message $this) {
            return $this.isEmpty();
        }

        default public boolean isEmpty() {
            return false;
        }

        public static boolean nonEmpty$(Message $this) {
            return $this.nonEmpty();
        }

        default public boolean nonEmpty() {
            return !this.isEmpty();
        }

        public String toContentString();

        public byte[] toContentBytes();

        public static int contentHash$(Message $this) {
            return $this.contentHash();
        }

        default public int contentHash() {
            return Arrays.hashCode(this.toContentBytes());
        }
    }

    public static class Request
    implements HttpMessage<Request>,
    Product,
    Serializable {
        private final String method;
        private final String uri;
        private final HttpMultiMap header;
        private final Message message;
        private final Option remoteAddress;

        public static Request apply(String string, String string2, HttpMultiMap httpMultiMap, Message message, Option<ServerAddress> option) {
            return HttpMessage$Request$.MODULE$.apply(string, string2, httpMultiMap, message, option);
        }

        public static Request empty() {
            return HttpMessage$Request$.MODULE$.empty();
        }

        public static Request fromProduct(Product product) {
            return HttpMessage$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return HttpMessage$Request$.MODULE$.unapply(request);
        }

        public static String $lessinit$greater$default$1() {
            return HttpMessage$Request$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return HttpMessage$Request$.MODULE$.$lessinit$greater$default$2();
        }

        public static HttpMultiMap $lessinit$greater$default$3() {
            return HttpMessage$Request$.MODULE$.$lessinit$greater$default$3();
        }

        public static Message $lessinit$greater$default$4() {
            return HttpMessage$Request$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<ServerAddress> $lessinit$greater$default$5() {
            return HttpMessage$Request$.MODULE$.$lessinit$greater$default$5();
        }

        public Request(String method, String uri, HttpMultiMap header, Message message, Option<ServerAddress> remoteAddress) {
            this.method = method;
            this.uri = uri;
            this.header = header;
            this.message = message;
            this.remoteAddress = remoteAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            String string = this.method();
            String string2 = request.method();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.uri();
            String string4 = request.uri();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            HttpMultiMap httpMultiMap = this.header();
            HttpMultiMap httpMultiMap2 = request.header();
            if (httpMultiMap == null) {
                if (httpMultiMap2 != null) {
                    return false;
                }
            } else if (!((Object)httpMultiMap).equals(httpMultiMap2)) return false;
            Message message = this.message();
            Message message2 = request.message();
            if (message == null) {
                if (message2 != null) {
                    return false;
                }
            } else if (!message.equals(message2)) return false;
            Option<ServerAddress> option = this.remoteAddress();
            Option<ServerAddress> option2 = request.remoteAddress();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!request.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "method";
                }
                case 1: {
                    return "uri";
                }
                case 2: {
                    return "header";
                }
                case 3: {
                    return "message";
                }
                case 4: {
                    return "remoteAddress";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String method() {
            return this.method;
        }

        public String uri() {
            return this.uri;
        }

        @Override
        public HttpMultiMap header() {
            return this.header;
        }

        @Override
        public Message message() {
            return this.message;
        }

        public Option<ServerAddress> remoteAddress() {
            return this.remoteAddress;
        }

        public String toString() {
            return new StringBuilder(11).append("Request(").append(this.method()).append(",").append(this.uri()).append(",").append(this.header()).append(")").toString();
        }

        public String path() {
            String u = this.uri();
            int n = u.indexOf("?");
            if (-1 == n) {
                return u;
            }
            int pos = n;
            return u.substring(0, pos);
        }

        public HttpMultiMap query() {
            return HttpMessage$.MODULE$.extractQueryFromUri(this.uri());
        }

        public Request withFilter(Function1<Request, Request> f) {
            return (Request)f.apply((Object)this);
        }

        public Request withMethod(String method) {
            return this.copy(method, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public Request withUri(String uri) {
            return this.copy(this.copy$default$1(), uri, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
        }

        public Request withRemoteAddress(ServerAddress remoteAddress) {
            Some some = Some$.MODULE$.apply((Object)remoteAddress);
            String string = this.copy$default$1();
            String string2 = this.copy$default$2();
            HttpMultiMap httpMultiMap = this.copy$default$3();
            Message message = this.copy$default$4();
            return this.copy(string, string2, httpMultiMap, message, (Option<ServerAddress>)some);
        }

        @Override
        public Request copyWith(HttpMultiMap newHeader) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), newHeader, this.copy$default$4(), this.copy$default$5());
        }

        @Override
        public Request copyWith(Message newMessage) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newMessage, this.copy$default$5());
        }

        public Request copy(String method, String uri, HttpMultiMap header, Message message, Option<ServerAddress> remoteAddress) {
            return new Request(method, uri, header, message, remoteAddress);
        }

        public String copy$default$1() {
            return this.method();
        }

        public String copy$default$2() {
            return this.uri();
        }

        public HttpMultiMap copy$default$3() {
            return this.header();
        }

        public Message copy$default$4() {
            return this.message();
        }

        public Option<ServerAddress> copy$default$5() {
            return this.remoteAddress();
        }

        public String _1() {
            return this.method();
        }

        public String _2() {
            return this.uri();
        }

        public HttpMultiMap _3() {
            return this.header();
        }

        public Message _4() {
            return this.message();
        }

        public Option<ServerAddress> _5() {
            return this.remoteAddress();
        }
    }

    public static class Response
    implements HttpMessage<Response>,
    Product,
    Serializable {
        private final HttpStatus status;
        private final HttpMultiMap header;
        private final Message message;

        public static Response apply(HttpStatus httpStatus, HttpMultiMap httpMultiMap, Message message) {
            return HttpMessage$Response$.MODULE$.apply(httpStatus, httpMultiMap, message);
        }

        public static Response empty() {
            return HttpMessage$Response$.MODULE$.empty();
        }

        public static Response fromProduct(Product product) {
            return HttpMessage$Response$.MODULE$.fromProduct(product);
        }

        public static Response unapply(Response response) {
            return HttpMessage$Response$.MODULE$.unapply(response);
        }

        public static HttpStatus $lessinit$greater$default$1() {
            return HttpMessage$Response$.MODULE$.$lessinit$greater$default$1();
        }

        public static HttpMultiMap $lessinit$greater$default$2() {
            return HttpMessage$Response$.MODULE$.$lessinit$greater$default$2();
        }

        public static Message $lessinit$greater$default$3() {
            return HttpMessage$Response$.MODULE$.$lessinit$greater$default$3();
        }

        public Response(HttpStatus status, HttpMultiMap header, Message message) {
            this.status = status;
            this.header = header;
            this.message = message;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Response)) return false;
            Response response = (Response)object;
            HttpStatus httpStatus = this.status();
            HttpStatus httpStatus2 = response.status();
            if (httpStatus == null) {
                if (httpStatus2 != null) {
                    return false;
                }
            } else if (!httpStatus.equals(httpStatus2)) return false;
            HttpMultiMap httpMultiMap = this.header();
            HttpMultiMap httpMultiMap2 = response.header();
            if (httpMultiMap == null) {
                if (httpMultiMap2 != null) {
                    return false;
                }
            } else if (!((Object)httpMultiMap).equals(httpMultiMap2)) return false;
            Message message = this.message();
            Message message2 = response.message();
            if (message == null) {
                if (message2 != null) {
                    return false;
                }
            } else if (!message.equals(message2)) return false;
            if (!response.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Response;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Response";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "status";
                }
                case 1: {
                    return "header";
                }
                case 2: {
                    return "message";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpStatus status() {
            return this.status;
        }

        @Override
        public HttpMultiMap header() {
            return this.header;
        }

        @Override
        public Message message() {
            return this.message;
        }

        public String toString() {
            return new StringBuilder(11).append("Response(").append(this.status()).append(",").append(this.header()).append(")").toString();
        }

        @Override
        public Response copyWith(HttpMultiMap newHeader) {
            return this.copy(this.copy$default$1(), newHeader, this.copy$default$3());
        }

        @Override
        public Response copyWith(Message newMessage) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), newMessage);
        }

        public int statusCode() {
            return this.status().code();
        }

        public Response withStatus(HttpStatus newStatus) {
            return this.copy(newStatus, this.copy$default$2(), this.copy$default$3());
        }

        public Response copy(HttpStatus status, HttpMultiMap header, Message message) {
            return new Response(status, header, message);
        }

        public HttpStatus copy$default$1() {
            return this.status();
        }

        public HttpMultiMap copy$default$2() {
            return this.header();
        }

        public Message copy$default$3() {
            return this.message();
        }

        public HttpStatus _1() {
            return this.status();
        }

        public HttpMultiMap _2() {
            return this.header();
        }

        public Message _3() {
            return this.message();
        }
    }

    public static class StringMessage
    implements Message,
    Product,
    Serializable {
        private final String content;

        public static StringMessage apply(String string) {
            return HttpMessage$StringMessage$.MODULE$.apply(string);
        }

        public static StringMessage fromProduct(Product product) {
            return HttpMessage$StringMessage$.MODULE$.fromProduct(product);
        }

        public static StringMessage unapply(StringMessage stringMessage) {
            return HttpMessage$StringMessage$.MODULE$.unapply(stringMessage);
        }

        public StringMessage(String content) {
            this.content = content;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StringMessage)) return false;
            StringMessage stringMessage = (StringMessage)object;
            String string = this.content();
            String string2 = stringMessage.content();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stringMessage.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof StringMessage;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StringMessage";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "content";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String content() {
            return this.content;
        }

        @Override
        public boolean isEmpty() {
            return this.content().isEmpty();
        }

        public String toString() {
            return this.content();
        }

        @Override
        public String toContentString() {
            return this.content();
        }

        @Override
        public byte[] toContentBytes() {
            return this.content().getBytes(StandardCharsets.UTF_8);
        }

        public StringMessage copy(String content) {
            return new StringMessage(content);
        }

        public String copy$default$1() {
            return this.content();
        }

        public String _1() {
            return this.content();
        }
    }
}

