/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.Serializable;
import java.time.Instant;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMessage$;
import wvlet.airframe.http.HttpMessage$StringMessage$;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpServerExceptionBase;
import wvlet.airframe.http.HttpStatus;

public class HttpServerException
extends Exception
implements HttpServerExceptionBase {
    private final HttpStatus status;
    private HttpMessage.Response response;

    public HttpServerException(HttpStatus status, String msg, Throwable cause) {
        this.status = status;
        super(msg, cause);
        this.response = Http$.MODULE$.response(status, msg);
    }

    public HttpStatus status() {
        return this.status;
    }

    public HttpServerException(HttpStatus status) {
        this(status, status.toString(), null);
    }

    public int statusCode() {
        return this.response.statusCode();
    }

    public HttpMessage.Response toResponse() {
        return this.response;
    }

    public HttpMultiMap header() {
        return this.response.header();
    }

    public HttpMessage.Message message() {
        return this.response.message();
    }

    public String contentString() {
        return this.message().toContentString();
    }

    public byte[] contentBytes() {
        return this.message().toContentBytes();
    }

    public Option<String> getHeader(String key) {
        return this.header().get(key);
    }

    public Seq<String> getAllHeader(String key) {
        return this.header().getAll(key);
    }

    public Option<String> allow() {
        return this.header().get("Allow");
    }

    public Seq<String> accept() {
        return Http$.MODULE$.parseAcceptHeader(this.header().get("Accept"));
    }

    public Option<String> authorization() {
        return this.header().get("Authorization");
    }

    public Option<String> cacheControl() {
        return this.header().get("Cache-Control");
    }

    public Option<String> contentType() {
        return this.header().get("Content-Type");
    }

    public Option<String> contentEncoding() {
        return this.header().get("Content-Encoding");
    }

    public Option<Object> contentLength() {
        return this.header().get("Content-Length").map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$1)));
    }

    public Option<String> date() {
        return this.header().get("Date");
    }

    public Option<String> expires() {
        return this.header().get("Expires");
    }

    public Option<String> host() {
        return this.header().get("Host");
    }

    public Option<String> lastModified() {
        return this.header().get("Last-Modified");
    }

    public Option<String> referer() {
        return this.header().get("Referer");
    }

    public Option<String> userAgent() {
        return this.header().get("User-Agent");
    }

    public Option<String> xForwardedFor() {
        return this.header().get("X-Forwarded-For");
    }

    public Option<String> xForwardedProto() {
        return this.header().get("X-Forwarded-Proto");
    }

    public boolean isContentTypeJson() {
        return this.contentType().exists((Function1 & Serializable)_$2 -> _$2.startsWith("application/json"));
    }

    public boolean isContentTypeMsgPack() {
        return this.contentType().exists((Function1 & Serializable)_$3 -> {
            String string = _$3;
            String string2 = "application/msgpack";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public boolean acceptsJson() {
        return this.accept().exists((Function1 & Serializable)x -> {
            String string = x;
            String string2 = "application/json;charset=utf-8";
            return !(string == null ? string2 != null : !string.equals(string2)) || x.startsWith("application/json");
        });
    }

    public boolean acceptsMsgPack() {
        return this.accept().exists((Function1 & Serializable)_$4 -> {
            String string = _$4;
            String string2 = "application/msgpack";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public HttpServerException withHeader(String key, String value) {
        return this.updateWith(this.header().set(key, value));
    }

    public HttpServerException withHeader(HttpMultiMap newHeader) {
        return this.updateWith(newHeader);
    }

    public HttpServerException addHeader(String key, String value) {
        return this.updateWith(this.header().add(key, value));
    }

    public HttpServerException removeHeader(String key) {
        return this.updateWith(this.header().remove(key));
    }

    public HttpServerException withContent(HttpMessage.Message content) {
        return this.updateWith(content);
    }

    public HttpServerException withContent(String content) {
        return this.updateWith(HttpMessage$StringMessage$.MODULE$.apply(content));
    }

    public HttpServerException withContent(byte[] content) {
        return this.updateWith(HttpMessage$.MODULE$.byteArrayMessage(content));
    }

    public HttpServerException withJson(String json) {
        return this.updateWith(HttpMessage$.MODULE$.stringMessage(json)).withContentTypeJson();
    }

    public HttpServerException withMsgPack(byte[] msgPack) {
        return this.updateWith(HttpMessage$.MODULE$.byteArrayMessage(msgPack)).withContentTypeMsgPack();
    }

    public HttpServerException withAccept(String acceptType) {
        return this.withHeader("Accept", acceptType);
    }

    public HttpServerException withAcceptMsgPack() {
        return this.withHeader("Accept", "application/msgpack");
    }

    public HttpServerException withAllow(String allow) {
        return this.withHeader("Allow", allow);
    }

    public HttpServerException withAuthorization(String authorization) {
        return this.withHeader("Authorization", authorization);
    }

    public HttpServerException withCacheControl(String cacheControl) {
        return this.withHeader("Cache-Control", cacheControl);
    }

    public HttpServerException withContentType(String contentType) {
        return this.withHeader("Content-Type", contentType);
    }

    public HttpServerException withContentTypeJson() {
        return this.withContentType("application/json;charset=utf-8");
    }

    public HttpServerException withContentTypeMsgPack() {
        return this.withContentType("application/msgpack");
    }

    public HttpServerException withContentLength(long length) {
        return this.withHeader("Content-Length", BoxesRunTime.boxToLong((long)length).toString());
    }

    public HttpServerException withDate(String date) {
        return this.withHeader("Date", date);
    }

    public HttpServerException withDate(Instant date) {
        return this.withHeader("Date", Http$.MODULE$.formatInstant(date));
    }

    public HttpServerException withExpires(String expires) {
        return this.withHeader("Expires", expires);
    }

    public HttpServerException withHost(String host) {
        return this.withHeader("Host", host);
    }

    public HttpServerException withLastModified(String lastModified) {
        return this.withHeader("Last-Modified", lastModified);
    }

    public HttpServerException withReferer(String referer) {
        return this.withHeader("Referer", referer);
    }

    public HttpServerException withUserAgent(String userAgent) {
        return this.withHeader("User-Agent", userAgent);
    }

    public HttpServerException withXForwardedFor(String xForwardedFor) {
        return this.withHeader("X-Forwarded-For", xForwardedFor);
    }

    public HttpServerException withXForwardedProto(String xForwardedProto) {
        return this.withHeader("X-Forwarded-Proto", xForwardedProto);
    }

    public HttpServerException updateWith(HttpMultiMap newHeader) {
        this.response = (HttpMessage.Response)this.response.withHeader(newHeader);
        return this;
    }

    public HttpServerException updateWith(HttpMessage.Message newMessage) {
        this.response = (HttpMessage.Response)this.response.withContent(newMessage);
        return this;
    }
}

