/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import wvlet.airframe.codec.PackSupport;
import wvlet.airframe.http.HttpStatus$;
import wvlet.airframe.msgpack.spi.Packer;
import wvlet.airframe.msgpack.spi.Unpacker;

public class HttpStatus
implements PackSupport {
    private final int code;

    public static Seq<HttpStatus> knownStatuses() {
        return HttpStatus$.MODULE$.knownStatuses();
    }

    public static HttpStatus ofCode(int n) {
        return HttpStatus$.MODULE$.ofCode(n);
    }

    public static Option<HttpStatus> unapply(String string) {
        return HttpStatus$.MODULE$.unapply(string);
    }

    public static Option<HttpStatus> unpack(Unpacker unpacker) {
        return HttpStatus$.MODULE$.unpack(unpacker);
    }

    public HttpStatus(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public String toString() {
        return new StringBuilder(4).append("[").append(this.code()).append(": ").append(this.reason()).append("]").toString();
    }

    public void pack(Packer p) {
        p.packInt(this.code());
    }

    public String reason() {
        Option option = HttpStatus$.wvlet$airframe$http$HttpStatus$$$reasons.get((Object)this);
        if (option instanceof Some) {
            String reason = (String)((Some)option).value();
            return reason;
        }
        if (this.code() < 100) {
            return "Unknown Status";
        }
        if (this.code() < 200) {
            return "Informational";
        }
        if (this.code() < 300) {
            return "Successful";
        }
        if (this.code() < 400) {
            return "Redirection";
        }
        if (this.code() < 500) {
            return "Client Error";
        }
        if (this.code() < 600) {
            return "Server Error";
        }
        return "Unknown Status";
    }

    public boolean isUnknownState() {
        return HttpStatus$.MODULE$.isUnknownState(this.code());
    }

    public boolean isInformational() {
        return HttpStatus$.MODULE$.isInformational(this.code());
    }

    public boolean isSuccessful() {
        return HttpStatus$.MODULE$.isSuccessful(this.code());
    }

    public boolean isRedirection() {
        return HttpStatus$.MODULE$.isRedirection(this.code());
    }

    public boolean isClientError() {
        return HttpStatus$.MODULE$.isClientError(this.code());
    }

    public boolean isServerError() {
        return HttpStatus$.MODULE$.isServerError(this.code());
    }
}

