/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import wvlet.airframe.codec.PackSupport;
import wvlet.airframe.http.GrpcStatus;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCException$;
import wvlet.airframe.http.RPCStatus$;
import wvlet.airframe.http.RPCStatus$PERMISSION_DENIED_U14$;
import wvlet.airframe.http.RPCStatus$UNAUTHENTICATED_U13$;
import wvlet.airframe.http.RPCStatusType;
import wvlet.airframe.http.RPCStatusType$SUCCESS$;
import wvlet.airframe.msgpack.spi.Packer;
import wvlet.airframe.msgpack.spi.Value;

public abstract class RPCStatus
implements PackSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RPCStatus.class.getDeclaredField("code$lzy1"));
    private final RPCStatusType statusType;
    private final GrpcStatus grpcStatus;
    private volatile Object code$lzy1;
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(RPCStatus$.class.getDeclaredField("httpStatusMapping$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(RPCStatus$.class.getDeclaredField("grpcStatusCodeMapping$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(RPCStatus$.class.getDeclaredField("grpcStatusCodeTable$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(RPCStatus$.class.getDeclaredField("codeNameTable$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RPCStatus$.class.getDeclaredField("codeTable$lzy1"));

    public static Seq<RPCStatus> all() {
        return RPCStatus$.MODULE$.all();
    }

    public static RPCStatus fromGrpcStatusCode(int n) {
        return RPCStatus$.MODULE$.fromGrpcStatusCode(n);
    }

    public static RPCStatus fromHttpStatus(HttpStatus httpStatus) {
        return RPCStatus$.MODULE$.fromHttpStatus(httpStatus);
    }

    public static RPCStatus ofCode(int n) {
        return RPCStatus$.MODULE$.ofCode(n);
    }

    public static RPCStatus ofCodeName(String string) {
        return RPCStatus$.MODULE$.ofCodeName(string);
    }

    public static int ordinal(RPCStatus rPCStatus) {
        return RPCStatus$.MODULE$.ordinal(rPCStatus);
    }

    public static Option<RPCStatus> unapply(String string) {
        return RPCStatus$.MODULE$.unapply(string);
    }

    public static Option<RPCStatus> unapply(Value value) {
        return RPCStatus$.MODULE$.unapply(value);
    }

    public RPCStatus(RPCStatusType statusType, GrpcStatus grpcStatus) {
        this.statusType = statusType;
        this.grpcStatus = grpcStatus;
        if (!statusType.isValidCode(this.code())) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(40).append("Status code ").append(this.code()).append(" is invalid for ").append(statusType).append(" status type").toString());
        }
        if (!statusType.isValidHttpStatus(this.httpStatus())) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(38).append("Unexpected http status ").append(this.httpStatus()).append(" for the code: ").append(this.name()).toString());
        }
    }

    public RPCStatusType statusType() {
        return this.statusType;
    }

    public GrpcStatus grpcStatus() {
        return this.grpcStatus;
    }

    public boolean isSuccess() {
        RPCStatusType rPCStatusType = this.statusType();
        RPCStatusType$SUCCESS$ rPCStatusType$SUCCESS$ = RPCStatusType$SUCCESS$.MODULE$;
        return !(rPCStatusType != null ? !rPCStatusType.equals(rPCStatusType$SUCCESS$) : rPCStatusType$SUCCESS$ != null);
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public boolean shouldReportStackTrace() {
        RPCStatus rPCStatus = this;
        return !RPCStatus$UNAUTHENTICATED_U13$.MODULE$.equals(rPCStatus) && !RPCStatus$PERMISSION_DENIED_U14$.MODULE$.equals(rPCStatus);
        {
        }
    }

    public int code() {
        Object object = this.code$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.code$lzyINIT1());
    }

    private Object code$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.code$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)RPCStatus$.MODULE$.wvlet$airframe$http$RPCStatus$$$extractErrorCode(this.name()));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.code$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String name() {
        return this.toString();
    }

    public HttpStatus httpStatus() {
        return this.grpcStatus().httpStatus();
    }

    public void pack(Packer p) {
        p.packInt(this.code());
    }

    public RPCException newException(String message, Throwable cause, int appErrorCode, Map<String, Object> metadata) {
        return RPCException$.MODULE$.apply(this, message, (Option<Throwable>)Option$.MODULE$.apply((Object)cause), (Option<Object>)(appErrorCode == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)appErrorCode))), metadata);
    }

    public Throwable newException$default$2() {
        return null;
    }

    public int newException$default$3() {
        return -1;
    }

    public Map<String, Object> newException$default$4() {
        return Predef$.MODULE$.Map().empty();
    }
}

