/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.RxRouteFilterBase;
import wvlet.airframe.http.RxRouter$;
import wvlet.airframe.http.RxRouter$EndpointNode$;
import wvlet.airframe.http.RxRouter$FilterNode$;
import wvlet.airframe.http.RxRouter$RxEndpointNode$;
import wvlet.airframe.http.RxRouter$StemNode$;
import wvlet.airframe.http.router.RxRoute;
import wvlet.airframe.http.router.RxRoute$;
import wvlet.airframe.surface.MethodSurface;
import wvlet.airframe.surface.Surface;

public interface RxRouter {
    public static RxRouter of(RxHttpEndpoint rxHttpEndpoint) {
        return RxRouter$.MODULE$.of(rxHttpEndpoint);
    }

    public static RxRouter of(Seq<RxRouter> seq) {
        return RxRouter$.MODULE$.of(seq);
    }

    public String name();

    public Option<FilterNode> filter();

    public List<RxRouter> children();

    public boolean isLeaf();

    public List<RxRoute> routes();

    public RxRouter wrapWithFilter(FilterNode var1);

    public static String toString$(RxRouter $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.printNode(0);
    }

    private String printNode(int indentLevel) {
        Builder s = package$.MODULE$.Seq().newBuilder();
        String ws = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indentLevel * 2);
        s.$plus$eq((Object)new StringBuilder(10).append(ws).append("- Router[").append(this.name()).append("]").toString());
        if (this.isLeaf()) {
            this.routes().foreach((Function1 & Serializable)r -> {
                String rstr = r.toString();
                Object object = Predef$.MODULE$.refArrayOps((Object[])rstr.split("\n"));
                return (Builder[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> (Builder)s.$plus$eq((Object)new StringBuilder(4).append(ws).append("  + ").append((String)x).toString()), ClassTag$.MODULE$.apply(Builder.class));
            });
        }
        this.children().foreach((Function1 & Serializable)c -> (Builder)s.$plus$eq((Object)c.printNode(indentLevel + 1)));
        return ((IterableOnceOps)s.result()).mkString("\n");
    }

    public static class EndpointNode
    implements RxRouter,
    Product,
    Serializable {
        private final Surface controllerSurface;
        private final Seq methodSurfaces;
        private final Option controllerInstance;

        public static EndpointNode apply(Surface surface, Seq<MethodSurface> seq, Option<Object> option) {
            return RxRouter$EndpointNode$.MODULE$.apply(surface, seq, option);
        }

        public static EndpointNode fromProduct(Product product) {
            return RxRouter$EndpointNode$.MODULE$.fromProduct(product);
        }

        public static EndpointNode unapply(EndpointNode endpointNode) {
            return RxRouter$EndpointNode$.MODULE$.unapply(endpointNode);
        }

        public static Option<Object> $lessinit$greater$default$3() {
            return RxRouter$EndpointNode$.MODULE$.$lessinit$greater$default$3();
        }

        public EndpointNode(Surface controllerSurface, Seq<MethodSurface> methodSurfaces, Option<Object> controllerInstance) {
            this.controllerSurface = controllerSurface;
            this.methodSurfaces = methodSurfaces;
            this.controllerInstance = controllerInstance;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EndpointNode)) return false;
            EndpointNode endpointNode = (EndpointNode)object;
            Surface surface = this.controllerSurface();
            Surface surface2 = endpointNode.controllerSurface();
            if (surface == null) {
                if (surface2 != null) {
                    return false;
                }
            } else if (!surface.equals(surface2)) return false;
            Seq<MethodSurface> seq = this.methodSurfaces();
            Seq<MethodSurface> seq2 = endpointNode.methodSurfaces();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Option<Object> option = this.controllerInstance();
            Option<Object> option2 = endpointNode.controllerInstance();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!endpointNode.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof EndpointNode;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "EndpointNode";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "controllerSurface";
                }
                case 1: {
                    return "methodSurfaces";
                }
                case 2: {
                    return "controllerInstance";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Surface controllerSurface() {
            return this.controllerSurface;
        }

        public Seq<MethodSurface> methodSurfaces() {
            return this.methodSurfaces;
        }

        public Option<Object> controllerInstance() {
            return this.controllerInstance;
        }

        @Override
        public String name() {
            return this.controllerSurface().name();
        }

        @Override
        public Option<FilterNode> filter() {
            return None$.MODULE$;
        }

        @Override
        public List<RxRouter> children() {
            return package$.MODULE$.Nil();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public RxRouter wrapWithFilter(FilterNode parentFilter) {
            return RxRouter$StemNode$.MODULE$.apply((Option<FilterNode>)Some$.MODULE$.apply((Object)parentFilter), (List<RxRouter>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndpointNode[]{this}))));
        }

        @Override
        public List<RxRoute> routes() {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RxRoute[]{RxRoute$.MODULE$.apply((Option<FilterNode>)None$.MODULE$, this.controllerSurface(), this.methodSurfaces())}));
        }

        public EndpointNode copy(Surface controllerSurface, Seq<MethodSurface> methodSurfaces, Option<Object> controllerInstance) {
            return new EndpointNode(controllerSurface, methodSurfaces, controllerInstance);
        }

        public Surface copy$default$1() {
            return this.controllerSurface();
        }

        public Seq<MethodSurface> copy$default$2() {
            return this.methodSurfaces();
        }

        public Option<Object> copy$default$3() {
            return this.controllerInstance();
        }

        public Surface _1() {
            return this.controllerSurface();
        }

        public Seq<MethodSurface> _2() {
            return this.methodSurfaces();
        }

        public Option<Object> _3() {
            return this.controllerInstance();
        }
    }

    public static class FilterNode
    implements RxRouteFilterBase,
    Product,
    Serializable {
        private final Option parent;
        private final Surface filterSurface;

        public static FilterNode apply(Option<FilterNode> option, Surface surface) {
            return RxRouter$FilterNode$.MODULE$.apply(option, surface);
        }

        public static FilterNode fromProduct(Product product) {
            return RxRouter$FilterNode$.MODULE$.fromProduct(product);
        }

        public static FilterNode unapply(FilterNode filterNode) {
            return RxRouter$FilterNode$.MODULE$.unapply(filterNode);
        }

        public FilterNode(Option<FilterNode> parent, Surface filterSurface) {
            this.parent = parent;
            this.filterSurface = filterSurface;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FilterNode)) return false;
            FilterNode filterNode = (FilterNode)object;
            Option<FilterNode> option = this.parent();
            Option<FilterNode> option2 = filterNode.parent();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Surface surface = this.filterSurface();
            Surface surface2 = filterNode.filterSurface();
            if (surface == null) {
                if (surface2 != null) {
                    return false;
                }
            } else if (!surface.equals(surface2)) return false;
            if (!filterNode.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FilterNode;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "FilterNode";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "parent";
            }
            if (1 == n2) {
                return "filterSurface";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<FilterNode> parent() {
            return this.parent;
        }

        public Surface filterSurface() {
            return this.filterSurface;
        }

        public String name() {
            return this.filterSurface().name();
        }

        public FilterNode andThen(FilterNode next) {
            return next.copy((Option<FilterNode>)Some$.MODULE$.apply((Object)this), next.copy$default$2());
        }

        public Option<FilterNode> andThenOpt(Option<FilterNode> next) {
            Option<FilterNode> option = next;
            if (option instanceof Some) {
                FilterNode f = (FilterNode)((Some)option).value();
                return Some$.MODULE$.apply((Object)this.andThen(f));
            }
            if (None$.MODULE$.equals(option)) {
                return Some$.MODULE$.apply((Object)this);
            }
            throw new MatchError(option);
        }

        public RxRouter andThen(Seq<RxRouter> next) {
            return RxRouter$.MODULE$.of(next).wrapWithFilter(this);
        }

        public FilterNode copy(Option<FilterNode> parent, Surface filterSurface) {
            return new FilterNode(parent, filterSurface);
        }

        public Option<FilterNode> copy$default$1() {
            return this.parent();
        }

        public Surface copy$default$2() {
            return this.filterSurface();
        }

        public Option<FilterNode> _1() {
            return this.parent();
        }

        public Surface _2() {
            return this.filterSurface();
        }
    }

    public static class RxEndpointNode
    implements RxRouter,
    Product,
    Serializable {
        private final RxHttpEndpoint endpoint;

        public static RxEndpointNode apply(RxHttpEndpoint rxHttpEndpoint) {
            return RxRouter$RxEndpointNode$.MODULE$.apply(rxHttpEndpoint);
        }

        public static RxEndpointNode fromProduct(Product product) {
            return RxRouter$RxEndpointNode$.MODULE$.fromProduct(product);
        }

        public static RxEndpointNode unapply(RxEndpointNode rxEndpointNode) {
            return RxRouter$RxEndpointNode$.MODULE$.unapply(rxEndpointNode);
        }

        public RxEndpointNode(RxHttpEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RxEndpointNode)) return false;
            RxEndpointNode rxEndpointNode = (RxEndpointNode)object;
            RxHttpEndpoint rxHttpEndpoint = this.endpoint();
            RxHttpEndpoint rxHttpEndpoint2 = rxEndpointNode.endpoint();
            if (rxHttpEndpoint == null) {
                if (rxHttpEndpoint2 != null) {
                    return false;
                }
            } else if (!rxHttpEndpoint.equals(rxHttpEndpoint2)) return false;
            if (!rxEndpointNode.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof RxEndpointNode;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RxEndpointNode";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "endpoint";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public RxHttpEndpoint endpoint() {
            return this.endpoint;
        }

        @Override
        public String name() {
            return StringOps$.MODULE$.format$extension("%08x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode())}));
        }

        @Override
        public Option<FilterNode> filter() {
            return None$.MODULE$;
        }

        @Override
        public List<RxRouter> children() {
            return package$.MODULE$.Nil();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public RxRouter wrapWithFilter(FilterNode parentFilter) {
            return RxRouter$StemNode$.MODULE$.apply((Option<FilterNode>)Some$.MODULE$.apply((Object)parentFilter), (List<RxRouter>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RxEndpointNode[]{this}))));
        }

        @Override
        public List<RxRoute> routes() {
            return package$.MODULE$.List().empty();
        }

        public RxEndpointNode copy(RxHttpEndpoint endpoint) {
            return new RxEndpointNode(endpoint);
        }

        public RxHttpEndpoint copy$default$1() {
            return this.endpoint();
        }

        public RxHttpEndpoint _1() {
            return this.endpoint();
        }
    }

    public static class StemNode
    implements RxRouter,
    Product,
    Serializable {
        private final Option filter;
        private final List children;

        public static StemNode apply(Option<FilterNode> option, List<RxRouter> list) {
            return RxRouter$StemNode$.MODULE$.apply(option, list);
        }

        public static StemNode fromProduct(Product product) {
            return RxRouter$StemNode$.MODULE$.fromProduct(product);
        }

        public static StemNode unapply(StemNode stemNode) {
            return RxRouter$StemNode$.MODULE$.unapply(stemNode);
        }

        public static Option<FilterNode> $lessinit$greater$default$1() {
            return RxRouter$StemNode$.MODULE$.$lessinit$greater$default$1();
        }

        public StemNode(Option<FilterNode> filter, List<RxRouter> children) {
            this.filter = filter;
            this.children = children;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StemNode)) return false;
            StemNode stemNode = (StemNode)object;
            Option<FilterNode> option = this.filter();
            Option<FilterNode> option2 = stemNode.filter();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            List<RxRouter> list = this.children();
            List<RxRouter> list2 = stemNode.children();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!stemNode.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof StemNode;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StemNode";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "filter";
            }
            if (1 == n2) {
                return "children";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Option<FilterNode> filter() {
            return this.filter;
        }

        @Override
        public List<RxRouter> children() {
            return this.children;
        }

        @Override
        public String name() {
            return StringOps$.MODULE$.format$extension("%08x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.hashCode())}));
        }

        @Override
        public RxRouter wrapWithFilter(FilterNode parentFilter) {
            return this.copy(parentFilter.andThenOpt(this.filter()), this.copy$default$2());
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public List<RxRoute> routes() {
            return this.children().flatMap((Function1 & Serializable)c -> c.routes().map((Function1 & Serializable)r -> r.wrapWithFilter(this.filter())));
        }

        public StemNode copy(Option<FilterNode> filter, List<RxRouter> children) {
            return new StemNode(filter, children);
        }

        public Option<FilterNode> copy$default$1() {
            return this.filter();
        }

        public List<RxRouter> copy$default$2() {
            return this.children();
        }

        public Option<FilterNode> _1() {
            return this.filter();
        }

        public List<RxRouter> _2() {
            return this.children();
        }
    }
}

