/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.client;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.runtime.ObjectRef;
import wvlet.airframe.control.CircuitBreaker;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.RPCException$;
import wvlet.airframe.http.RPCMethod;
import wvlet.airframe.http.client.AsyncClientCompat;
import wvlet.airframe.http.client.HttpChannel;
import wvlet.airframe.http.client.HttpClientConfig;
import wvlet.airframe.http.client.HttpClientContext;
import wvlet.airframe.http.client.HttpClientContext$;
import wvlet.airframe.http.client.HttpClientContext$empty$;
import wvlet.airframe.http.client.HttpClientFactory;
import wvlet.airframe.http.client.HttpClientFilter;
import wvlet.airframe.http.client.HttpClients$;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.surface.Surface;

public interface AsyncClient
extends AsyncClientCompat,
HttpClientFactory<AsyncClient>,
AutoCloseable {
    public static void $init$(AsyncClient $this) {
        $this.wvlet$airframe$http$client$AsyncClient$_setter_$wvlet$airframe$http$client$AsyncClient$$httpLogger_$eq($this.config().newHttpLogger());
        $this.wvlet$airframe$http$client$AsyncClient$_setter_$wvlet$airframe$http$client$AsyncClient$$loggingFilter_$eq($this.config().newLoggingFilter($this.wvlet$airframe$http$client$AsyncClient$$httpLogger()));
        $this.wvlet$airframe$http$client$AsyncClient$_setter_$wvlet$airframe$http$client$AsyncClient$$circuitBreaker_$eq($this.config().circuitBreaker());
    }

    public HttpChannel channel();

    @Override
    public HttpClientConfig config();

    public HttpLogger wvlet$airframe$http$client$AsyncClient$$httpLogger();

    public void wvlet$airframe$http$client$AsyncClient$_setter_$wvlet$airframe$http$client$AsyncClient$$httpLogger_$eq(HttpLogger var1);

    public HttpClientFilter wvlet$airframe$http$client$AsyncClient$$loggingFilter();

    public void wvlet$airframe$http$client$AsyncClient$_setter_$wvlet$airframe$http$client$AsyncClient$$loggingFilter_$eq(HttpClientFilter var1);

    public CircuitBreaker wvlet$airframe$http$client$AsyncClient$$circuitBreaker();

    public void wvlet$airframe$http$client$AsyncClient$_setter_$wvlet$airframe$http$client$AsyncClient$$circuitBreaker_$eq(CircuitBreaker var1);

    public static void close$(AsyncClient $this) {
        $this.close();
    }

    @Override
    default public void close() {
        this.wvlet$airframe$http$client$AsyncClient$$httpLogger().close();
    }

    public static Rx send$(AsyncClient $this, HttpMessage.Request req, HttpClientContext context) {
        return $this.send(req, context);
    }

    default public Rx<HttpMessage.Response> send(HttpMessage.Request req, HttpClientContext context) {
        HttpMessage.Request request = (HttpMessage.Request)this.config().requestFilter().apply((Object)req);
        ObjectRef lastResponse = ObjectRef.create((Object)None$.MODULE$);
        return this.config().retryContext().runAsyncWithContext((Object)request, this.wvlet$airframe$http$client$AsyncClient$$circuitBreaker(), () -> this.send$$anonfun$2(context, request, lastResponse)).recover(HttpClients$.MODULE$.defaultHttpClientErrorHandler((Option<HttpMessage.Response>)((Option)lastResponse.elem)));
    }

    public static HttpClientContext send$default$2$(AsyncClient $this) {
        return $this.send$default$2();
    }

    default public HttpClientContext send$default$2() {
        return HttpClientContext$empty$.MODULE$;
    }

    public static Rx sendSafe$(AsyncClient $this, HttpMessage.Request req, HttpClientContext context) {
        return $this.sendSafe(req, context);
    }

    default public Rx<HttpMessage.Response> sendSafe(HttpMessage.Request req, HttpClientContext context) {
        return this.send(req, context).toRx().recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof HttpClientException) {
                    HttpClientException e = (HttpClientException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof HttpClientException) {
                    HttpClientException e = (HttpClientException)throwable;
                    return e.response().toHttpResponse();
                }
                return function1.apply((Object)x);
            }
        });
    }

    public static HttpClientContext sendSafe$default$2$(AsyncClient $this) {
        return $this.sendSafe$default$2();
    }

    default public HttpClientContext sendSafe$default$2() {
        return HttpClientContext$empty$.MODULE$;
    }

    public static Rx readAsInternal$(AsyncClient $this, HttpMessage.Request req, Surface responseSurface) {
        return $this.readAsInternal(req, responseSurface);
    }

    default public <Resp> Rx<Resp> readAsInternal(HttpMessage.Request req, Surface responseSurface) {
        return this.send(req, this.send$default$2()).toRx().map((Function1 & Serializable)resp -> HttpClients$.MODULE$.parseResponse(this.config(), responseSurface, (HttpMessage.Response)resp));
    }

    public static Rx callInternal$(AsyncClient $this, HttpMessage.Request req, Surface requestSurface, Surface responseSurface, Object requestContent) {
        return $this.callInternal(req, requestSurface, responseSurface, requestContent);
    }

    default public <Req, Resp> Rx<Resp> callInternal(HttpMessage.Request req, Surface requestSurface, Surface responseSurface, Req requestContent) {
        return Rx$.MODULE$.const(() -> this.callInternal$$anonfun$1(req, requestSurface, requestContent)).flatMap((Function1 & Serializable)newRequest -> this.send((HttpMessage.Request)newRequest, HttpClientContext$.MODULE$.apply(this.config().name(), HttpClientContext$.MODULE$.$lessinit$greater$default$2(), HttpClientContext$.MODULE$.$lessinit$greater$default$3())).toRx().map((Function1 & Serializable)resp -> HttpClients$.MODULE$.parseResponse(this.config(), responseSurface, (HttpMessage.Response)resp)));
    }

    public static Rx rpc$(AsyncClient $this, RPCMethod method, Object requestContent) {
        return $this.rpc(method, requestContent);
    }

    default public <Req, Resp> Rx<Resp> rpc(RPCMethod method, Req requestContent) {
        return Rx$.MODULE$.const(() -> this.rpc$$anonfun$1(method, requestContent)).flatMap((Function1 & Serializable)request -> {
            HttpClientContext context = HttpClientContext$.MODULE$.apply(this.config().name(), (Option<RPCMethod>)Some$.MODULE$.apply((Object)method), (Option<Object>)Some$.MODULE$.apply(requestContent));
            return this.sendSafe((HttpMessage.Request)request, context).toRx().map((Function1 & Serializable)response -> {
                if (response.status().isSuccessful()) {
                    Object ret = HttpClients$.MODULE$.parseRPCResponse(this.config(), (HttpMessage.Response)response, method.responseSurface());
                    return ret;
                }
                throw RPCException$.MODULE$.fromResponse((HttpMessage.Response)response);
            });
        });
    }

    private Rx send$$anonfun$2(HttpClientContext context$2, HttpMessage.Request request$2, ObjectRef lastResponse$3) {
        return this.wvlet$airframe$http$client$AsyncClient$$loggingFilter().andThen(this.config().clientFilter()).apply(context$2).andThen(req -> this.channel().sendAsync(req, this.config())).apply(request$2).map((Function1 & Serializable)resp -> {
            Some some = Some$.MODULE$.apply(resp);
            lastResponse$4.elem = some;
            some = null;
            return resp;
        });
    }

    private HttpMessage.Request callInternal$$anonfun$1(HttpMessage.Request req$2, Surface requestSurface$1, Object requestContent$1) {
        return HttpClients$.MODULE$.prepareRequest(this.config(), req$2, requestSurface$1, requestContent$1);
    }

    private HttpMessage.Request rpc$$anonfun$1(RPCMethod method$1, Object requestContent$2) {
        return HttpClients$.MODULE$.prepareRPCRequest(this.config(), method$1.path(), method$1.requestSurface(), requestContent$2);
    }
}

