/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.client;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.PrimitiveCodec;
import wvlet.airframe.control.CircuitBreakerOpenException;
import wvlet.airframe.control.Retry;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpClient$;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpClientMaxRetryException$;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMessage$;
import wvlet.airframe.http.HttpMessage$HttpMessageResponseAdapter$;
import wvlet.airframe.http.HttpStatus$BadRequest_400$;
import wvlet.airframe.http.HttpStatus$InternalServerError_500$;
import wvlet.airframe.http.HttpStatus$ServiceUnavailable_503$;
import wvlet.airframe.http.RPCEncoding;
import wvlet.airframe.http.RPCEncoding$JSON$;
import wvlet.airframe.http.RPCEncoding$MsgPack$;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCException$;
import wvlet.airframe.http.RPCStatus$DATA_LOSS_I8$;
import wvlet.airframe.http.RPCStatus$INVALID_ARGUMENT_U2$;
import wvlet.airframe.http.client.HttpClientConfig;
import wvlet.airframe.http.internal.HttpResponseBodyCodec;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClients$
implements LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HttpClients$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private static final HttpResponseBodyCodec<HttpMessage.Response> responseBodyCodec;
    public static final HttpClients$ MODULE$;

    private HttpClients$() {
    }

    static {
        MODULE$ = new HttpClients$();
        responseBodyCodec = new HttpResponseBodyCodec<HttpMessage.Response>(HttpMessage$HttpMessageResponseAdapter$.MODULE$);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClients$.class);
    }

    public PartialFunction<Throwable, Nothing$> defaultHttpClientErrorHandler(Option<HttpMessage.Response> lastResponse) {
        return new Serializable(lastResponse){
            private final Option lastResponse$5;
            {
                this.lastResponse$5 = lastResponse$6;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof HttpClientException) {
                    HttpClientException e = (HttpClientException)throwable;
                    return true;
                }
                if (throwable instanceof CircuitBreakerOpenException) {
                    CircuitBreakerOpenException e = (CircuitBreakerOpenException)throwable;
                    return true;
                }
                if (throwable instanceof Retry.MaxRetryException) {
                    Retry.MaxRetryException e = (Retry.MaxRetryException)throwable;
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof HttpClientException) {
                    HttpClientException e = (HttpClientException)throwable;
                    HttpMessage.Response resp = e.response().toHttpResponse();
                    Option option2 = resp.getHeader("x-airframe-rpc-status");
                    if (option2 instanceof Some) {
                        String status = (String)((Some)option2).value();
                        RPCException ex = RPCException$.MODULE$.fromResponse(e.response().toHttpResponse());
                        throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), ex.status().httpStatus(), ex.message(), ex);
                    }
                    if (None$.MODULE$.equals(option2)) {
                        throw e;
                    }
                    throw new MatchError((Object)option2);
                }
                if (throwable instanceof CircuitBreakerOpenException) {
                    CircuitBreakerOpenException e = (CircuitBreakerOpenException)throwable;
                    HttpMessage.Response resp = (HttpMessage.Response)this.lastResponse$5.getOrElse(HttpClients$::wvlet$airframe$http$client$HttpClients$$anon$2$$_$_$$anonfun$1);
                    throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), e.getMessage(), (Throwable)e);
                }
                if (throwable instanceof Retry.MaxRetryException) {
                    Retry.MaxRetryException e = (Retry.MaxRetryException)throwable;
                    throw HttpClientMaxRetryException$.MODULE$.apply(HttpMessage$.MODULE$.HttpMessageResponseWrapper((HttpMessage.Response)this.lastResponse$5.getOrElse(HttpClients$::wvlet$airframe$http$client$HttpClients$$anon$2$$_$applyOrElse$$anonfun$1)), e.retryContext(), e.retryContext().lastError());
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    HttpMessage.Response resp = (HttpMessage.Response)this.lastResponse$5.getOrElse(HttpClients$::wvlet$airframe$http$client$HttpClients$$anon$2$$_$_$$anonfun$2);
                    throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), e.getMessage(), e);
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{wvlet$airframe$http$client$HttpClients$$anon$2$$_$_$$anonfun$1(), wvlet$airframe$http$client$HttpClients$$anon$2$$_$applyOrElse$$anonfun$1(), wvlet$airframe$http$client$HttpClients$$anon$2$$_$_$$anonfun$2()}, serializedLambda);
            }
        };
    }

    public <Req> HttpMessage.Request prepareRequest(HttpClientConfig config, HttpMessage.Request baseRequest, Surface requestSurface, Req requestBody) {
        HttpMessage.Request request;
        block5: {
            try {
                String string = baseRequest.method();
                if ("GET".equals(string)) {
                    String newPath = HttpClient$.MODULE$.buildResourceUri(baseRequest.path(), requestBody, requestSurface);
                    request = baseRequest.withUri(newPath);
                    break block5;
                }
                MessageCodec requestCodec = config.codecFactory().ofSurface(requestSurface, config.codecFactory().ofSurface$default$2());
                byte[] bytes = config.rpcEncoding().encodeWithCodec(requestBody, requestCodec);
                RPCEncoding rPCEncoding = config.rpcEncoding();
                if (RPCEncoding$MsgPack$.MODULE$.equals(rPCEncoding)) {
                    request = (HttpMessage.Request)baseRequest.withMsgPack(bytes);
                    break block5;
                }
                if (RPCEncoding$JSON$.MODULE$.equals(rPCEncoding)) {
                    request = (HttpMessage.Request)baseRequest.withJson(bytes);
                    break block5;
                }
                throw new MatchError((Object)rPCEncoding);
            }
            catch (Throwable e) {
                throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(Http$.MODULE$.response(HttpStatus$BadRequest_400$.MODULE$)), HttpStatus$BadRequest_400$.MODULE$, new StringBuilder(40).append("Failed to encode the HTTP request body: ").append(requestBody).toString(), e);
            }
        }
        return request;
    }

    public <Resp> Resp parseResponse(HttpClientConfig config, Surface responseSurface, HttpMessage.Response resp) {
        Object object;
        if (HttpMessage.Response.class.isAssignableFrom(responseSurface.rawType())) {
            return (Resp)resp;
        }
        try {
            Object responseObject;
            MessageCodec codec;
            byte[] msgpack = responseBodyCodec.toMsgPack(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp));
            MessageCodec messageCodec = codec = config.codecFactory().ofSurface(responseSurface, config.codecFactory().ofSurface$default$2());
            object = PrimitiveCodec.UnitCodec$.MODULE$.equals(messageCodec) ? null : (responseObject = codec.fromMsgPack(msgpack));
        }
        catch (Throwable e) {
            throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), new StringBuilder(48).append("Failed to parse the response from the server: ").append(resp).append(": ").append(e.getMessage()).toString(), e);
        }
        return (Resp)object;
    }

    public HttpMessage.Request prepareRPCRequest(HttpClientConfig config, String resourcePath, Surface requestSurface, Object requestContent) {
        HttpMessage.Request request;
        MessageCodec requestEncoder = config.codecFactory().ofSurface(requestSurface, config.codecFactory().ofSurface$default$2());
        try {
            request = (HttpMessage.Request)((HttpMessage)Http$.MODULE$.POST(resourcePath).withContentType(config.rpcEncoding().applicationType())).withContent(config.rpcEncoding().encodeWithCodec(requestContent, requestEncoder));
        }
        catch (Throwable e) {
            throw RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException(new StringBuilder(44).append("Failed to encode the RPC request argument ").append(requestContent).append(": ").append(e.getMessage()).toString(), e, RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException$default$3(), RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException$default$4());
        }
        return request;
    }

    public Object parseRPCResponse(HttpClientConfig config, HttpMessage.Response response, Surface responseSurface) {
        Object object;
        if (HttpMessage.Response.class.isAssignableFrom(responseSurface.rawType())) {
            return response;
        }
        try {
            Object responseObject;
            MessageCodec codec;
            byte[] msgpack = responseBodyCodec.toMsgPack(HttpMessage$.MODULE$.HttpMessageResponseWrapper(response));
            MessageCodec messageCodec = codec = config.codecFactory().ofSurface(responseSurface, config.codecFactory().ofSurface$default$2());
            object = PrimitiveCodec.UnitCodec$.MODULE$.equals(messageCodec) ? null : (responseObject = codec.fromMsgPack(msgpack));
        }
        catch (Throwable e) {
            throw RPCStatus$DATA_LOSS_I8$.MODULE$.newException(new StringBuilder(51).append("Failed to parse the RPC response from the server ").append(response).append(": ").append(e.getMessage()).toString(), e, RPCStatus$DATA_LOSS_I8$.MODULE$.newException$default$3(), RPCStatus$DATA_LOSS_I8$.MODULE$.newException$default$4());
        }
        return object;
    }

    public static final HttpMessage.Response wvlet$airframe$http$client$HttpClients$$anon$2$$_$_$$anonfun$1() {
        return Http$.MODULE$.response(HttpStatus$ServiceUnavailable_503$.MODULE$);
    }

    public static final HttpMessage.Response wvlet$airframe$http$client$HttpClients$$anon$2$$_$applyOrElse$$anonfun$1() {
        return Http$.MODULE$.response(HttpStatus$InternalServerError_500$.MODULE$);
    }

    public static final HttpMessage.Response wvlet$airframe$http$client$HttpClients$$anon$2$$_$_$$anonfun$2() {
        return Http$.MODULE$.response(HttpStatus$InternalServerError_500$.MODULE$);
    }
}

