/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.client;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import wvlet.airframe.control.Control$;
import wvlet.airframe.control.IO$;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMessage$;
import wvlet.airframe.http.HttpMessage$EmptyMessage$;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpMultiMap$;
import wvlet.airframe.http.HttpStatus$;
import wvlet.airframe.http.ServerAddress;
import wvlet.airframe.http.client.HttpChannel;
import wvlet.airframe.http.client.HttpChannelConfig;
import wvlet.airframe.http.client.HttpClientConfig;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.rx.RxVar;

public class JavaHttpClientChannel
implements HttpChannel {
    private final ServerAddress serverAddress;
    private final HttpClientConfig config;
    private final HttpClient javaHttpClient;

    public JavaHttpClientChannel(ServerAddress serverAddress, HttpClientConfig config) {
        this.serverAddress = serverAddress;
        this.config = config;
        this.javaHttpClient = this.initClient(config);
    }

    public HttpClientConfig config() {
        return this.config;
    }

    private HttpClient initClient(HttpClientConfig config) {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    @Override
    public void close() {
    }

    @Override
    public HttpMessage.Response send(HttpMessage.Request req, HttpChannelConfig channelConfig) {
        HttpRequest httpRequest = this.buildRequest(this.serverAddress, req, channelConfig);
        HttpResponse<InputStream> httpResponse = this.javaHttpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
        return this.wvlet$airframe$http$client$JavaHttpClientChannel$$readResponse(httpResponse);
    }

    @Override
    public Rx<HttpMessage.Response> sendAsync(HttpMessage.Request req, HttpChannelConfig channelConfig) {
        Object object;
        RxVar v = Rx$.MODULE$.variable((Object)None$.MODULE$);
        try {
            HttpRequest httpRequest = this.buildRequest(this.serverAddress, req, channelConfig);
            object = ((CompletableFuture)this.javaHttpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).thenAccept((Consumer)new Consumer<HttpResponse<InputStream>>(v, this){
                private final RxVar v$1;
                private final /* synthetic */ JavaHttpClientChannel $outer;
                {
                    this.v$1 = v$3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void accept(HttpResponse r) {
                    HttpMessage.Response resp = this.$outer.wvlet$airframe$http$client$JavaHttpClientChannel$$readResponse(r);
                    this.v$1.set((Object)Some$.MODULE$.apply((Object)resp));
                    this.v$1.stop();
                }
            })).exceptionally(ex -> {
                v.setException(ex);
                return null;
            });
        }
        catch (Throwable e) {
            v.setException(e);
            object = BoxedUnit.UNIT;
        }
        return v.filter((Function1 & Serializable)_$1 -> _$1.isDefined()).map((Function1 & Serializable)_$2 -> (HttpMessage.Response)_$2.get());
    }

    private HttpRequest buildRequest(ServerAddress serverAddress, HttpMessage.Request request, HttpChannelConfig channelConfig) {
        HttpRequest.BodyPublisher bodyPublisher;
        String uri = new StringBuilder(0).append(serverAddress.uri()).append(request.uri().startsWith("/") ? request.uri() : new StringBuilder(1).append("/").append(request.uri()).toString()).toString();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create(uri)).timeout(Duration.ofMillis(channelConfig.readTimeout().toMillis()));
        request.header().entries().foreach((Function1 & Serializable)h -> requestBuilder.setHeader(h.key(), h.value()));
        String string = request.method();
        HttpMessage.Message message = request.message();
        if (HttpMessage$EmptyMessage$.MODULE$.equals(message)) {
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        } else if (message instanceof HttpMessage.StringMessage) {
            HttpMessage.StringMessage s = (HttpMessage.StringMessage)message;
            bodyPublisher = HttpRequest.BodyPublishers.ofString(s.toContentString());
        } else {
            HttpMessage.Message m = message;
            bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(m.toContentBytes());
        }
        requestBuilder.method(string, bodyPublisher);
        return requestBuilder.build();
    }

    /*
     * Unable to fully structure code
     */
    public HttpMessage.Response wvlet$airframe$http$client$JavaHttpClientChannel$$readResponse(HttpResponse<InputStream> httpResponse) {
        h = HttpMultiMap$.MODULE$.newBuilder();
        CollectionConverters$.MODULE$.MapHasAsScala(httpResponse.headers().map()).asScala().foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$1(wvlet.airframe.http.HttpMultiMap$HttpMultiMapBuilder scala.Tuple2 ), (Lscala/Tuple2;)V)((HttpMultiMap.HttpMultiMapBuilder)h));
        header = h.result();
        var5_4 = header.get("Content-Encoding").map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        if (!(var5_4 instanceof Some)) ** GOTO lbl-1000
        var6_5 = (String)((Some)var5_4).value();
        if ("gzip".equals(var6_5)) {
            v0 = new GZIPInputStream(httpResponse.body());
        } else if ("deflate".equals(var6_5)) {
            v0 = new InflaterInputStream(httpResponse.body());
        } else lbl-1000:
        // 2 sources

        {
            v0 = httpResponse.body();
        }
        body = (byte[])Control$.MODULE$.withResource((AutoCloseable)v0, (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$3(java.io.InputStream ), (Ljava/io/InputStream;)[B)());
        return (HttpMessage.Response)((HttpMessage)Http$.MODULE$.response(HttpStatus$.MODULE$.ofCode(httpResponse.statusCode())).withHeader(header)).withContent(HttpMessage$.MODULE$.byteArrayMessage(body));
    }

    private static final /* synthetic */ void $anonfun$1(HttpMultiMap.HttpMultiMapBuilder h$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            List values = (List)tuple2._2();
            if (!key.startsWith(":")) {
                CollectionConverters$.MODULE$.ListHasAsScala(values).asScala().foreach((Function1 & Serializable)v -> h$1.add(key, (String)v));
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ String $anonfun$2(String _$3) {
        return _$3.toLowerCase();
    }

    private static final /* synthetic */ byte[] $anonfun$3(InputStream in) {
        return IO$.MODULE$.readFully(in);
    }
}

