/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.client;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import wvlet.airframe.control.CircuitBreaker;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.RPCException$;
import wvlet.airframe.http.RPCMethod;
import wvlet.airframe.http.client.HttpChannel;
import wvlet.airframe.http.client.HttpClientConfig;
import wvlet.airframe.http.client.HttpClientContext;
import wvlet.airframe.http.client.HttpClientContext$;
import wvlet.airframe.http.client.HttpClientContext$empty$;
import wvlet.airframe.http.client.HttpClientFactory;
import wvlet.airframe.http.client.HttpClientFilter;
import wvlet.airframe.http.client.HttpClients$;
import wvlet.airframe.http.client.SyncClientCompat;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.surface.Surface;

public interface SyncClient
extends SyncClientCompat,
HttpClientFactory<SyncClient>,
AutoCloseable {
    public static void $init$(SyncClient $this) {
        $this.wvlet$airframe$http$client$SyncClient$_setter_$wvlet$airframe$http$client$SyncClient$$clientLogger_$eq($this.config().newHttpLogger());
        $this.wvlet$airframe$http$client$SyncClient$_setter_$wvlet$airframe$http$client$SyncClient$$loggingFilter_$eq($this.config().newLoggingFilter($this.wvlet$airframe$http$client$SyncClient$$clientLogger()));
        $this.wvlet$airframe$http$client$SyncClient$_setter_$wvlet$airframe$http$client$SyncClient$$circuitBreaker_$eq($this.config().circuitBreaker());
    }

    public HttpChannel channel();

    @Override
    public HttpClientConfig config();

    public HttpLogger wvlet$airframe$http$client$SyncClient$$clientLogger();

    public void wvlet$airframe$http$client$SyncClient$_setter_$wvlet$airframe$http$client$SyncClient$$clientLogger_$eq(HttpLogger var1);

    public HttpClientFilter wvlet$airframe$http$client$SyncClient$$loggingFilter();

    public void wvlet$airframe$http$client$SyncClient$_setter_$wvlet$airframe$http$client$SyncClient$$loggingFilter_$eq(HttpClientFilter var1);

    public CircuitBreaker wvlet$airframe$http$client$SyncClient$$circuitBreaker();

    public void wvlet$airframe$http$client$SyncClient$_setter_$wvlet$airframe$http$client$SyncClient$$circuitBreaker_$eq(CircuitBreaker var1);

    public static void close$(SyncClient $this) {
        $this.close();
    }

    @Override
    default public void close() {
        this.wvlet$airframe$http$client$SyncClient$$clientLogger().close();
    }

    public static HttpMessage.Response send$(SyncClient $this, HttpMessage.Request req, HttpClientContext context) {
        return $this.send(req, context);
    }

    default public HttpMessage.Response send(HttpMessage.Request req, HttpClientContext context) {
        HttpMessage.Response response;
        HttpMessage.Request request = (HttpMessage.Request)this.config().requestFilter().apply((Object)req);
        ObjectRef lastResponse = ObjectRef.create((Object)None$.MODULE$);
        try {
            response = (HttpMessage.Response)this.config().retryContext().runWithContext((Object)request, this.wvlet$airframe$http$client$SyncClient$$circuitBreaker(), () -> this.send$$anonfun$1(context, request, lastResponse));
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, Nothing$> $1$ = HttpClients$.MODULE$.defaultHttpClientErrorHandler((Option<HttpMessage.Response>)((Option)lastResponse.elem));
            if ($1$.isDefinedAt((Object)ex$)) {
                response = (HttpMessage.Response)$1$.apply((Object)ex$);
            }
            throw ex$;
        }
        return response;
    }

    public static HttpClientContext send$default$2$(SyncClient $this) {
        return $this.send$default$2();
    }

    default public HttpClientContext send$default$2() {
        return HttpClientContext$empty$.MODULE$;
    }

    public static HttpMessage.Response sendSafe$(SyncClient $this, HttpMessage.Request req, HttpClientContext context) {
        return $this.sendSafe(req, context);
    }

    default public HttpMessage.Response sendSafe(HttpMessage.Request req, HttpClientContext context) {
        HttpMessage.Response response;
        try {
            response = this.send(req, context);
        }
        catch (HttpClientException e) {
            response = e.response().toHttpResponse();
        }
        return response;
    }

    public static HttpClientContext sendSafe$default$2$(SyncClient $this) {
        return $this.sendSafe$default$2();
    }

    default public HttpClientContext sendSafe$default$2() {
        return HttpClientContext$empty$.MODULE$;
    }

    public static Object readAsInternal$(SyncClient $this, HttpMessage.Request req, Surface responseSurface) {
        return $this.readAsInternal(req, responseSurface);
    }

    default public <Resp> Resp readAsInternal(HttpMessage.Request req, Surface responseSurface) {
        HttpMessage.Response resp = this.send(req, HttpClientContext$.MODULE$.apply(this.config().name(), HttpClientContext$.MODULE$.$lessinit$greater$default$2(), HttpClientContext$.MODULE$.$lessinit$greater$default$3()));
        return HttpClients$.MODULE$.parseResponse(this.config(), responseSurface, resp);
    }

    public static Object callInternal$(SyncClient $this, HttpMessage.Request req, Surface requestSurface, Surface responseSurface, Object requestContent) {
        return $this.callInternal(req, requestSurface, responseSurface, requestContent);
    }

    default public <Req, Resp> Resp callInternal(HttpMessage.Request req, Surface requestSurface, Surface responseSurface, Req requestContent) {
        HttpMessage.Request newRequest = HttpClients$.MODULE$.prepareRequest(this.config(), req, requestSurface, requestContent);
        HttpMessage.Response resp = this.send(newRequest, HttpClientContext$.MODULE$.apply(this.config().name(), HttpClientContext$.MODULE$.$lessinit$greater$default$2(), HttpClientContext$.MODULE$.$lessinit$greater$default$3()));
        return HttpClients$.MODULE$.parseResponse(this.config(), responseSurface, resp);
    }

    public static Object rpc$(SyncClient $this, RPCMethod method, Object requestContent) {
        return $this.rpc(method, requestContent);
    }

    default public <Req, Resp> Resp rpc(RPCMethod method, Req requestContent) {
        HttpClientContext context;
        HttpMessage.Request request = HttpClients$.MODULE$.prepareRPCRequest(this.config(), method.path(), method.requestSurface(), requestContent);
        HttpMessage.Response response = this.sendSafe(request, context = HttpClientContext$.MODULE$.apply(this.config().name(), (Option<RPCMethod>)Some$.MODULE$.apply((Object)method), (Option<Object>)Some$.MODULE$.apply(requestContent)));
        if (response.status().isSuccessful()) {
            Object ret = HttpClients$.MODULE$.parseRPCResponse(this.config(), response, method.responseSurface());
            return (Resp)ret;
        }
        throw RPCException$.MODULE$.fromResponse(response);
    }

    private HttpMessage.Response send$$anonfun$1$$anonfun$1$$anonfun$1(HttpMessage.Request req$1) {
        return this.channel().send(req$1, this.config());
    }

    private HttpMessage.Response send$$anonfun$1(HttpClientContext context$1, HttpMessage.Request request$1, ObjectRef lastResponse$1) {
        this.wvlet$airframe$http$client$SyncClient$$loggingFilter().andThen(this.config().clientFilter()).apply(context$1).andThen(req -> Rx$.MODULE$.single(() -> this.send$$anonfun$1$$anonfun$1$$anonfun$1(req))).apply(request$1).run((Function1)(JProcedure1 & Serializable)resp -> {
            Some some = Some$.MODULE$.apply(resp);
            lastResponse$2.elem = some;
            some = null;
        });
        return (HttpMessage.Response)((Option)lastResponse$1.elem).get();
    }
}

