/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ReusableBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import wvlet.airframe.http.HttpContext;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.RPCContext;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCMethod;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.RPCStatus$;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.client.HttpClientContext;
import wvlet.airframe.http.internal.RPCCallContext;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.surface.MethodParameter;
import wvlet.airframe.surface.Parameter;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.ulid.ULID;
import wvlet.log.LogTimestampFormatter$;

public final class HttpLogs$
implements Serializable {
    private static final scala.collection.concurrent.Map<String, String> headerSanitizeCache;
    public static final HttpLogs$ MODULE$;

    private HttpLogs$() {
    }

    static {
        MODULE$ = new HttpLogs$();
        headerSanitizeCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpLogs$.class);
    }

    public Rx<HttpMessage.Response> reportLog(HttpLogger httpLogger, HttpMultiMap excludeHeaders, HttpMessage.Request request, RxHttpEndpoint next, Option<HttpClientContext> clientContext, Option<RPCContext> rpcContext) {
        long baseTime = System.currentTimeMillis();
        long start = System.nanoTime();
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$plus$eq(this.unixTimeLogs(baseTime));
        m.$plus$plus$eq(this.commonRequestLogs(request));
        m.$plus$plus$eq(this.requestHeaderLogs(request, excludeHeaders));
        clientContext.foreach((Function1 & Serializable)_$2 -> _$2.rpcMethod().map((Function1 & Serializable)rpc -> (ReusableBuilder)m.$plus$plus$eq(this.rpcMethodLogs((RPCMethod)rpc))));
        return next.apply(request).toRx().map((Function1 & Serializable)resp -> {
            m.$plus$plus$eq(this.durationLogs(baseTime, start));
            this.wvlet$airframe$http$internal$HttpLogs$$$_$rpcCallLogs$1(rpcContext, m);
            m.$plus$plus$eq(this.commonResponseLogs((HttpMessage.Response)resp));
            m.$plus$plus$eq(this.responseHeaderLogs((HttpMessage.Response)resp, excludeHeaders));
            this.wvlet$airframe$http$internal$HttpLogs$$$_$reportLogs$1(httpLogger, m);
            return resp;
        }).recoverWith((PartialFunction)new Serializable(httpLogger, rpcContext, baseTime, start, m){
            private final HttpLogger httpLogger$3;
            private final Option rpcContext$3;
            private final long baseTime$2;
            private final long start$2;
            private final ReusableBuilder m$7;
            {
                this.httpLogger$3 = httpLogger$4;
                this.rpcContext$3 = rpcContext$4;
                this.baseTime$2 = baseTime$3;
                this.start$2 = start$3;
                this.m$7 = m$13;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable e = throwable;
                    this.m$7.$plus$plus$eq(HttpLogs$.MODULE$.durationLogs(this.baseTime$2, this.start$2));
                    HttpLogs$.MODULE$.wvlet$airframe$http$internal$HttpLogs$$$_$rpcCallLogs$1(this.rpcContext$3, this.m$7);
                    this.m$7.$plus$plus$eq(HttpLogs$.MODULE$.errorLogs(e));
                    HttpLogs$.MODULE$.wvlet$airframe$http$internal$HttpLogs$$$_$reportLogs$1(this.httpLogger$3, this.m$7);
                    return Rx$.MODULE$.exception(e);
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Option<HttpClientContext> reportLog$default$5() {
        return None$.MODULE$;
    }

    public Option<RPCContext> reportLog$default$6() {
        return None$.MODULE$;
    }

    public ListMap<String, Object> durationLogs(long baseTime, long sinceNano) {
        long end = System.nanoTime();
        long durationMills = TimeUnit.NANOSECONDS.toMillis(end - sinceNano);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"end_time_ms");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)(baseTime + durationMills)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"duration_ms");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)durationMills));
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public ListMap<String, Object> unixTimeLogs(long currentTimeMillis) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"time");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)(currentTimeMillis / 1000L)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"start_time_ms");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)currentTimeMillis));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"event_timestamp");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)LogTimestampFormatter$.MODULE$.formatTimestampWithNoSpaace(currentTimeMillis));
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public long unixTimeLogs$default$1() {
        return System.currentTimeMillis();
    }

    public Map<String, Object> commonRequestLogs(HttpMessage.Request request) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"method");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)request.method().toString()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)request.path()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"uri");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.sanitize(request.uri())));
        String queryString = this.extractQueryString(request.uri());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(queryString))) {
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"query_string");
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)queryString));
        }
        request.remoteAddress().foreach((Function1 & Serializable)remoteAddr -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"remote_address");
            return (ReusableBuilder)m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)remoteAddr.hostAndPort()));
        });
        return (Map)m.result();
    }

    public Map<String, Object> commonResponseLogs(HttpMessage.Response response) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"status_code");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)response.statusCode())));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"status_code_name");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)response.status().reason()));
        response.contentLength().foreach((Function1 & Serializable)_$3 -> this.commonResponseLogs$$anonfun$1(m, BoxesRunTime.unboxToLong((Object)_$3)));
        response.getHeader("x-airframe-rpc-status").foreach((Function1)(JProcedure1 & Serializable)rpcStatus -> Try$.MODULE$.apply(() -> this.commonResponseLogs$$anonfun$2$$anonfun$1(rpcStatus)).foreach((Function1 & Serializable)status -> (ReusableBuilder)m.$plus$plus$eq(this.rpcStatusLogs((RPCStatus)status))));
        return (Map)m.result();
    }

    public Map<String, Object> rpcStatusLogs(RPCStatus status) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_status");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)status.code()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_status_name");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)status.name());
        return (Map)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Map<String, Object> requestHeaderLogs(HttpMessage.Request request, HttpMultiMap excludeHeaders) {
        Map<String, Object> m = this.headerLogs(request.header(), excludeHeaders);
        if (m.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"request_header");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, m);
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Map<String, Object> responseHeaderLogs(HttpMessage.Response response, HttpMultiMap excludeHeaders) {
        Map<String, Object> m = this.headerLogs(response.header(), excludeHeaders);
        if (m.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"response_header");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, m);
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Map<String, Object> headerLogs(HttpMultiMap headerMap, HttpMultiMap excludeHeaders) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        headerMap.entries().foreach((Function1)(JProcedure1 & Serializable)e -> {
            if (!excludeHeaders.contains(e.key().toLowerCase())) {
                String v = headerMap.getAll(e.key()).mkString(";");
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.sanitizeHeader(e.key()));
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v));
                return;
            }
        });
        return (Map)m.result();
    }

    public Map<String, Object> rpcMethodLogs(RPCMethod rpcMethod) {
        return rpcMethod.logData();
    }

    public ListMap<String, Object> rpcLogs(RPCCallContext rpcContext) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_interface");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)rpcContext.rpcInterfaceName()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_class");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)rpcContext.rpcClassName()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_method");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)rpcContext.rpcMethodName()));
        ListMap<String, Object> rpcArgs = this.extractRpcArgLog(rpcContext);
        if (rpcArgs.nonEmpty()) {
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_args");
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, rpcArgs));
        }
        return (ListMap)m.result();
    }

    public ListMap<String, Object> extractRpcArgLog(RPCCallContext rpcContext) {
        ReusableBuilder rpcArgsBuilder = ListMap$.MODULE$.newBuilder();
        ((IterableOps)rpcContext.rpcMethodSurface().args().zip(rpcContext.rpcArgs())).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MethodParameter p = (MethodParameter)tuple2._1();
                Object arg = tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MethodParameter p = (MethodParameter)tuple2._1();
                Object arg = tuple2._2();
                return (ReusableBuilder)rpcArgsBuilder.$plus$plus$eq((IterableOnce)this.traverseParam$1((Parameter)p, arg));
            }
            throw new MatchError((Object)tuple2);
        });
        return (ListMap)rpcArgsBuilder.result();
    }

    public ListMap<String, Object> errorLogs(Throwable e) {
        BoxedUnit boxedUnit;
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        Throwable throwable = this.findCause$1(e);
        if (throwable == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof HttpServerException) {
            HttpServerException se = (HttpServerException)throwable;
            if (se.getCause() != null) {
                Throwable rootCause = this.findCause$1(se.getCause());
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception_message");
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)rootCause.getMessage()));
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception");
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)rootCause));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (throwable instanceof RPCException) {
            RPCException re = (RPCException)throwable;
            m.$plus$plus$eq(this.rpcStatusLogs(re.status()));
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception_message");
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)re.getMessage()));
            if (re.shouldReportStackTrace()) {
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception");
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)re));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Throwable other = throwable;
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception_message");
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)other.getMessage()));
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception");
            boxedUnit = m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)other));
        }
        return (ListMap)m.result();
    }

    private String sanitize(String s) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$1 -> this.sanitize$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$1))).mkString();
    }

    private String sanitizeHeader(String h) {
        return (String)headerSanitizeCache.getOrElseUpdate((Object)h, () -> this.sanitizeHeader$$anonfun$1(h));
    }

    public String extractQueryString(String uri) {
        int qPos = uri.indexOf(63);
        if (qPos < 0 || qPos == uri.length() - 1) {
            return "";
        }
        return uri.substring(qPos + 1, uri.length());
    }

    public final void wvlet$airframe$http$internal$HttpLogs$$$_$reportLogs$1(HttpLogger httpLogger$1, ReusableBuilder m$1) {
        httpLogger$1.write((Map<String, Object>)((Map)httpLogger$1.config().logFilter().apply(m$1.result())));
    }

    public final void wvlet$airframe$http$internal$HttpLogs$$$_$rpcCallLogs$1(Option rpcContext$1, ReusableBuilder m$2) {
        rpcContext$1.flatMap((Function1 & Serializable)_$1 -> _$1.rpcCallContext()).foreach((Function1 & Serializable)rcc -> (ReusableBuilder)m$2.$plus$plus$eq(this.rpcLogs((RPCCallContext)rcc)));
    }

    private final /* synthetic */ ReusableBuilder commonResponseLogs$$anonfun$1(ReusableBuilder m$9, long _$3) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"response_content_length");
        return (ReusableBuilder)m$9.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)_$3)));
    }

    private final RPCStatus commonResponseLogs$$anonfun$2$$anonfun$1(String rpcStatus$1) {
        return RPCStatus$.MODULE$.ofCode(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(rpcStatus$1)));
    }

    private final ReusableBuilder traverseObject$1$$anonfun$1$$anonfun$1(Object arg$2, ReusableBuilder builder$2, Parameter p$1) {
        return (ReusableBuilder)builder$2.$plus$plus$eq((IterableOnce)this.traverseParam$1(p$1, p$1.get(arg$2)));
    }

    private final ListMap traverseObject$1(Surface s, Object arg) {
        ReusableBuilder builder = ListMap$.MODULE$.newBuilder();
        s.params().foreach((Function1 & Serializable)p -> Try$.MODULE$.apply(() -> this.traverseObject$1$$anonfun$1$$anonfun$1(arg, builder, p)));
        return (ListMap)builder.result();
    }

    private final ListMap traverseParam$1(Parameter p, Object arg) {
        Object object = arg;
        if (object instanceof HttpMessage.Request) {
            HttpMessage.Request r = (HttpMessage.Request)object;
            return ListMap$.MODULE$.empty();
        }
        Object r = object;
        String string = p.surface().fullName();
        String string2 = "com.twitter.finagle.http.Request";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof HttpContext) {
            HttpContext c = (HttpContext)object;
            return ListMap$.MODULE$.empty();
        }
        if (p.isSecret()) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof ULID) {
            ULID u = (ULID)object;
            Object[] objectArray = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)p.name());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)u);
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (p.surface().params().length() > 0) {
            Object[] objectArray = new Tuple2[1];
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)p.name());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)this.traverseObject$1(p.surface(), arg));
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        Object[] objectArray = new Tuple2[1];
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)p.name());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, arg);
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final Throwable findCause$1(Throwable e) {
        while (true) {
            ExecutionException ee;
            Throwable throwable;
            if ((throwable = e) instanceof Exception) {
                Exception i = (Exception)throwable;
                String string = i.getClass().getName();
                String string2 = "java.lang.reflect.InvocationTargetException";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    e = i.getCause();
                    continue;
                }
            }
            if (!(throwable instanceof ExecutionException) || (ee = (ExecutionException)throwable).getCause() == null) break;
            e = ee.getCause();
        }
        return e;
    }

    private final /* synthetic */ Object sanitize$$anonfun$1(char x$1) {
        char c = x$1;
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        char c2 = c;
        return BoxesRunTime.boxToCharacter((char)c2);
    }

    private final String sanitizeHeader$$anonfun$1(String h$1) {
        return h$1.replaceAll("-", "_").toLowerCase();
    }
}

