/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.internal;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.RPCStatus$;
import wvlet.airframe.http.RPCStatus$INTERNAL_ERROR_I0$;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.RxHttpFilter;
import wvlet.airframe.rx.Rx;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class RPCResponseFilter$
implements RxHttpFilter,
LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RPCResponseFilter$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    public static final RPCResponseFilter$ MODULE$ = new RPCResponseFilter$();

    private RPCResponseFilter$() {
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RPCResponseFilter$.class);
    }

    @Override
    public Rx<HttpMessage.Response> apply(HttpMessage.Request request, RxHttpEndpoint next) {
        return next.apply(request).transform((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                HttpMessage.Response resp = (HttpMessage.Response)((Success)try_).value();
                return this.setRPCStatus(resp);
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                Throwable throwable = e;
                if (throwable instanceof HttpServerException) {
                    HttpServerException ex = (HttpServerException)throwable;
                    RPCStatus rPCStatus = RPCStatus$.MODULE$.fromHttpStatus(ex.status());
                    RPCException re = rPCStatus.newException(ex.getMessage(), ex.getCause(), rPCStatus.newException$default$3(), rPCStatus.newException$default$4());
                    return re.toResponse();
                }
                if (throwable instanceof RPCException) {
                    RPCException ex = (RPCException)throwable;
                    return ex.toResponse();
                }
                Throwable other = throwable;
                return RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException(other.getMessage(), other, RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException$default$3(), RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException$default$4()).toResponse();
            }
            throw new MatchError((Object)try_);
        });
    }

    private HttpMessage.Response setRPCStatus(HttpMessage.Response resp) {
        Option option = resp.getHeader("x-airframe-rpc-status");
        if (option instanceof Some) {
            String status = (String)((Some)option).value();
            return resp;
        }
        if (None$.MODULE$.equals(option)) {
            RPCStatus status = RPCStatus$.MODULE$.fromHttpStatus(resp.status());
            return (HttpMessage.Response)resp.addHeader("x-airframe-rpc-status", BoxesRunTime.boxToInteger((int)status.code()).toString());
        }
        throw new MatchError((Object)option);
    }
}

