/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.router;

import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import wvlet.airframe.Session;
import wvlet.airframe.codec.CodecErrorCode;
import wvlet.airframe.codec.MISSING_PARAMETER$;
import wvlet.airframe.codec.MessageCodecException;
import wvlet.airframe.codec.MessageCodecFactory;
import wvlet.airframe.http.HttpBackend$;
import wvlet.airframe.http.HttpContext;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.RPCMethod;
import wvlet.airframe.http.RPCStatus$INVALID_REQUEST_U1$;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.internal.RPCCallContext$;
import wvlet.airframe.http.router.ControllerProvider;
import wvlet.airframe.http.router.ControllerRoute$;
import wvlet.airframe.http.router.HttpRequestMapper$;
import wvlet.airframe.http.router.Route;
import wvlet.airframe.surface.MethodSurface;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class ControllerRoute
implements Route,
LoggingMethods,
LazyLogger,
LogSupport,
Product {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ControllerRoute.class.getDeclaredField("logger$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ControllerRoute.class.getDeclaredField("serviceName$lzy1"));
    private IndexedSeq pathComponents;
    private volatile Object logger$lzy1;
    private final RPCMethod rpcMethod;
    private final Surface controllerSurface;
    private final String httpMethod;
    private final MethodSurface methodSurface;
    private final boolean isRPC;
    private volatile Object serviceName$lzy1;

    public static ControllerRoute apply(RPCMethod rPCMethod, Surface surface, String string, MethodSurface methodSurface, boolean bl) {
        return ControllerRoute$.MODULE$.apply(rPCMethod, surface, string, methodSurface, bl);
    }

    public static ControllerRoute fromProduct(Product product) {
        return ControllerRoute$.MODULE$.fromProduct(product);
    }

    public static ControllerRoute unapply(ControllerRoute controllerRoute) {
        return ControllerRoute$.MODULE$.unapply(controllerRoute);
    }

    public ControllerRoute(RPCMethod rpcMethod, Surface controllerSurface, String httpMethod, MethodSurface methodSurface, boolean isRPC) {
        this.rpcMethod = rpcMethod;
        this.controllerSurface = controllerSurface;
        this.httpMethod = httpMethod;
        this.methodSurface = methodSurface;
        this.isRPC = isRPC;
        Route.$init$(this);
        Predef$.MODULE$.require(this.path().startsWith("/"), () -> this.$init$$$anonfun$1(methodSurface));
        Statics.releaseFence();
    }

    public IndexedSeq pathComponents() {
        return this.pathComponents;
    }

    @Override
    public void wvlet$airframe$http$router$Route$_setter_$pathComponents_$eq(IndexedSeq x$0) {
        this.pathComponents = x$0;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rpcMethod()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.controllerSurface()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.httpMethod()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.methodSurface()));
        n = Statics.mix((int)n, (int)(this.isRPC() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ControllerRoute)) return false;
        ControllerRoute controllerRoute = (ControllerRoute)object;
        if (this.isRPC() != controllerRoute.isRPC()) return false;
        RPCMethod rPCMethod = this.rpcMethod();
        RPCMethod rPCMethod2 = controllerRoute.rpcMethod();
        if (rPCMethod == null) {
            if (rPCMethod2 != null) {
                return false;
            }
        } else if (!((Object)rPCMethod).equals(rPCMethod2)) return false;
        Surface surface = this.controllerSurface();
        Surface surface2 = controllerRoute.controllerSurface();
        if (surface == null) {
            if (surface2 != null) {
                return false;
            }
        } else if (!surface.equals(surface2)) return false;
        String string = this.httpMethod();
        String string2 = controllerRoute.httpMethod();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        MethodSurface methodSurface = this.methodSurface();
        MethodSurface methodSurface2 = controllerRoute.methodSurface();
        if (methodSurface == null) {
            if (methodSurface2 != null) {
                return false;
            }
        } else if (!methodSurface.equals(methodSurface2)) return false;
        if (!controllerRoute.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof ControllerRoute;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "ControllerRoute";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "rpcMethod";
            }
            case 1: {
                return "controllerSurface";
            }
            case 2: {
                return "httpMethod";
            }
            case 3: {
                return "methodSurface";
            }
            case 4: {
                return "isRPC";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public RPCMethod rpcMethod() {
        return this.rpcMethod;
    }

    @Override
    public Surface controllerSurface() {
        return this.controllerSurface;
    }

    @Override
    public String httpMethod() {
        return this.httpMethod;
    }

    @Override
    public MethodSurface methodSurface() {
        return this.methodSurface;
    }

    @Override
    public boolean isRPC() {
        return this.isRPC;
    }

    @Override
    public String path() {
        return this.rpcMethod().path();
    }

    public String toString() {
        return new StringBuilder(9).append(this.httpMethod()).append(" ").append(this.path()).append(" -> ").append(this.methodSurface().name()).append("(").append(((IterableOnceOps)this.methodSurface().args().map((Function1 & Serializable)x -> new StringBuilder(1).append(x.name()).append(":").append(x.surface()).toString())).mkString(", ")).append("): ").append(this.methodSurface().returnType()).toString();
    }

    @Override
    public String serviceName() {
        Object object = this.serviceName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.serviceName$lzyINIT1();
    }

    private Object serviceName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serviceName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.rpcMethod().rpcInterfaceName().replaceAll("\\$anon\\$", "").replaceAll("\\$", ".");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serviceName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Surface returnTypeSurface() {
        return this.methodSurface().returnType();
    }

    @Override
    public <Req, Resp, F> Object call(Object controller, Req request, Map<String, String> params, HttpContext<Req, Resp, F> context, MessageCodecFactory codecFactory, HttpRequestAdapter<Req> evidence$3) {
        Object object;
        Object object2 = controller;
        if (object2 instanceof RxHttpEndpoint) {
            RxHttpEndpoint endpoint = (RxHttpEndpoint)object2;
            HttpRequestAdapter adapter = (HttpRequestAdapter)Predef$.MODULE$.implicitly(evidence$3);
            return endpoint.apply(adapter.httpRequestOf(request));
        }
        Seq<Object> methodArgs = (Seq<Object>)package$.MODULE$.Seq().empty();
        try {
            try {
                methodArgs = HttpRequestMapper$.MODULE$.buildControllerMethodArgs(controller, this.methodSurface(), request, context, params, codecFactory, this.isRPC(), evidence$3);
            }
            catch (Throwable throwable) {
                context.setThreadLocal(HttpBackend$.MODULE$.TLS_KEY_RPC(), RPCCallContext$.MODULE$.apply(this.rpcMethod(), this.methodSurface(), methodArgs));
                throw throwable;
            }
            context.setThreadLocal(HttpBackend$.MODULE$.TLS_KEY_RPC(), RPCCallContext$.MODULE$.apply(this.rpcMethod(), this.methodSurface(), methodArgs));
            object = this.methodSurface().call(controller, methodArgs);
        }
        catch (IllegalArgumentException e) {
            throw RPCStatus$INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(9).append(request).append(" failed: ").append(e.getMessage()).toString(), e, RPCStatus$INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus$INVALID_REQUEST_U1$.MODULE$.newException$default$4());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof MessageCodecException) {
                MessageCodecException e = (MessageCodecException)throwable2;
                CodecErrorCode codecErrorCode = e.errorCode();
                MISSING_PARAMETER$ mISSING_PARAMETER$ = MISSING_PARAMETER$.MODULE$;
                if (!(codecErrorCode != null ? !codecErrorCode.equals(mISSING_PARAMETER$) : mISSING_PARAMETER$ != null)) {
                    throw RPCStatus$INVALID_REQUEST_U1$.MODULE$.newException(e.message(), (Throwable)e, RPCStatus$INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus$INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                }
            }
            throw throwable;
        }
        return object;
    }

    @Override
    public <Req, Resp, F> Option<Object> callWithProvider(Session session, ControllerProvider controllerProvider, Req request, Map<String, String> params, HttpContext<Req, Resp, F> context, MessageCodecFactory codecFactory, HttpRequestAdapter<Req> evidence$4) {
        return controllerProvider.findController(session, this.controllerSurface()).map((Function1 & Serializable)controller -> this.call(controller, request, params, context, codecFactory, evidence$4));
    }

    public ControllerRoute copy(RPCMethod rpcMethod, Surface controllerSurface, String httpMethod, MethodSurface methodSurface, boolean isRPC) {
        return new ControllerRoute(rpcMethod, controllerSurface, httpMethod, methodSurface, isRPC);
    }

    public RPCMethod copy$default$1() {
        return this.rpcMethod();
    }

    public Surface copy$default$2() {
        return this.controllerSurface();
    }

    public String copy$default$3() {
        return this.httpMethod();
    }

    public MethodSurface copy$default$4() {
        return this.methodSurface();
    }

    public boolean copy$default$5() {
        return this.isRPC();
    }

    public RPCMethod _1() {
        return this.rpcMethod();
    }

    public Surface _2() {
        return this.controllerSurface();
    }

    public String _3() {
        return this.httpMethod();
    }

    public MethodSurface _4() {
        return this.methodSurface();
    }

    public boolean _5() {
        return this.isRPC();
    }

    private final Object $init$$$anonfun$1(MethodSurface methodSurface$1) {
        return new StringBuilder(68).append("Invalid route path: ").append(this.path()).append(". EndPoint path must start with a slash (/) in ").append(methodSurface$1.owner().name()).append(":").append(methodSurface$1.name()).toString();
    }
}

