/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.router;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.router.Automaton;
import wvlet.airframe.http.router.Automaton$NextNode$;
import wvlet.airframe.http.router.Route;
import wvlet.airframe.http.router.RouteMatch;
import wvlet.airframe.http.router.RouteMatch$;
import wvlet.airframe.http.router.RouteMatcher$;
import wvlet.airframe.http.router.RouteMatcher$ConstantPathMapping$;
import wvlet.airframe.http.router.RouteMatcher$PathSequenceMapping$;
import wvlet.airframe.http.router.RouteMatcher$VariableMapping$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public interface RouteMatcher {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RouteMatcher$.class.getDeclaredField("logger$lzy2"));

    public static RouteMatcher build(Seq<Route> seq) {
        return RouteMatcher$.MODULE$.build(seq);
    }

    public static Automaton.DFA<Set<PathMapping>, String> buildPathDFA(Seq<Route> seq) {
        return RouteMatcher$.MODULE$.buildPathDFA(seq);
    }

    public <Req> Option<RouteMatch> findRoute(Req var1, HttpRequestAdapter<Req> var2);

    public static class ConstantPathMapping
    implements PathMapping,
    Product,
    Serializable {
        private final String pathPrefix;
        private final int index;
        private final String name;
        private final Option matchedRoute;

        public static ConstantPathMapping apply(String string, int n, String string2, Option<Route> option) {
            return RouteMatcher$ConstantPathMapping$.MODULE$.apply(string, n, string2, option);
        }

        public static ConstantPathMapping fromProduct(Product product) {
            return RouteMatcher$ConstantPathMapping$.MODULE$.fromProduct(product);
        }

        public static ConstantPathMapping unapply(ConstantPathMapping constantPathMapping) {
            return RouteMatcher$ConstantPathMapping$.MODULE$.unapply(constantPathMapping);
        }

        public ConstantPathMapping(String pathPrefix, int index, String name, Option<Route> matchedRoute) {
            this.pathPrefix = pathPrefix;
            this.index = index;
            this.name = name;
            this.matchedRoute = matchedRoute;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathPrefix()));
            n = Statics.mix((int)n, (int)this.index());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.matchedRoute()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConstantPathMapping)) return false;
            ConstantPathMapping constantPathMapping = (ConstantPathMapping)object;
            if (this.index() != constantPathMapping.index()) return false;
            String string = this.pathPrefix();
            String string2 = constantPathMapping.pathPrefix();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = constantPathMapping.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<Route> option = this.matchedRoute();
            Option<Route> option2 = constantPathMapping.matchedRoute();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!constantPathMapping.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ConstantPathMapping;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ConstantPathMapping";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pathPrefix";
                }
                case 1: {
                    return "index";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "matchedRoute";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String pathPrefix() {
            return this.pathPrefix;
        }

        public int index() {
            return this.index;
        }

        public String name() {
            return this.name;
        }

        @Override
        public Option<Route> matchedRoute() {
            return this.matchedRoute;
        }

        public String toString() {
            String t = new StringBuilder(1).append(this.pathPrefix()).append("/").append(this.name()).toString();
            if (this.isTerminal()) {
                return new StringBuilder(1).append("!").append(t).toString();
            }
            return t;
        }

        public ConstantPathMapping copy(String pathPrefix, int index, String name, Option<Route> matchedRoute) {
            return new ConstantPathMapping(pathPrefix, index, name, matchedRoute);
        }

        public String copy$default$1() {
            return this.pathPrefix();
        }

        public int copy$default$2() {
            return this.index();
        }

        public String copy$default$3() {
            return this.name();
        }

        public Option<Route> copy$default$4() {
            return this.matchedRoute();
        }

        public String _1() {
            return this.pathPrefix();
        }

        public int _2() {
            return this.index();
        }

        public String _3() {
            return this.name();
        }

        public Option<Route> _4() {
            return this.matchedRoute();
        }
    }

    public static class FastRouteMatcher
    implements RouteMatcher,
    LoggingMethods,
    LazyLogger,
    LogSupport {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FastRouteMatcher.class.getDeclaredField("logger$lzy1"));
        private volatile Object logger$lzy1;
        private final Automaton.DFA<Set<PathMapping>, String> dfa;

        public FastRouteMatcher(String targetMethod, Seq<Route> routes) {
            this.dfa = RouteMatcher$.MODULE$.buildPathDFA(routes);
            FastRouteMatcher LoggingMethods_this = this;
            if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "RouteMatcher.scala", 68, 70), (Object)new StringBuilder(20).append("DFA for ").append(routes.size()).append(" ").append(targetMethod).append(" requests:\n").append(this.dfa).toString());
            }
            ((IterableOnceOps)this.dfa.nodeTable().map((Function1 & Serializable)_$3 -> (Set)_$3._1())).foreach((Function1)(JProcedure1 & Serializable)state -> {
                if (state.size() > 1 && state.forall((Function1 & Serializable)_$4 -> _$4.isTerminal())) {
                    throw new IllegalArgumentException(new StringBuilder(33).append("Found multiple matching routes: ").append(((IterableOnceOps)((IterableOps)((IterableOps)state.map((Function1 & Serializable)_$5 -> _$5.matchedRoute())).flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)p -> String.valueOf(p.path()))).mkString(", ")).append(" ").toString());
                }
            });
        }

        public Logger logger() {
            Object object = this.logger$lzy1;
            if (object instanceof Logger) {
                return (Logger)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Logger)this.logger$lzyINIT1();
        }

        private Object logger$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.logger$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Logger logger = null;
                        try {
                            logger = LazyLogger.logger$((LazyLogger)this);
                            object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return logger;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public <Req> Option<RouteMatch> findRoute(Req request, HttpRequestAdapter<Req> tp) {
            IntRef currentState = IntRef.create((int)this.dfa.initStateId());
            IntRef pathIndex = IntRef.create((int)0);
            IndexedSeq<String> pc = tp.pathComponentsOf(request);
            ObjectRef foundRoute = ObjectRef.create((Object)None$.MODULE$);
            BooleanRef toContinue = BooleanRef.create((boolean)true);
            ObjectRef params = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
            while (toContinue.elem && pathIndex.elem < pc.length()) {
                String token = (String)pc.apply(pathIndex.elem);
                this.loop$1(currentState, pathIndex, pc, foundRoute, toContinue, params, token);
            }
            return ((Option)foundRoute.elem).map((Function1 & Serializable)r -> {
                FastRouteMatcher LoggingMethods_this = this;
                if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                    LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "RouteMatcher.scala", 123, 81), (Object)new StringBuilder(30).append("Found a matching route: ").append(r.path()).append(" <= {").append(((Map)params$3.elem).mkString(", ")).append("}").toString());
                }
                return RouteMatch$.MODULE$.apply((Route)r, (Map<String, String>)((Map)params$3.elem).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            });
        }

        private final void loop$1$$anonfun$4(IntRef currentState$2, IntRef pathIndex$2, IndexedSeq pc$2, ObjectRef foundRoute$3, BooleanRef toContinue$2, ObjectRef params$4) {
            this.loop$1(currentState$2, pathIndex$2, pc$2, foundRoute$3, toContinue$2, params$4, "");
        }

        private final void loop$1(IntRef currentState$1, IntRef pathIndex$1, IndexedSeq pc$1, ObjectRef foundRoute$1, BooleanRef toContinue$1, ObjectRef params$1, String token) {
            Automaton.NextNode nextNode;
            int n;
            pathIndex$1.elem = n = pathIndex$1.elem + 1;
            Option<Automaton.NextNode<Set<PathMapping>>> option = this.dfa.nextNode(currentState$1.elem, token);
            if (option instanceof Some && (nextNode = (Automaton.NextNode)((Some)option).value()) != null) {
                int n2;
                Automaton.NextNode nextNode2 = Automaton$NextNode$.MODULE$.unapply(nextNode);
                Set set = (Set)nextNode2._1();
                int n3 = nextNode2._2();
                Set actions = set;
                int nextStateId = n3;
                FastRouteMatcher LoggingMethods_this = this;
                if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                    LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "RouteMatcher.scala", 96, 119), (Object)new StringBuilder(34).append("path index:").append(pathIndex$1.elem).append("/").append(pc$1.length()).append(", transition: ").append(currentState$1.elem).append(" -> ").append(token).append(" -> ").append(nextStateId).toString());
                }
                currentState$1.elem = n2 = nextStateId;
                actions.foreach((Function1)(JProcedure1 & Serializable)action -> {
                    Map map;
                    params$2.elem = map = action.updateMatch((Map<String, String>)((Map)params$2.elem), token);
                    map = null;
                });
                if (pathIndex$1.elem >= pc$1.length()) {
                    boolean bl;
                    toContinue$1.elem = bl = false;
                    actions.find((Function1 & Serializable)_$6 -> _$6.isTerminal()).map((Function1)(JProcedure1 & Serializable)matchedAction -> {
                        Option option;
                        foundRoute$2.elem = option = matchedAction.matchedRoute();
                        option = null;
                    }).getOrElse((Function0 & Serializable)() -> {
                        this.loop$1$$anonfun$4(currentState$1, pathIndex$1, pc$1, foundRoute$1, toContinue$1, params$1);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                boolean bl;
                toContinue$1.elem = bl = false;
                return;
            }
            throw new MatchError(option);
        }
    }

    public static interface PathMapping {
        public Option<Route> matchedRoute();

        public String pathPrefix();

        public static boolean isTerminal$(PathMapping $this) {
            return $this.isTerminal();
        }

        default public boolean isTerminal() {
            return this.matchedRoute().isDefined();
        }

        public static boolean isRepeat$(PathMapping $this) {
            return $this.isRepeat();
        }

        default public boolean isRepeat() {
            return false;
        }

        public static Map updateMatch$(PathMapping $this, Map m, String pathComponent) {
            return $this.updateMatch((Map<String, String>)m, pathComponent);
        }

        default public Map<String, String> updateMatch(Map<String, String> m, String pathComponent) {
            return m;
        }
    }

    public static class PathSequenceMapping
    implements PathMapping,
    Product,
    Serializable {
        private final String pathPrefix;
        private final int index;
        private final String varName;
        private final Option matchedRoute;

        public static PathSequenceMapping apply(String string, int n, String string2, Option<Route> option) {
            return RouteMatcher$PathSequenceMapping$.MODULE$.apply(string, n, string2, option);
        }

        public static PathSequenceMapping fromProduct(Product product) {
            return RouteMatcher$PathSequenceMapping$.MODULE$.fromProduct(product);
        }

        public static PathSequenceMapping unapply(PathSequenceMapping pathSequenceMapping) {
            return RouteMatcher$PathSequenceMapping$.MODULE$.unapply(pathSequenceMapping);
        }

        public PathSequenceMapping(String pathPrefix, int index, String varName, Option<Route> matchedRoute) {
            this.pathPrefix = pathPrefix;
            this.index = index;
            this.varName = varName;
            this.matchedRoute = matchedRoute;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathPrefix()));
            n = Statics.mix((int)n, (int)this.index());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.varName()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.matchedRoute()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PathSequenceMapping)) return false;
            PathSequenceMapping pathSequenceMapping = (PathSequenceMapping)object;
            if (this.index() != pathSequenceMapping.index()) return false;
            String string = this.pathPrefix();
            String string2 = pathSequenceMapping.pathPrefix();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.varName();
            String string4 = pathSequenceMapping.varName();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<Route> option = this.matchedRoute();
            Option<Route> option2 = pathSequenceMapping.matchedRoute();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!pathSequenceMapping.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof PathSequenceMapping;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PathSequenceMapping";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pathPrefix";
                }
                case 1: {
                    return "index";
                }
                case 2: {
                    return "varName";
                }
                case 3: {
                    return "matchedRoute";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String pathPrefix() {
            return this.pathPrefix;
        }

        public int index() {
            return this.index;
        }

        public String varName() {
            return this.varName;
        }

        @Override
        public Option<Route> matchedRoute() {
            return this.matchedRoute;
        }

        public String toString() {
            return new StringBuilder(3).append("!").append(this.pathPrefix()).append("/*").append(this.varName()).toString();
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        @Override
        public boolean isRepeat() {
            return true;
        }

        @Override
        public Map<String, String> updateMatch(Map<String, String> m, String pathComponent) {
            String string;
            Option option = m.get((Object)this.varName());
            if (option instanceof Some) {
                String x = (String)((Some)option).value();
                string = new StringBuilder(1).append(x).append("/").append(pathComponent).toString();
            } else if (None$.MODULE$.equals(option)) {
                string = pathComponent;
            } else {
                throw new MatchError((Object)option);
            }
            String paramValue = string;
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.varName());
            return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)paramValue));
        }

        public PathSequenceMapping copy(String pathPrefix, int index, String varName, Option<Route> matchedRoute) {
            return new PathSequenceMapping(pathPrefix, index, varName, matchedRoute);
        }

        public String copy$default$1() {
            return this.pathPrefix();
        }

        public int copy$default$2() {
            return this.index();
        }

        public String copy$default$3() {
            return this.varName();
        }

        public Option<Route> copy$default$4() {
            return this.matchedRoute();
        }

        public String _1() {
            return this.pathPrefix();
        }

        public int _2() {
            return this.index();
        }

        public String _3() {
            return this.varName();
        }

        public Option<Route> _4() {
            return this.matchedRoute();
        }
    }

    public static class RouteMatcherByHttpMethodTypes
    implements RouteMatcher {
        private final Map<String, RouteMatcher> routesByMethod;

        public RouteMatcherByHttpMethodTypes(Seq<Route> routes) {
            this.routesByMethod = (Map)routes.groupBy((Function1 & Serializable)_$2 -> _$2.httpMethod()).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String method = (String)tuple2._1();
                    Seq lst = (Seq)tuple2._2();
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String method = (String)tuple2._1();
                    Seq lst = (Seq)tuple2._2();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)method);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new FastRouteMatcher(method, (Seq<Route>)lst));
                }
                throw new MatchError((Object)tuple2);
            });
        }

        @Override
        public <Req> Option<RouteMatch> findRoute(Req request, HttpRequestAdapter<Req> tp) {
            return this.routesByMethod.get((Object)tp.methodOf(request)).flatMap((Function1 & Serializable)nextRouter -> nextRouter.findRoute(request, tp));
        }
    }

    public static class VariableMapping
    implements PathMapping,
    Product,
    Serializable {
        private final String pathPrefix;
        private final int index;
        private final String varName;
        private final Option matchedRoute;

        public static VariableMapping apply(String string, int n, String string2, Option<Route> option) {
            return RouteMatcher$VariableMapping$.MODULE$.apply(string, n, string2, option);
        }

        public static VariableMapping fromProduct(Product product) {
            return RouteMatcher$VariableMapping$.MODULE$.fromProduct(product);
        }

        public static VariableMapping unapply(VariableMapping variableMapping) {
            return RouteMatcher$VariableMapping$.MODULE$.unapply(variableMapping);
        }

        public VariableMapping(String pathPrefix, int index, String varName, Option<Route> matchedRoute) {
            this.pathPrefix = pathPrefix;
            this.index = index;
            this.varName = varName;
            this.matchedRoute = matchedRoute;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pathPrefix()));
            n = Statics.mix((int)n, (int)this.index());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.varName()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.matchedRoute()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VariableMapping)) return false;
            VariableMapping variableMapping = (VariableMapping)object;
            if (this.index() != variableMapping.index()) return false;
            String string = this.pathPrefix();
            String string2 = variableMapping.pathPrefix();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.varName();
            String string4 = variableMapping.varName();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<Route> option = this.matchedRoute();
            Option<Route> option2 = variableMapping.matchedRoute();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!variableMapping.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof VariableMapping;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "VariableMapping";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pathPrefix";
                }
                case 1: {
                    return "index";
                }
                case 2: {
                    return "varName";
                }
                case 3: {
                    return "matchedRoute";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String pathPrefix() {
            return this.pathPrefix;
        }

        public int index() {
            return this.index;
        }

        public String varName() {
            return this.varName;
        }

        @Override
        public Option<Route> matchedRoute() {
            return this.matchedRoute;
        }

        public String toString() {
            String t = new StringBuilder(2).append(this.pathPrefix()).append("/$").append(this.varName()).toString();
            if (this.isTerminal()) {
                return new StringBuilder(1).append("!").append(t).toString();
            }
            return t;
        }

        @Override
        public Map<String, String> updateMatch(Map<String, String> m, String pathComponent) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.varName());
            return (Map)m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)pathComponent));
        }

        public VariableMapping copy(String pathPrefix, int index, String varName, Option<Route> matchedRoute) {
            return new VariableMapping(pathPrefix, index, varName, matchedRoute);
        }

        public String copy$default$1() {
            return this.pathPrefix();
        }

        public int copy$default$2() {
            return this.index();
        }

        public String copy$default$3() {
            return this.varName();
        }

        public Option<Route> copy$default$4() {
            return this.matchedRoute();
        }

        public String _1() {
            return this.pathPrefix();
        }

        public int _2() {
            return this.index();
        }

        public String _3() {
            return this.varName();
        }

        public Option<Route> _4() {
            return this.matchedRoute();
        }
    }
}

