/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.SetLike;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.HttpStatus$;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.ServerAddress$;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyRequestHandler$;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.rx.OnCompletion$;
import wvlet.airframe.rx.OnError;
import wvlet.airframe.rx.OnNext;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.rx.RxEvent;
import wvlet.airframe.rx.RxOps;
import wvlet.airframe.rx.RxRunner$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0007\u000f\u0001]A\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)a\b\u0001C\u0001\u007f!)1\t\u0001C!\t\")a\f\u0001C!?\")\u0011\r\u0001C!E\")a\r\u0001C\u0005O\u001e)1O\u0004E\u0001i\u001a)QB\u0004E\u0001k\")a(\u0003C\u0001y\")Q0\u0003C\u0001}\"I\u00111E\u0005\u0002\u0002\u0013%\u0011Q\u0005\u0002\u0014\u001d\u0016$H/\u001f*fcV,7\u000f\u001e%b]\u0012dWM\u001d\u0006\u0003\u001fA\tQA\\3uifT!!\u0005\n\u0002\t!$H\u000f\u001d\u0006\u0003'Q\t\u0001\"Y5sMJ\fW.\u001a\u0006\u0002+\u0005)qO\u001e7fi\u000e\u00011c\u0001\u0001\u0019UA\u0019\u0011dH\u0011\u000e\u0003iQ!a\u0007\u000f\u0002\u000f\rD\u0017M\u001c8fY*\u0011q\"\b\u0006\u0002=\u0005\u0011\u0011n\\\u0005\u0003Ai\u00111dU5na2,7\t[1o]\u0016d\u0017J\u001c2pk:$\u0007*\u00198eY\u0016\u0014\bC\u0001\u0012)\u001b\u0005\u0019#BA\t%\u0015\t)c%A\u0003d_\u0012,7M\u0003\u0002(9\u00059\u0001.\u00198eY\u0016\u0014\u0018BA\u0015$\u0005=1U\u000f\u001c7IiR\u0004(+Z9vKN$\bCA\u0016/\u001b\u0005a#BA\u0017\u0015\u0003\rawnZ\u0005\u0003_1\u0012!\u0002T8h'V\u0004\bo\u001c:u\u0003\u0019\u0019wN\u001c4jOB\u0011!gM\u0007\u0002\u001d%\u0011AG\u0004\u0002\u0012\u001d\u0016$H/_*feZ,'oQ8oM&<\u0017A\u00033jgB\fGo\u00195feB\u0011qG\u000f\b\u0003eaJ!!\u000f\b\u0002\u00199+G\u000f^=CC\u000e\\WM\u001c3\n\u0005mb$A\u0002$jYR,'/\u0003\u0002>!\tY\u0001\n\u001e;q\u0005\u0006\u001c7.\u001a8e\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005I\u0002\u0001\"\u0002\u0019\u0004\u0001\u0004\t\u0004\"B\u001b\u0004\u0001\u00041\u0014aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\u0007\u0015[\u0005\u000b\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0003V]&$\b\"\u0002'\u0005\u0001\u0004i\u0015aA2uqB\u0011\u0011DT\u0005\u0003\u001fj\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003R\t\u0001\u0007!+A\u0003dCV\u001cX\r\u0005\u0002T7:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/Z\ta\u0001\u0010:p_Rt\u0014\"\u0001%\n\u0005i;\u0015a\u00029bG.\fw-Z\u0005\u00039v\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005i;\u0015aE2iC:tW\r\u001c*fC\u0012\u001cu.\u001c9mKR,GCA#a\u0011\u0015aU\u00011\u0001N\u00031\u0019\u0007.\u00198oK2\u0014V-\u001931)\r)5\r\u001a\u0005\u0006\u0019\u001a\u0001\r!\u0014\u0005\u0006K\u001a\u0001\r!I\u0001\u0004[N<\u0017!D<sSR,'+Z:q_:\u001cX\r\u0006\u0003FQ6t\u0007\"B5\b\u0001\u0004Q\u0017a\u0001:fcB\u0011!e[\u0005\u0003Y\u000e\u00121\u0002\u0013;uaJ+\u0017/^3ti\")Aj\u0002a\u0001\u001b\")qn\u0002a\u0001a\u0006!!/Z:q!\t\u0011\u0013/\u0003\u0002sG\t\u0019B)\u001a4bk2$\b\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006\u0019b*\u001a;usJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB\u0011!'C\n\u0004\u0013YL\bC\u0001$x\u0013\tAxI\u0001\u0004B]f\u0014VM\u001a\t\u0003\rjL!a_$\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003Q\fq\u0002^8OKR$\u0018PU3ta>t7/\u001a\u000b\u0004\u007f\u0006\u0015\u0001c\u0001\u0012\u0002\u0002%\u0019\u00111A\u0012\u0003/\u0011+g-Y;mi\u001a+H\u000e\u001c%uiB\u0014Vm\u001d9p]N,\u0007bBA\u0004\u0017\u0001\u0007\u0011\u0011B\u0001\te\u0016\u001c\bo\u001c8tKB!\u00111BA\u000f\u001d\u0011\ti!!\u0007\u000f\t\u0005=\u0011q\u0003\b\u0005\u0003#\t)BD\u0002V\u0003'I\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0007\u0005m\u0001#A\u0006IiR\u0004X*Z:tC\u001e,\u0017\u0002BA\u0010\u0003C\u0011\u0001BU3ta>t7/\u001a\u0006\u0004\u00037\u0001\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005!A.\u00198h\u0015\t\t\t$\u0001\u0003kCZ\f\u0017\u0002BA\u001b\u0003W\u0011aa\u00142kK\u000e$\b")
public class NettyRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements LogSupport {
    private final HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static DefaultFullHttpResponse toNettyResponse(HttpMessage.Response response) {
        return NettyRequestHandler$.MODULE$.toNettyResponse(response);
    }

    private Logger logger$lzycompute() {
        NettyRequestHandler nettyRequestHandler = this;
        synchronized (nettyRequestHandler) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "NettyRequestHandler.scala", 43, 9), (Object)cause);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        HttpMessage.Request request2;
        String string = msg.method().name();
        if ("GET".equals(string)) {
            request2 = Http$.MODULE$.GET(msg.uri());
        } else if ("POST".equals(string)) {
            request2 = Http$.MODULE$.POST(msg.uri());
        } else if ("PUT".equals(string)) {
            request2 = Http$.MODULE$.PUT(msg.uri());
        } else if ("DELETE".equals(string)) {
            request2 = Http$.MODULE$.DELETE(msg.uri());
        } else if ("PATCH".equals(string)) {
            request2 = Http$.MODULE$.PATCH(msg.uri());
        } else if ("TRACE".equals(string)) {
            request2 = Http$.MODULE$.request("TRACE", msg.uri());
        } else if ("OPTIONS".equals(string)) {
            request2 = Http$.MODULE$.request("OPTIONS", msg.uri());
        } else {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        ObjectRef req = ObjectRef.create((Object)request2);
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            req.elem = ((HttpMessage.Request)req.elem).withRemoteAddress(ServerAddress$.MODULE$.apply(new StringBuilder(1).append(inetSocketAddress.getHostString()).append(":").append(inetSocketAddress.getPort()).toString()));
        }
        ((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(msg.headers().names()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> {
            req.elem = (HttpMessage.Request)((HttpMessage.Request)req.elem).withHeader(x, msg.headers().get(x));
            return BoxedUnit.UNIT;
        }, Set$.MODULE$.canBuildFrom());
        ByteBuf requestBody = msg.content();
        int requestBodySize = requestBody.readableBytes();
        if (requestBodySize > 0) {
            byte[] buf = new byte[requestBodySize];
            requestBody.getBytes(requestBody.readerIndex(), buf);
            req.elem = (HttpMessage.Request)((HttpMessage.Request)req.elem).withContent(buf);
        }
        Rx rxResponse = (Rx)this.dispatcher.apply((Object)((HttpMessage.Request)req.elem), NettyBackend$.MODULE$.newContext((Function1<HttpMessage.Request, Rx<HttpMessage.Response>>)(Function1 & Serializable & scala.Serializable)request -> Rx$.MODULE$.single((Function0 & Serializable & scala.Serializable)() -> Http$.MODULE$.response((HttpStatus)HttpStatus.NotFound_404$.MODULE$))));
        RxRunner$.MODULE$.run((RxOps)rxResponse, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            NettyRequestHandler.$anonfun$channelRead0$4(this, msg, ctx, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void writeResponse(HttpRequest req, ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        boolean keepAlive;
        boolean bl = keepAlive = HttpStatus$.MODULE$.ofCode(resp.status().code()).isSuccessful() && HttpUtil.isKeepAlive((HttpMessage)req);
        Object object = keepAlive ? (!req.protocolVersion().isKeepAliveDefault() ? resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE) : BoxedUnit.UNIT) : resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ChannelFuture f = ctx.write((Object)resp);
        if (!keepAlive) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$channelRead0$4(NettyRequestHandler $this, FullHttpRequest msg$1, ChannelHandlerContext ctx$1, RxEvent x0$1) {
        RxEvent rxEvent = x0$1;
        if (rxEvent instanceof OnNext) {
            OnNext onNext = (OnNext)rxEvent;
            Object v = onNext.v();
            DefaultFullHttpResponse nettyResponse = NettyRequestHandler$.MODULE$.toNettyResponse((HttpMessage.Response)v);
            $this.writeResponse((HttpRequest)msg$1, ctx$1, (DefaultHttpResponse)nettyResponse);
            return;
        }
        if (rxEvent instanceof OnError) {
            OnError onError = (OnError)rxEvent;
            Throwable ex = onError.e();
            HttpMessage.Response resp = RPCStatus.INTERNAL_ERROR_I0$.MODULE$.newException(ex.getMessage(), ex, RPCStatus.INTERNAL_ERROR_I0$.MODULE$.newException$default$3(), RPCStatus.INTERNAL_ERROR_I0$.MODULE$.newException$default$4()).toResponse();
            DefaultFullHttpResponse nettyResponse = NettyRequestHandler$.MODULE$.toNettyResponse(resp);
            $this.writeResponse((HttpRequest)msg$1, ctx$1, (DefaultHttpResponse)nettyResponse);
            return;
        }
        if (OnCompletion$.MODULE$.equals(rxEvent)) {
            return;
        }
        throw new MatchError((Object)rxEvent);
    }

    public NettyRequestHandler(NettyServerConfig config, HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher) {
        this.dispatcher = dispatcher;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

