/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import wvlet.airframe.Session;
import wvlet.airframe.codec.MessageCodecFactory$;
import wvlet.airframe.control.ThreadUtil$;
import wvlet.airframe.http.Compat$;
import wvlet.airframe.http.HttpBackend;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.RPCContext;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.RxHttpFilter;
import wvlet.airframe.http.internal.RPCResponseFilter$;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyRPCContext;
import wvlet.airframe.http.netty.NettyRequestHandler;
import wvlet.airframe.http.netty.NettyResponseHandler;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.http.router.HttpRequestDispatcher$;
import wvlet.airframe.http.router.ResponseHandler;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u000e\u001d\u0001\u0015B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0011\t\u0001C\u0001\u0005\"9a\t\u0001b\u0001\n\u00139\u0005B\u0002'\u0001A\u0003%\u0001\nC\u0004N\u0001\t\u0007I\u0011\u0002(\t\rI\u0003\u0001\u0015!\u0003P\u0011\u001d\u0019\u0006A1A\u0005\nQCaA\u0018\u0001!\u0002\u0013)\u0006bB0\u0001\u0005\u0004%I\u0001\u0016\u0005\u0007A\u0002\u0001\u000b\u0011B+\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\"9A\u000e\u0001a\u0001\n\u0013i\u0007BB:\u0001A\u0003&1\rC\u0004u\u0001\t\u0007I\u0011A;\t\u000f\u0005\r\u0001\u0001)A\u0005m\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0001\"CA\u000b\u0001\t\u0007I\u0011BA\f\u0011!\ti\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0018\u0001\t\u0007I\u0011BA\f\u0011!\t\t\u0004\u0001Q\u0001\n\u0005e\u0001bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0013\u0002A\u0011BA\u001b\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u0014\u0001\t\u0003\ni\u0005C\u0004\u0002R\u0001!\t!!\u0014\u0003\u00179+G\u000f^=TKJ4XM\u001d\u0006\u0003;y\tQA\\3uifT!a\b\u0011\u0002\t!$H\u000f\u001d\u0006\u0003C\t\n\u0001\"Y5sMJ\fW.\u001a\u0006\u0002G\u0005)qO\u001e7fi\u000e\u00011\u0003\u0002\u0001']E\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004PE*,7\r\u001e\t\u0003O=J!\u0001\r\u0015\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f!\t\u0011T'D\u00014\u0015\t!$%A\u0002m_\u001eL!AN\u001a\u0003\u00151{wmU;qa>\u0014H/\u0001\u0004d_:4\u0017n\u001a\t\u0003sij\u0011\u0001H\u0005\u0003wq\u0011\u0011CT3uif\u001cVM\u001d<fe\u000e{gNZ5h\u0003\u001d\u0019Xm]:j_:\u0004\"AP \u000e\u0003\u0001J!\u0001\u0011\u0011\u0003\u000fM+7o]5p]\u00061A(\u001b8jiz\"2a\u0011#F!\tI\u0004\u0001C\u00038\u0007\u0001\u0007\u0001\bC\u0003=\u0007\u0001\u0007Q(\u0001\u0006iiR\u0004Hj\\4hKJ,\u0012\u0001\u0013\t\u0003\u0013*k\u0011AH\u0005\u0003\u0017z\u0011!\u0002\u0013;ua2{wmZ3s\u0003-AG\u000f\u001e9M_\u001e<WM\u001d\u0011\u0002\u001b1|wmZ5oO\u001aKG\u000e^3s+\u0005y\u0005CA%Q\u0013\t\tfD\u0001\u0007Sq\"#H\u000f\u001d$jYR,'/\u0001\bm_\u001e<\u0017N\\4GS2$XM\u001d\u0011\u0002\u0013\t|7o]$s_V\u0004X#A+\u0011\u0005YcV\"A,\u000b\u0005aK\u0016aB2iC:tW\r\u001c\u0006\u0003;iS\u0011aW\u0001\u0003S>L!!X,\u000335+H\u000e^5uQJ,\u0017\rZ#wK:$Hj\\8q\u000fJ|W\u000f]\u0001\u000bE>\u001c8o\u0012:pkB\u0004\u0013aC<pe.,'o\u0012:pkB\fAb^8sW\u0016\u0014xI]8va\u0002\nQb\u00195b]:,GNR;ukJ,W#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u0019y\u0005\u000f^5p]B\u0011aK[\u0005\u0003W^\u0013qa\u00115b]:,G.A\tdQ\u0006tg.\u001a7GkR,(/Z0%KF$\"A\\9\u0011\u0005\u0011|\u0017B\u00019f\u0005\u0011)f.\u001b;\t\u000fIl\u0011\u0011!a\u0001G\u0006\u0019\u0001\u0010J\u0019\u0002\u001d\rD\u0017M\u001c8fY\u001a+H/\u001e:fA\u0005aAn\\2bY\u0006#GM]3tgV\ta\u000f\u0005\u0002x}:\u0011\u0001\u0010 \t\u0003s\u0016l\u0011A\u001f\u0006\u0003w\u0012\na\u0001\u0010:p_Rt\u0014BA?f\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\rM#(/\u001b8h\u0015\tiX-A\u0007m_\u000e\fG.\u00113ee\u0016\u001c8\u000fI\u0001\u0014CR$\u0018m\u00195D_:$X\r\u001f;GS2$XM]\u000b\u0003\u0003\u0013\u0011R!a\u0003\u0002\u0010=3a!!\u0004\u0012\u0001\u0005%!\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u00013\u0002\u0012%\u0019\u00111C3\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0019H/\u0019:uK\u0012,\"!!\u0007\u0011\t\u0005m\u0011\u0011F\u0007\u0003\u0003;QA!a\b\u0002\"\u00051\u0011\r^8nS\u000eTA!a\t\u0002&\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005\u001d\"&\u0001\u0003vi&d\u0017\u0002BA\u0016\u0003;\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001C:uCJ$X\r\u001a\u0011\u0002\u000fM$x\u000e\u001d9fI\u0006A1\u000f^8qa\u0016$\u0007%A\u0003ti\u0006\u0014H/F\u0001oQ\r1\u0012\u0011\b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003\u0007\nQA[1wCbLA!a\u0012\u0002>\ti\u0001k\\:u\u0007>t7\u000f\u001e:vGR\fQb\u001d;beRLe\u000e^3s]\u0006d\u0017\u0001B:u_B$\u0012A\\\u0001\u0006G2|7/Z\u0001\u0011C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:\u0004")
public class NettyServer
implements AutoCloseable,
LogSupport {
    public final NettyServerConfig wvlet$airframe$http$netty$NettyServer$$config;
    public final Session wvlet$airframe$http$netty$NettyServer$$session;
    private final HttpLogger httpLogger;
    private final RxHttpFilter wvlet$airframe$http$netty$NettyServer$$loggingFilter;
    private final MultithreadEventLoopGroup bossGroup;
    private final MultithreadEventLoopGroup workerGroup;
    private Option<Channel> channelFuture;
    private final String localAddress;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private HttpLogger httpLogger() {
        return this.httpLogger;
    }

    public RxHttpFilter wvlet$airframe$http$netty$NettyServer$$loggingFilter() {
        return this.wvlet$airframe$http$netty$NettyServer$$loggingFilter;
    }

    private MultithreadEventLoopGroup bossGroup() {
        return this.bossGroup;
    }

    private MultithreadEventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    private Option<Channel> channelFuture() {
        return this.channelFuture;
    }

    private void channelFuture_$eq(Option<Channel> x$1) {
        this.channelFuture = x$1;
    }

    public String localAddress() {
        return this.localAddress;
    }

    public RxHttpFilter wvlet$airframe$http$netty$NettyServer$$attachContextFilter() {
        return new RxHttpFilter(null){

            public RxHttpFilter andThen(RxHttpFilter nextFilter) {
                return RxHttpFilter.andThen$((RxHttpFilter)this, (RxHttpFilter)nextFilter);
            }

            public RxHttpEndpoint andThen(RxHttpEndpoint endpoint) {
                return RxHttpFilter.andThen$((RxHttpFilter)this, (RxHttpEndpoint)endpoint);
            }

            public Rx<HttpMessage.Response> apply(HttpMessage.Request request, RxHttpEndpoint next) {
                NettyRPCContext context = new NettyRPCContext(request);
                Compat$.MODULE$.attachRPCContext((RPCContext)context);
                return next.apply(request).toRx().transformRx((Function1 & Serializable & scala.Serializable)v -> {
                    Compat$.MODULE$.detachRPCContext((RPCContext)context);
                    Try try_ = v;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        HttpMessage.Response v2 = (HttpMessage.Response)success.value();
                        return Rx$.MODULE$.single((Function0 & Serializable & scala.Serializable)() -> v2);
                    }
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        return Rx$.MODULE$.exception(e);
                    }
                    throw new MatchError((Object)try_);
                });
            }
            {
                RxHttpFilter.$init$((RxHttpFilter)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(wvlet.airframe.http.netty.NettyRPCContext scala.util.Try ), $anonfun$apply$2(wvlet.airframe.http.HttpMessage$Response )}, serializedLambda);
            }
        };
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    @PostConstruct
    public void start() {
        if (this.stopped().get()) {
            throw new IllegalStateException(new StringBuilder(25).append("Server ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" is already closed").toString());
        }
        if (this.started().compareAndSet(false, true)) {
            this.startInternal();
            return;
        }
    }

    private void startInternal() {
        AbstractBootstrap abstractBootstrap;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("", "NettyServer.scala", 172, 9), (Object)new StringBuilder(20).append("Starting ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" server at ").append(this.localAddress()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)this.bossGroup(), (EventLoopGroup)this.workerGroup());
        if (this.wvlet$airframe$http$netty$NettyServer$$config.useEpoll() && Epoll.isAvailable()) {
            b.channel(EpollServerSocketChannel.class);
            abstractBootstrap = b.option(UnixChannelOption.SO_REUSEPORT, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            abstractBootstrap = b.channel(NioServerSocketChannel.class);
        }
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)BoxesRunTime.boxToInteger((int)((int)TimeUnit.SECONDS.toMillis(1L))));
        b.option(ChannelOption.SO_REUSEADDR, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.option(ChannelOption.SO_BACKLOG, (Object)BoxesRunTime.boxToInteger((int)1024));
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.TCP_NODELAY, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)WriteBufferWaterMark.DEFAULT);
        PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;
        b.option(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){
            private final HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher;
            private final /* synthetic */ NettyServer $outer;

            private HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher() {
                return this.dispatcher;
            }

            public void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
                pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new NettyRequestHandler(this.$outer.wvlet$airframe$http$netty$NettyServer$$config, this.dispatcher())});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dispatcher = NettyBackend$.MODULE$.rxFilterAdapter($outer.wvlet$airframe$http$netty$NettyServer$$attachContextFilter().andThen($outer.wvlet$airframe$http$netty$NettyServer$$loggingFilter()).andThen((RxHttpFilter)RPCResponseFilter$.MODULE$)).andThen(HttpRequestDispatcher$.MODULE$.newDispatcher($outer.wvlet$airframe$http$netty$NettyServer$$session, $outer.wvlet$airframe$http$netty$NettyServer$$config.router(), $outer.wvlet$airframe$http$netty$NettyServer$$config.controllerProvider(), (HttpBackend)NettyBackend$.MODULE$, (ResponseHandler)new NettyResponseHandler(), MessageCodecFactory$.MODULE$.defaultFactoryForJSON(), (HttpRequestAdapter)HttpMessage.HttpMessageRequestAdapter$.MODULE$));
            }
        });
        this.channelFuture_$eq((Option<Channel>)new Some((Object)b.bind(this.wvlet$airframe$http$netty$NettyServer$$config.port()).sync().channel()));
    }

    public void stop() {
        if (this.stopped().compareAndSet(false, true)) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("", "NettyServer.scala", 253, 11), (Object)new StringBuilder(20).append("Stopping ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" server at ").append(this.localAddress()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.workerGroup().shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.bossGroup().shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.httpLogger().close();
            this.channelFuture().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NettyServer.$anonfun$stop$1(x$4)));
            return;
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    public void awaitTermination() {
        this.channelFuture().foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.closeFuture().sync());
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(Channel x$4) {
        return x$4.close().await(1L, TimeUnit.SECONDS);
    }

    public NettyServer(NettyServerConfig config, Session session) {
        this.wvlet$airframe$http$netty$NettyServer$$config = config;
        this.wvlet$airframe$http$netty$NettyServer$$session = session;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.httpLogger = config.newHttpLogger();
        this.wvlet$airframe$http$netty$NettyServer$$loggingFilter = (RxHttpFilter)config.loggingFilter().apply((Object)this.httpLogger());
        ThreadFactory tf = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-boss");
        this.bossGroup = config.canUseEpoll() ? new EpollEventLoopGroup(1, tf) : new NioEventLoopGroup(1, tf);
        ThreadFactory tf2 = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-worker");
        int numWorkers = package$.MODULE$.max(4, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() / (double)3)));
        this.workerGroup = config.canUseEpoll() ? new EpollEventLoopGroup(numWorkers, tf2) : new NioEventLoopGroup(numWorkers, tf2);
        this.channelFuture = None$.MODULE$;
        this.localAddress = new StringBuilder(10).append("localhost:").append(config.port()).toString();
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
    }
}

