/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Try;
import wvlet.airframe.Session;
import wvlet.airframe.codec.MessageCodecFactory$;
import wvlet.airframe.control.ThreadUtil$;
import wvlet.airframe.http.Compat$;
import wvlet.airframe.http.HttpBackend;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.HttpServer;
import wvlet.airframe.http.RPCContext;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.RxHttpFilter;
import wvlet.airframe.http.internal.RPCResponseFilter;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyRPCContext;
import wvlet.airframe.http.netty.NettyRequestHandler;
import wvlet.airframe.http.netty.NettyResponseHandler;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.http.router.HttpRequestDispatcher$;
import wvlet.airframe.http.router.ResponseHandler;
import wvlet.airframe.rx.Rx;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\r\u001b\u0001\rB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)\u0001\t\u0001C\u0001\u0003\"9Q\t\u0001b\u0001\n\u00131\u0005B\u0002&\u0001A\u0003%q\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u001d\t\u0006A1A\u0005\nICa\u0001\u0018\u0001!\u0002\u0013\u0019\u0006bB/\u0001\u0005\u0004%IA\u0015\u0005\u0007=\u0002\u0001\u000b\u0011B*\t\u000f}\u0003\u0001\u0019!C\u0005A\"9!\u000e\u0001a\u0001\n\u0013Y\u0007BB9\u0001A\u0003&\u0011\rC\u0003s\u0001\u0011\u00053\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#A\u0001\"a\n\u0001A\u0003%\u00111\u0003\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003#A\u0001\"a\u000b\u0001A\u0003%\u00111\u0003\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003_Aq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002J\u0001!\t%a\u0012\u0003\u00179+G\u000f^=TKJ4XM\u001d\u0006\u00037q\tQA\\3uifT!!\b\u0010\u0002\t!$H\u000f\u001d\u0006\u0003?\u0001\n\u0001\"Y5sMJ\fW.\u001a\u0006\u0002C\u0005)qO\u001e7fi\u000e\u00011\u0003\u0002\u0001%YA\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004PE*,7\r\u001e\t\u0003[9j\u0011\u0001H\u0005\u0003_q\u0011!\u0002\u0013;uaN+'O^3s!\t\tD'D\u00013\u0015\t\u0019\u0004%A\u0002m_\u001eL!!\u000e\u001a\u0003\u00151{wmU;qa>\u0014H/\u0001\u0004d_:4\u0017n\u001a\t\u0003qej\u0011AG\u0005\u0003ui\u0011\u0011CT3uif\u001cVM\u001d<fe\u000e{gNZ5h\u0003\u001d\u0019Xm]:j_:\u0004\"!\u0010 \u000e\u0003yI!a\u0010\u0010\u0003\u000fM+7o]5p]\u00061A(\u001b8jiz\"2AQ\"E!\tA\u0004\u0001C\u00037\u0007\u0001\u0007q\u0007C\u0003<\u0007\u0001\u0007A(\u0001\u0006iiR\u0004Hj\\4hKJ,\u0012a\u0012\t\u0003[!K!!\u0013\u000f\u0003\u0015!#H\u000f\u001d'pO\u001e,'/A\u0006iiR\u0004Hj\\4hKJ\u0004\u0013!\u0003:qG\u001aKG\u000e^3s+\u0005i\u0005CA\u0017O\u0013\tyED\u0001\u0007Sq\"#H\u000f\u001d$jYR,'/\u0001\u0006sa\u000e4\u0015\u000e\u001c;fe\u0002\n\u0011BY8tg\u001e\u0013x.\u001e9\u0016\u0003M\u0003\"\u0001\u0016.\u000e\u0003US!AV,\u0002\u000f\rD\u0017M\u001c8fY*\u00111\u0004\u0017\u0006\u00023\u0006\u0011\u0011n\\\u0005\u00037V\u0013\u0011$T;mi&$\bN]3bI\u00163XM\u001c;M_>\u0004xI]8va\u0006Q!m\\:t\u000fJ|W\u000f\u001d\u0011\u0002\u0017]|'o[3s\u000fJ|W\u000f]\u0001\ro>\u00148.\u001a:He>,\b\u000fI\u0001\u000eG\"\fgN\\3m\rV$XO]3\u0016\u0003\u0005\u00042AY3h\u001b\u0005\u0019'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001c'AB(qi&|g\u000e\u0005\u0002UQ&\u0011\u0011.\u0016\u0002\b\u0007\"\fgN\\3m\u0003E\u0019\u0007.\u00198oK24U\u000f^;sK~#S-\u001d\u000b\u0003Y>\u0004\"AY7\n\u00059\u001c'\u0001B+oSRDq\u0001]\u0007\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\nab\u00195b]:,GNR;ukJ,\u0007%\u0001\u0007m_\u000e\fG.\u00113ee\u0016\u001c8/F\u0001u!\t)HP\u0004\u0002wuB\u0011qoY\u0007\u0002q*\u0011\u0011PI\u0001\u0007yI|w\u000e\u001e \n\u0005m\u001c\u0017A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a_2\u0002'\u0005$H/Y2i\u0007>tG/\u001a=u\r&dG/\u001a:\u0016\u0005\u0005\r!#BA\u0003\u0003\u0013ieABA\u0004!\u0001\t\u0019A\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002c\u0003\u0017I1!!\u0004d\u0005\u0019\te.\u001f*fM\u000691\u000f^1si\u0016$WCAA\n!\u0011\t)\"a\t\u000e\u0005\u0005]!\u0002BA\r\u00037\ta!\u0019;p[&\u001c'\u0002BA\u000f\u0003?\t!bY8oGV\u0014(/\u001a8u\u0015\r\t\t\u0003K\u0001\u0005kRLG.\u0003\u0003\u0002&\u0005]!!D!u_6L7MQ8pY\u0016\fg.\u0001\u0005ti\u0006\u0014H/\u001a3!\u0003\u001d\u0019Ho\u001c9qK\u0012\f\u0001b\u001d;paB,G\rI\u0001\u0006gR\f'\u000f^\u000b\u0002Y\"\u001aQ#a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005u\u0012!\u00026bm\u0006D\u0018\u0002BA!\u0003o\u0011Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\u0018!D:uCJ$\u0018J\u001c;fe:\fG.\u0001\u0003ti>\u0004H#\u00017\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007")
public class NettyServer
implements HttpServer,
LogSupport {
    public final NettyServerConfig wvlet$airframe$http$netty$NettyServer$$config;
    public final Session wvlet$airframe$http$netty$NettyServer$$session;
    private final HttpLogger httpLogger;
    private final RxHttpFilter wvlet$airframe$http$netty$NettyServer$$rpcFilter;
    private final MultithreadEventLoopGroup bossGroup;
    private final MultithreadEventLoopGroup workerGroup;
    private Option<Channel> channelFuture;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void close() {
        HttpServer.close$((HttpServer)this);
    }

    private Logger logger$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private HttpLogger httpLogger() {
        return this.httpLogger;
    }

    public RxHttpFilter wvlet$airframe$http$netty$NettyServer$$rpcFilter() {
        return this.wvlet$airframe$http$netty$NettyServer$$rpcFilter;
    }

    private MultithreadEventLoopGroup bossGroup() {
        return this.bossGroup;
    }

    private MultithreadEventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    private Option<Channel> channelFuture() {
        return this.channelFuture;
    }

    private void channelFuture_$eq(Option<Channel> x$1) {
        this.channelFuture = x$1;
    }

    public String localAddress() {
        return new StringBuilder(10).append("localhost:").append(this.wvlet$airframe$http$netty$NettyServer$$config.port()).toString();
    }

    public RxHttpFilter wvlet$airframe$http$netty$NettyServer$$attachContextFilter() {
        return new RxHttpFilter(null){

            public RxHttpFilter andThen(RxHttpFilter nextFilter) {
                return RxHttpFilter.andThen$((RxHttpFilter)this, (RxHttpFilter)nextFilter);
            }

            public RxHttpEndpoint andThen(RxHttpEndpoint endpoint) {
                return RxHttpFilter.andThen$((RxHttpFilter)this, (RxHttpEndpoint)endpoint);
            }

            public RxHttpEndpoint andThen(Function1<HttpMessage.Request, Rx<HttpMessage.Response>> body) {
                return RxHttpFilter.andThen$((RxHttpFilter)this, body);
            }

            public Rx<HttpMessage.Response> apply(HttpMessage.Request request, RxHttpEndpoint next) {
                NettyRPCContext context = new NettyRPCContext(request);
                Compat$.MODULE$.attachRPCContext((RPCContext)context);
                return next.apply(request).tapOn((PartialFunction)new scala.Serializable(null, context){
                    public static final long serialVersionUID = 0L;
                    private final NettyRPCContext context$1;

                    public final <A1 extends Try<HttpMessage.Response>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Compat$.MODULE$.detachRPCContext((RPCContext)this.context$1);
                        return (B1)BoxedUnit.UNIT;
                    }

                    public final boolean isDefinedAt(Try<HttpMessage.Response> x1) {
                        Try<HttpMessage.Response> try_ = x1;
                        return true;
                    }
                    {
                        this.context$1 = context$1;
                    }
                });
            }
            {
                RxHttpFilter.$init$((RxHttpFilter)this);
            }
        };
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    @PostConstruct
    public void start() {
        if (this.stopped().get()) {
            throw new IllegalStateException(new StringBuilder(25).append("Server ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" is already closed").toString());
        }
        if (this.started().compareAndSet(false, true)) {
            this.startInternal();
            return;
        }
    }

    private void startInternal() {
        AbstractBootstrap abstractBootstrap;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("", "NettyServer.scala", 195, 9), (Object)new StringBuilder(20).append("Starting ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" server at ").append(this.localAddress()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)this.bossGroup(), (EventLoopGroup)this.workerGroup());
        if (this.wvlet$airframe$http$netty$NettyServer$$config.useEpoll() && Epoll.isAvailable()) {
            b.channel(EpollServerSocketChannel.class);
            abstractBootstrap = b.option(UnixChannelOption.SO_REUSEPORT, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            abstractBootstrap = b.channel(NioServerSocketChannel.class);
        }
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)BoxesRunTime.boxToInteger((int)((int)TimeUnit.SECONDS.toMillis(30000L))));
        b.option(ChannelOption.SO_REUSEADDR, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.option(ChannelOption.SO_BACKLOG, (Object)BoxesRunTime.boxToInteger((int)1024));
        b.childOption(ChannelOption.TCP_NODELAY, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.SO_SNDBUF, (Object)BoxesRunTime.boxToInteger((int)0x280000));
        b.childOption(ChannelOption.SO_RCVBUF, (Object)BoxesRunTime.boxToInteger((int)131072));
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)WriteBufferWaterMark.DEFAULT);
        b.childOption(ChannelOption.AUTO_READ, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.AUTO_CLOSE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;
        b.option(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){
            private final HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher;
            private final /* synthetic */ NettyServer $outer;

            private HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher() {
                return this.dispatcher;
            }

            public void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec(4096, 65536, Integer.MAX_VALUE, true)});
                pipeline.addLast(new ChannelHandler[]{new HttpServerKeepAliveHandler()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
                pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new NettyRequestHandler(this.$outer.wvlet$airframe$http$netty$NettyServer$$config, this.dispatcher())});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dispatcher = NettyBackend$.MODULE$.rxFilterAdapter($outer.wvlet$airframe$http$netty$NettyServer$$attachContextFilter().andThen($outer.wvlet$airframe$http$netty$NettyServer$$rpcFilter())).andThen(HttpRequestDispatcher$.MODULE$.newDispatcher($outer.wvlet$airframe$http$netty$NettyServer$$session, $outer.wvlet$airframe$http$netty$NettyServer$$config.router(), $outer.wvlet$airframe$http$netty$NettyServer$$config.controllerProvider(), (HttpBackend)NettyBackend$.MODULE$, (ResponseHandler)new NettyResponseHandler(), MessageCodecFactory$.MODULE$.defaultFactoryForJSON().withCodecs($outer.wvlet$airframe$http$netty$NettyServer$$config.customCodec()), $outer.wvlet$airframe$http$netty$NettyServer$$config.executionContext(), (HttpRequestAdapter)HttpMessage.HttpMessageRequestAdapter$.MODULE$));
            }
        });
        this.channelFuture_$eq((Option<Channel>)new Some((Object)b.bind(this.wvlet$airframe$http$netty$NettyServer$$config.port()).sync().channel()));
    }

    public void stop() {
        if (this.stopped().compareAndSet(false, true)) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("", "NettyServer.scala", 268, 11), (Object)new StringBuilder(20).append("Stopping ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" server at ").append(this.localAddress()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.workerGroup().shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.bossGroup().shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.httpLogger().close();
            this.channelFuture().foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)NettyServer.$anonfun$stop$1(x$3)));
            return;
        }
    }

    public void awaitTermination() {
        this.channelFuture().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.closeFuture().sync());
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(Channel x$3) {
        return x$3.close().await(1L, TimeUnit.SECONDS);
    }

    public NettyServer(NettyServerConfig config, Session session) {
        this.wvlet$airframe$http$netty$NettyServer$$config = config;
        this.wvlet$airframe$http$netty$NettyServer$$session = session;
        HttpServer.$init$((HttpServer)this);
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.httpLogger = config.newHttpLogger();
        this.wvlet$airframe$http$netty$NettyServer$$rpcFilter = new RPCResponseFilter(this.httpLogger());
        ThreadFactory tf = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-boss");
        this.bossGroup = config.canUseEpoll() ? new EpollEventLoopGroup(1, tf) : new NioEventLoopGroup(1, tf);
        ThreadFactory tf2 = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-worker");
        int numWorkers = package$.MODULE$.max(4, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() / (double)3)));
        this.workerGroup = config.canUseEpoll() ? new EpollEventLoopGroup(numWorkers, tf2) : new NioEventLoopGroup(numWorkers, tf2);
        this.channelFuture = None$.MODULE$;
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
    }
}

