/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.ServerAddress$;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.rx.OnCompletion$;
import wvlet.airframe.rx.OnError;
import wvlet.airframe.rx.OnNext;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.rx.RxEvent;
import wvlet.airframe.rx.RxRunner$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0005\u000b\u0001MA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)!\b\u0001C\u0001w!)q\b\u0001C!\u0001\")!\f\u0001C!7\")Q\f\u0001C!=\")!\r\u0001C\u0005G\")q\u000e\u0001C\u0005a\n\u0019b*\u001a;uQJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u00111\u0002D\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u001b9\tA\u0001\u001b;ua*\u0011q\u0002E\u0001\tC&\u0014hM]1nK*\t\u0011#A\u0003xm2,Go\u0001\u0001\u0014\u0007\u0001!b\u0005E\u0002\u00167ui\u0011A\u0006\u0006\u0003/a\tqa\u00195b]:,GN\u0003\u0002\f3)\t!$\u0001\u0002j_&\u0011AD\u0006\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005y!S\"A\u0010\u000b\u00055\u0001#BA\u0011#\u0003\u0015\u0019w\u000eZ3d\u0015\t\u0019\u0003$A\u0004iC:$G.\u001a:\n\u0005\u0015z\"a\u0004$vY2DE\u000f\u001e9SKF,Xm\u001d;\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\u0002\u0012a\u00017pO&\u00111\u0006\u000b\u0002\u000b\u0019><7+\u001e9q_J$\u0018AB2p]\u001aLw\r\u0005\u0002/_5\t!\"\u0003\u00021\u0015\t\tb*\u001a;usN+'O^3s\u0007>tg-[4\u0002\u0015\u0011L7\u000f]1uG\",'\u000f\u0005\u00024m9\u0011a\u0006N\u0005\u0003k)\tABT3uif\u0014\u0015mY6f]\u0012L!a\u000e\u001d\u0003\r\u0019KG\u000e^3s\u0013\tIDBA\u0006IiR\u0004()Y2lK:$\u0017A\u0002\u001fj]&$h\bF\u0002={y\u0002\"A\f\u0001\t\u000b1\u001a\u0001\u0019A\u0017\t\u000bE\u001a\u0001\u0019\u0001\u001a\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$2!Q$M!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0011)f.\u001b;\t\u000b!#\u0001\u0019A%\u0002\u0007\r$\b\u0010\u0005\u0002\u0016\u0015&\u00111J\u0006\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u0015iE\u00011\u0001O\u0003\u0015\u0019\u0017-^:f!\tyuK\u0004\u0002Q+:\u0011\u0011\u000bV\u0007\u0002%*\u00111KE\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!AV\"\u0002\u000fA\f7m[1hK&\u0011\u0001,\u0017\u0002\n)\"\u0014xn^1cY\u0016T!AV\"\u0002'\rD\u0017M\u001c8fYJ+\u0017\rZ\"p[BdW\r^3\u0015\u0005\u0005c\u0006\"\u0002%\u0006\u0001\u0004I\u0015\u0001D2iC:tW\r\u001c*fC\u0012\u0004DcA!`A\")\u0001J\u0002a\u0001\u0013\")\u0011M\u0002a\u0001;\u0005\u0019Qn]4\u0002\u001b]\u0014\u0018\u000e^3SKN\u0004xN\\:f)\u0011\tE-\u001b6\t\u000b\u0015<\u0001\u0019\u00014\u0002\u0007I,\u0017\u000f\u0005\u0002\u001fO&\u0011\u0001n\b\u0002\f\u0011R$\bOU3rk\u0016\u001cH\u000fC\u0003I\u000f\u0001\u0007\u0011\nC\u0003l\u000f\u0001\u0007A.\u0001\u0003sKN\u0004\bC\u0001\u0010n\u0013\tqwDA\nEK\u001a\fW\u000f\u001c;IiR\u0004(+Z:q_:\u001cX-A\bu_:+G\u000f^=SKN\u0004xN\\:f)\ta\u0017\u000fC\u0003s\u0011\u0001\u00071/\u0001\u0005sKN\u0004xN\\:f!\t!XP\u0004\u0002vw:\u0011aO\u001f\b\u0003oft!!\u0015=\n\u0003EI!a\u0004\t\n\u00055q\u0011B\u0001?\r\u0003-AE\u000f\u001e9NKN\u001c\u0018mZ3\n\u0005y|(\u0001\u0003*fgB|gn]3\u000b\u0005qd\u0001")
public class NetthRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements LogSupport {
    private final HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        NetthRequestHandler netthRequestHandler = this;
        synchronized (netthRequestHandler) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "NetthRequestHandler.scala", 32, 9), (Object)cause);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        HttpMessage.Request request2;
        block11: {
            String string = msg.method().name();
            switch (string == null ? 0 : string.hashCode()) {
                case -531492226: {
                    if (!"OPTIONS".equals(string)) break;
                    request2 = Http$.MODULE$.request("OPTIONS", msg.uri());
                    break block11;
                }
                case 70454: {
                    if (!"GET".equals(string)) break;
                    request2 = Http$.MODULE$.GET(msg.uri());
                    break block11;
                }
                case 79599: {
                    if (!"PUT".equals(string)) break;
                    request2 = Http$.MODULE$.PUT(msg.uri());
                    break block11;
                }
                case 2461856: {
                    if (!"POST".equals(string)) break;
                    request2 = Http$.MODULE$.POST(msg.uri());
                    break block11;
                }
                case 75900968: {
                    if (!"PATCH".equals(string)) break;
                    request2 = Http$.MODULE$.PATCH(msg.uri());
                    break block11;
                }
                case 80083237: {
                    if (!"TRACE".equals(string)) break;
                    request2 = Http$.MODULE$.request("TRACE", msg.uri());
                    break block11;
                }
                case 2012838315: {
                    if (!"DELETE".equals(string)) break;
                    request2 = Http$.MODULE$.DELETE(msg.uri());
                    break block11;
                }
            }
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        ObjectRef req = ObjectRef.create((Object)request2);
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            req.elem = ((HttpMessage.Request)req.elem).withRemoteAddress(ServerAddress$.MODULE$.apply(new StringBuilder(1).append(inetSocketAddress.getAddress()).append(":").append(inetSocketAddress.getPort()).toString()));
        }
        CollectionConverters$.MODULE$.SetHasAsScala(msg.headers().names()).asScala().map((Function1 & Serializable)x -> {
            req.elem = (HttpMessage.Request)((HttpMessage.Request)req.elem).withHeader(x, msg.headers().get(x));
            return BoxedUnit.UNIT;
        });
        ByteBuf requestBody = msg.content();
        int requestBodySize = requestBody.readableBytes();
        if (requestBodySize > 0) {
            byte[] buf = new byte[requestBodySize];
            requestBody.getBytes(requestBody.readerIndex(), buf);
            req.elem = (HttpMessage.Request)((HttpMessage.Request)req.elem).withContent(buf);
        }
        Rx rxResponse = (Rx)this.dispatcher.apply((Object)((HttpMessage.Request)req.elem), NettyBackend$.MODULE$.newContext((Function1<HttpMessage.Request, Rx<HttpMessage.Response>>)(Function1 & Serializable)request -> Rx$.MODULE$.single((Function0 & Serializable)() -> Http$.MODULE$.response((HttpStatus)HttpStatus.NotFound_404$.MODULE$))));
        RxRunner$.MODULE$.run(rxResponse, (Function1 & Serializable)x0$1 -> {
            NetthRequestHandler.$anonfun$channelRead0$4(this, msg, ctx, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void writeResponse(HttpRequest req, ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        Object object = keepAlive ? (!req.protocolVersion().isKeepAliveDefault() ? resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE) : BoxedUnit.UNIT) : resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ChannelFuture f = ctx.write((Object)resp);
        if (!keepAlive) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
    }

    private DefaultHttpResponse toNettyResponse(HttpMessage.Response response) {
        DefaultHttpResponse defaultHttpResponse;
        if (response.message().isEmpty()) {
            defaultHttpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()));
        } else {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])response.message().toContentBytes());
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()), buf);
            HttpUtil.setContentLength((HttpMessage)res, (long)buf.readableBytes());
            defaultHttpResponse = res;
        }
        DefaultHttpResponse r = defaultHttpResponse;
        HttpHeaders h = r.headers();
        response.header().entries().foreach((Function1 & Serializable)e -> h.set(e.key(), (Object)e.value()));
        return r;
    }

    public static final /* synthetic */ void $anonfun$channelRead0$4(NetthRequestHandler $this, FullHttpRequest msg$1, ChannelHandlerContext ctx$1, RxEvent x0$1) {
        RxEvent rxEvent = x0$1;
        if (rxEvent instanceof OnNext) {
            OnNext onNext = (OnNext)rxEvent;
            Object v = onNext.v();
            DefaultHttpResponse nettyResponse = $this.toNettyResponse((HttpMessage.Response)v);
            $this.writeResponse((HttpRequest)msg$1, ctx$1, nettyResponse);
            return;
        }
        if (rxEvent instanceof OnError) {
            BoxedUnit boxedUnit;
            OnError onError = (OnError)rxEvent;
            Throwable ex = onError.e();
            if ($this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                $this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "NetthRequestHandler.scala", 81, 13), (Object)ex);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)HttpStatus.InternalServerError_500$.MODULE$.code()));
            $this.writeResponse((HttpRequest)msg$1, ctx$1, resp);
            return;
        }
        if (OnCompletion$.MODULE$.equals(rxEvent)) {
            return;
        }
        throw new MatchError((Object)rxEvent);
    }

    public NetthRequestHandler(NettyServerConfig config, HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher) {
        this.dispatcher = dispatcher;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

