/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import wvlet.airframe.Session;
import wvlet.airframe.codec.MessageCodecFactory$;
import wvlet.airframe.control.ThreadUtil$;
import wvlet.airframe.http.HttpBackend;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.netty.NetthRequestHandler;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyResponseHandler;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.http.router.HttpRequestDispatcher$;
import wvlet.airframe.http.router.ResponseHandler;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0005Y4Aa\u0004\t\u00013!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011\u0015)\u0004\u0001\"\u00017\u0011\u001dQ\u0004A1A\u0005\nmBa!\u0012\u0001!\u0002\u0013a\u0004b\u0002$\u0001\u0005\u0004%Ia\u000f\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f!\u0003\u0001\u0019!C\u0005\u0013\"91\u000b\u0001a\u0001\n\u0013!\u0006B\u0002.\u0001A\u0003&!\nC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r!\u0004\u0001\u0015!\u0003^\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015!\b\u0001\"\u0011v\u0005-qU\r\u001e;z'\u0016\u0014h/\u001a:\u000b\u0005E\u0011\u0012!\u00028fiRL(BA\n\u0015\u0003\u0011AG\u000f\u001e9\u000b\u0005U1\u0012\u0001C1je\u001a\u0014\u0018-\\3\u000b\u0003]\tQa\u001e<mKR\u001c\u0001a\u0005\u0003\u00015\t*\u0003CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005m\u0019\u0013B\u0001\u0013\u001d\u00055\tU\u000f^8DY>\u001cX-\u00192mKB\u0011a%K\u0007\u0002O)\u0011\u0001FF\u0001\u0004Y><\u0017B\u0001\u0016(\u0005)aunZ*vaB|'\u000f^\u0001\u0007G>tg-[4\u0011\u00055rS\"\u0001\t\n\u0005=\u0002\"!\u0005(fiRL8+\u001a:wKJ\u001cuN\u001c4jO\u000691/Z:tS>t\u0007C\u0001\u001a4\u001b\u0005!\u0012B\u0001\u001b\u0015\u0005\u001d\u0019Vm]:j_:\fa\u0001P5oSRtDcA\u001c9sA\u0011Q\u0006\u0001\u0005\u0006W\r\u0001\r\u0001\f\u0005\u0006a\r\u0001\r!M\u0001\nE>\u001c8o\u0012:pkB,\u0012\u0001\u0010\t\u0003{\rk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bqa\u00195b]:,GN\u0003\u0002\u0012\u0003*\t!)\u0001\u0002j_&\u0011AI\u0010\u0002\u001a\u001bVdG/\u001b;ie\u0016\fG-\u0012<f]Rdun\u001c9He>,\b/\u0001\u0006c_N\u001cxI]8va\u0002\n1b^8sW\u0016\u0014xI]8va\u0006aqo\u001c:lKJ<%o\\;qA\u0005i1\r[1o]\u0016dg)\u001e;ve\u0016,\u0012A\u0013\t\u0004\u0017:\u0003V\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\r=\u0003H/[8o!\ti\u0014+\u0003\u0002S}\t91\t[1o]\u0016d\u0017!E2iC:tW\r\u001c$viV\u0014Xm\u0018\u0013fcR\u0011Q\u000b\u0017\t\u0003\u0017ZK!a\u0016'\u0003\tUs\u0017\u000e\u001e\u0005\b3&\t\t\u00111\u0001K\u0003\rAH%M\u0001\u000fG\"\fgN\\3m\rV$XO]3!\u00031awnY1m\u0003\u0012$'/Z:t+\u0005i\u0006C\u00010f\u001d\ty6\r\u0005\u0002a\u00196\t\u0011M\u0003\u0002c1\u00051AH]8pizJ!\u0001\u001a'\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003I2\u000bQ\u0002\\8dC2\fE\r\u001a:fgN\u0004\u0013!B:uCJ$X#A+)\u00055a\u0007CA7s\u001b\u0005q'BA8q\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002c\u0006)!.\u0019<bq&\u00111O\u001c\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\u0002\u000b\rdwn]3\u0015\u0003U\u0003")
public class NettyServer
implements AutoCloseable,
LogSupport {
    public final NettyServerConfig wvlet$airframe$http$netty$NettyServer$$config;
    public final Session wvlet$airframe$http$netty$NettyServer$$session;
    private final MultithreadEventLoopGroup bossGroup;
    private final MultithreadEventLoopGroup workerGroup;
    private Option<Channel> channelFuture;
    private final String localAddress;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private MultithreadEventLoopGroup bossGroup() {
        return this.bossGroup;
    }

    private MultithreadEventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    private Option<Channel> channelFuture() {
        return this.channelFuture;
    }

    private void channelFuture_$eq(Option<Channel> x$1) {
        this.channelFuture = x$1;
    }

    public String localAddress() {
        return this.localAddress;
    }

    @PostConstruct
    public void start() {
        AbstractBootstrap abstractBootstrap;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("", "NettyServer.scala", 98, 9), (Object)new StringBuilder(19).append("Starting server at ").append(this.localAddress()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)this.bossGroup(), (EventLoopGroup)this.workerGroup());
        if (this.wvlet$airframe$http$netty$NettyServer$$config.useEpoll() && Epoll.isAvailable()) {
            b.channel(EpollServerSocketChannel.class);
            abstractBootstrap = b.option(UnixChannelOption.SO_REUSEPORT, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            abstractBootstrap = b.channel(NioServerSocketChannel.class);
        }
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)BoxesRunTime.boxToInteger((int)((int)TimeUnit.SECONDS.toMillis(1L))));
        b.option(ChannelOption.SO_REUSEADDR, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.option(ChannelOption.SO_BACKLOG, (Object)BoxesRunTime.boxToInteger((int)1024));
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.TCP_NODELAY, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)WriteBufferWaterMark.DEFAULT);
        PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;
        b.option(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){
            private final HttpFilter<HttpMessage.Request, HttpMessage.Response, ?> dispatcher;
            private final /* synthetic */ NettyServer $outer;

            private HttpFilter<HttpMessage.Request, HttpMessage.Response, ?> dispatcher() {
                return this.dispatcher;
            }

            public void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
                pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new NetthRequestHandler(this.$outer.wvlet$airframe$http$netty$NettyServer$$config, this.dispatcher())});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dispatcher = HttpRequestDispatcher$.MODULE$.newDispatcher($outer.wvlet$airframe$http$netty$NettyServer$$session, $outer.wvlet$airframe$http$netty$NettyServer$$config.router(), $outer.wvlet$airframe$http$netty$NettyServer$$config.controllerProvider(), (HttpBackend)NettyBackend$.MODULE$, (ResponseHandler)new NettyResponseHandler(), MessageCodecFactory$.MODULE$.defaultFactoryForJSON(), (HttpRequestAdapter)HttpMessage.HttpMessageRequestAdapter$.MODULE$);
            }
        });
        this.channelFuture_$eq((Option<Channel>)new Some((Object)b.bind(this.wvlet$airframe$http$netty$NettyServer$$config.port()).sync().channel()));
    }

    @Override
    public void close() {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("", "NettyServer.scala", 170, 9), (Object)new StringBuilder(18).append("Closing server at ").append(this.localAddress()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.workerGroup().shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.bossGroup().shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.channelFuture().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NettyServer.$anonfun$close$1(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$close$1(Channel x$1) {
        return x$1.close().await(1L, TimeUnit.SECONDS);
    }

    public NettyServer(NettyServerConfig config, Session session) {
        this.wvlet$airframe$http$netty$NettyServer$$config = config;
        this.wvlet$airframe$http$netty$NettyServer$$session = session;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        ThreadFactory tf = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-boss");
        this.bossGroup = config.canUseEpoll() ? new EpollEventLoopGroup(1, tf) : new NioEventLoopGroup(1, tf);
        ThreadFactory tf2 = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-worker");
        int numWorkers = package$.MODULE$.max(4, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() / (double)3)));
        this.workerGroup = config.canUseEpoll() ? new EpollEventLoopGroup(numWorkers, tf2) : new NioEventLoopGroup(numWorkers, tf2);
        this.channelFuture = None$.MODULE$;
        this.localAddress = new StringBuilder(10).append("localhost:").append(config.port()).toString();
    }
}

