/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import wvlet.airframe.codec.JSONCodec$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageCodecFactory;
import wvlet.airframe.codec.MessageCodecFactory$;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.ServerSentEvent;
import wvlet.airframe.http.router.ResponseHandler;
import wvlet.airframe.http.router.Route;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.surface.Primitive;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;

public class NettyResponseHandler
implements ResponseHandler<HttpMessage.Request, HttpMessage.Response>,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NettyResponseHandler.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private MessageCodecFactory codecFactory() {
        return MessageCodecFactory$.MODULE$.defaultFactoryForJSON();
    }

    public <A> HttpMessage.Response toHttpResponse(Route route, HttpMessage.Request request, Surface responseSurface, A a) {
        MessageCodec rs;
        MessageCodec messageCodec;
        A a2;
        block18: {
            block16: {
                A a3;
                BoxedUnit boxedUnit;
                block17: {
                    a2 = a;
                    if (a2 == null) break block16;
                    boxedUnit = BoxedUnit.UNIT;
                    a3 = a2;
                    if (boxedUnit != null) break block17;
                    if (a3 == null) break block16;
                    break block18;
                }
                if (!boxedUnit.equals(a3)) break block18;
            }
            return this.newResponse(route, request, responseSurface);
        }
        if (a2 instanceof HttpMessage.Response) {
            HttpMessage.Response r = (HttpMessage.Response)a2;
            return r;
        }
        if (a2 instanceof byte[]) {
            byte[] b = (byte[])a2;
            if (request.acceptsMsgPack()) {
                return (HttpMessage.Response)((HttpMessage)this.newResponse(route, request, responseSurface).withContentTypeMsgPack()).withContent(b);
            }
        }
        if (a2 instanceof String) {
            String s = (String)a2;
            if (!request.acceptsMsgPack()) {
                return (HttpMessage.Response)this.newResponse(route, request, responseSurface).withContent(s);
            }
        }
        if (a2 instanceof Rx) {
            Rx r = (Rx)a2;
            Class clazz = ((Surface)responseSurface.typeArgs().apply(0)).rawType();
            Class<ServerSentEvent> clazz2 = ServerSentEvent.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                HttpMessage.Response resp = (HttpMessage.Response)this.newResponse(route, request, responseSurface).withContentType("text/event-stream");
                resp.events_$eq(r);
                return resp;
            }
        }
        if (!((messageCodec = (rs = this.codecFactory().of(responseSurface))) instanceof MessageCodec)) {
            if (messageCodec == null) {
                throw new IllegalArgumentException(new StringBuilder(15).append("Unknown codec: ").append(rs).toString());
            }
            throw new MatchError((Object)messageCodec);
        }
        MessageCodec m = messageCodec;
        byte[] msgpack = m.toMsgPack(a);
        if (request.acceptsMsgPack()) {
            return (HttpMessage.Response)((HttpMessage)this.newResponse(route, request, responseSurface).withContentTypeMsgPack()).withContent(msgpack);
        }
        if (msgpack.length == 0) {
            return this.newResponse(route, request, responseSurface);
        }
        Option json = JSONCodec$.MODULE$.unpackMsgPack(msgpack);
        Option option = json;
        if (option instanceof Some) {
            String j = (String)((Some)option).value();
            return (HttpMessage.Response)this.newResponse(route, request, responseSurface).withJson((String)json.get());
        }
        if (None$.MODULE$.equals(option)) {
            return Http$.MODULE$.response((HttpStatus)HttpStatus.InternalServerError_500$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpMessage.Response newResponse(Route route, HttpMessage.Request request, Surface responseSurface) {
        Surface surface = responseSurface;
        Primitive.Unit$ unit$ = Primitive.Unit$.MODULE$;
        if (surface != null ? !surface.equals(unit$) : unit$ != null) return Http$.MODULE$.response((HttpStatus)HttpStatus.Ok_200$.MODULE$);
        String string = request.method();
        if ("POST".equals(string) && route.isRPC()) {
            return Http$.MODULE$.response((HttpStatus)HttpStatus.Ok_200$.MODULE$);
        }
        switch (string == null ? 0 : string.hashCode()) {
            case 79599: {
                if ("PUT".equals(string)) return Http$.MODULE$.response((HttpStatus)HttpStatus.Created_201$.MODULE$);
                return Http$.MODULE$.response((HttpStatus)HttpStatus.Ok_200$.MODULE$);
            }
            case 2461856: {
                if ("POST".equals(string)) return Http$.MODULE$.response((HttpStatus)HttpStatus.Created_201$.MODULE$);
                return Http$.MODULE$.response((HttpStatus)HttpStatus.Ok_200$.MODULE$);
            }
            case 2012838315: {
                if (!"DELETE".equals(string)) return Http$.MODULE$.response((HttpStatus)HttpStatus.Ok_200$.MODULE$);
                return Http$.MODULE$.response((HttpStatus)HttpStatus.NoContent_204$.MODULE$);
            }
        }
        return Http$.MODULE$.response((HttpStatus)HttpStatus.Ok_200$.MODULE$);
    }
}

