/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichDouble$;
import wvlet.airframe.Session;
import wvlet.airframe.codec.MessageCodecFactory$;
import wvlet.airframe.control.ThreadUtil$;
import wvlet.airframe.http.HttpBackend;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.netty.NetthRequestHandler;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyResponseHandler;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.http.router.HttpRequestDispatcher$;
import wvlet.airframe.http.router.ResponseHandler;
import wvlet.airframe.rx.Rx;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NettyServer
implements AutoCloseable,
LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NettyServer.class.getDeclaredField("0bitmap$2"));
    public Logger logger$lzy1;
    public long 0bitmap$2;
    public final NettyServerConfig wvlet$airframe$http$netty$NettyServer$$config;
    public final Session wvlet$airframe$http$netty$NettyServer$$session;
    private final MultithreadEventLoopGroup bossGroup;
    private final MultithreadEventLoopGroup workerGroup;
    private Option<Channel> channelFuture;
    private final String localAddress;

    public NettyServer(NettyServerConfig config, Session session) {
        this.wvlet$airframe$http$netty$NettyServer$$config = config;
        this.wvlet$airframe$http$netty$NettyServer$$session = session;
        ThreadFactory tf = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-boss");
        this.bossGroup = config.canUseEpoll() ? new EpollEventLoopGroup(1, tf) : new NioEventLoopGroup(1, tf);
        ThreadFactory tf2 = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-worker");
        int numWorkers = package$.MODULE$.max(4, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() / (double)3)));
        this.workerGroup = config.canUseEpoll() ? new EpollEventLoopGroup(numWorkers, tf2) : new NioEventLoopGroup(numWorkers, tf2);
        this.channelFuture = None$.MODULE$;
        this.localAddress = new StringBuilder(10).append("localhost:").append(config.port()).toString();
    }

    public Logger logger() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    Logger logger;
                    this.logger$lzy1 = logger = LazyLogger.logger$((LazyLogger)this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return logger;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.logger$lzy1;
    }

    public String localAddress() {
        return this.localAddress;
    }

    @PostConstruct
    public void start() {
        ServerBootstrap serverBootstrap;
        NettyServer LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "NettyServer.scala", 98, 47), (Object)new StringBuilder(19).append("Starting server at ").append(this.localAddress()).toString());
        }
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup);
        if (this.wvlet$airframe$http$netty$NettyServer$$config.useEpoll() && Epoll.isAvailable()) {
            b.channel(EpollServerSocketChannel.class);
            serverBootstrap = (ServerBootstrap)b.option(UnixChannelOption.SO_REUSEPORT, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            serverBootstrap = (ServerBootstrap)b.channel(NioServerSocketChannel.class);
        }
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)BoxesRunTime.boxToInteger((int)((int)TimeUnit.SECONDS.toMillis(1L))));
        b.option(ChannelOption.SO_REUSEADDR, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.option(ChannelOption.SO_BACKLOG, (Object)BoxesRunTime.boxToInteger((int)1024));
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.TCP_NODELAY, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)WriteBufferWaterMark.DEFAULT);
        PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;
        b.option(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){
            private final HttpFilter dispatcher;
            private final /* synthetic */ NettyServer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dispatcher = HttpRequestDispatcher$.MODULE$.newDispatcher($outer.wvlet$airframe$http$netty$NettyServer$$session, $outer.wvlet$airframe$http$netty$NettyServer$$config.router(), $outer.wvlet$airframe$http$netty$NettyServer$$config.controllerProvider(), (HttpBackend)NettyBackend$.MODULE$, (ResponseHandler)new NettyResponseHandler(), MessageCodecFactory$.MODULE$.defaultFactoryForJSON(), (HttpRequestAdapter)HttpMessage.HttpMessageRequestAdapter$.MODULE$);
            }

            public void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
                pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new NetthRequestHandler(this.$outer.wvlet$airframe$http$netty$NettyServer$$config, (HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx>)this.dispatcher)});
            }
        });
        this.channelFuture = Some$.MODULE$.apply((Object)b.bind(this.wvlet$airframe$http$netty$NettyServer$$config.port()).sync().channel());
    }

    @Override
    public void close() {
        NettyServer LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "NettyServer.scala", 170, 46), (Object)new StringBuilder(18).append("Closing server at ").append(this.localAddress()).toString());
        }
        this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.channelFuture.foreach((Function1 & Serializable)_$1 -> _$1.close().await(1L, TimeUnit.SECONDS));
    }
}

