/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichDouble$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import wvlet.airframe.Session;
import wvlet.airframe.codec.MessageCodecFactory$;
import wvlet.airframe.control.ThreadUtil$;
import wvlet.airframe.http.Compat$;
import wvlet.airframe.http.HttpBackend;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.RPCContext;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.RxHttpFilter;
import wvlet.airframe.http.internal.RPCResponseFilter$;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyRPCContext;
import wvlet.airframe.http.netty.NettyRequestHandler;
import wvlet.airframe.http.netty.NettyResponseHandler;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.http.router.HttpRequestDispatcher$;
import wvlet.airframe.http.router.ResponseHandler;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.rx.RxOps;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class NettyServer
implements AutoCloseable,
LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NettyServer.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    public final NettyServerConfig wvlet$airframe$http$netty$NettyServer$$config;
    public final Session wvlet$airframe$http$netty$NettyServer$$session;
    private final HttpLogger httpLogger;
    public final RxHttpFilter wvlet$airframe$http$netty$NettyServer$$loggingFilter;
    private final MultithreadEventLoopGroup bossGroup;
    private final MultithreadEventLoopGroup workerGroup;
    private Option<Channel> channelFuture;
    private final String localAddress;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;

    public NettyServer(NettyServerConfig config, Session session) {
        this.wvlet$airframe$http$netty$NettyServer$$config = config;
        this.wvlet$airframe$http$netty$NettyServer$$session = session;
        this.httpLogger = config.newHttpLogger();
        this.wvlet$airframe$http$netty$NettyServer$$loggingFilter = (RxHttpFilter)config.loggingFilter().apply((Object)this.httpLogger);
        ThreadFactory tf = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-boss");
        this.bossGroup = config.canUseEpoll() ? new EpollEventLoopGroup(1, tf) : new NioEventLoopGroup(1, tf);
        ThreadFactory tf2 = ThreadUtil$.MODULE$.newDaemonThreadFactory("airframe-netty-worker");
        int numWorkers = package$.MODULE$.max(4, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() / (double)3)));
        this.workerGroup = config.canUseEpoll() ? new EpollEventLoopGroup(numWorkers, tf2) : new NioEventLoopGroup(numWorkers, tf2);
        this.channelFuture = None$.MODULE$;
        this.localAddress = new StringBuilder(10).append("localhost:").append(config.port()).toString();
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String localAddress() {
        return this.localAddress;
    }

    public RxHttpFilter wvlet$airframe$http$netty$NettyServer$$attachContextFilter() {
        return new RxHttpFilter(){

            public Rx apply(HttpMessage.Request request, RxHttpEndpoint next) {
                NettyRPCContext context = new NettyRPCContext(request);
                Compat$.MODULE$.attachRPCContext((RPCContext)context);
                return next.apply(request).toRx().transformRx(arg_0 -> NettyServer.wvlet$airframe$http$netty$NettyServer$$anon$1$$_$apply$$anonfun$1(context, arg_0));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{wvlet$airframe$http$netty$NettyServer$$anon$1$$_$apply$$anonfun$1(wvlet.airframe.http.netty.NettyRPCContext scala.util.Try )}, serializedLambda);
            }
        };
    }

    @PostConstruct
    public void start() {
        if (this.stopped.get()) {
            throw new IllegalStateException(new StringBuilder(25).append("Server ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" is already closed").toString());
        }
        if (this.started.compareAndSet(false, true)) {
            this.startInternal();
            return;
        }
    }

    private void startInternal() {
        ServerBootstrap serverBootstrap;
        NettyServer LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "NettyServer.scala", 172, 62), (Object)new StringBuilder(20).append("Starting ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" server at ").append(this.localAddress()).toString());
        }
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup);
        if (this.wvlet$airframe$http$netty$NettyServer$$config.useEpoll() && Epoll.isAvailable()) {
            b.channel(EpollServerSocketChannel.class);
            serverBootstrap = (ServerBootstrap)b.option(UnixChannelOption.SO_REUSEPORT, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            serverBootstrap = (ServerBootstrap)b.channel(NioServerSocketChannel.class);
        }
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)BoxesRunTime.boxToInteger((int)((int)TimeUnit.SECONDS.toMillis(1L))));
        b.option(ChannelOption.SO_REUSEADDR, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.option(ChannelOption.SO_BACKLOG, (Object)BoxesRunTime.boxToInteger((int)1024));
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.TCP_NODELAY, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)WriteBufferWaterMark.DEFAULT);
        PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;
        b.option(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(this){
            private final HttpFilter dispatcher;
            private final /* synthetic */ NettyServer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dispatcher = NettyBackend$.MODULE$.rxFilterAdapter($outer.wvlet$airframe$http$netty$NettyServer$$attachContextFilter().andThen($outer.wvlet$airframe$http$netty$NettyServer$$loggingFilter).andThen((RxHttpFilter)RPCResponseFilter$.MODULE$)).andThen(HttpRequestDispatcher$.MODULE$.newDispatcher($outer.wvlet$airframe$http$netty$NettyServer$$session, $outer.wvlet$airframe$http$netty$NettyServer$$config.router(), $outer.wvlet$airframe$http$netty$NettyServer$$config.controllerProvider(), (HttpBackend)NettyBackend$.MODULE$, (ResponseHandler)new NettyResponseHandler(), MessageCodecFactory$.MODULE$.defaultFactoryForJSON(), (HttpRequestAdapter)HttpMessage.HttpMessageRequestAdapter$.MODULE$));
            }

            public void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
                pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new NettyRequestHandler(this.$outer.wvlet$airframe$http$netty$NettyServer$$config, (HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx>)this.dispatcher)});
            }
        });
        this.channelFuture = Some$.MODULE$.apply((Object)b.bind(this.wvlet$airframe$http$netty$NettyServer$$config.port()).sync().channel());
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            NettyServer LoggingMethods_this = this;
            if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.INFO$.MODULE$, LogSource$.MODULE$.apply("", "NettyServer.scala", 253, 64), (Object)new StringBuilder(20).append("Stopping ").append(this.wvlet$airframe$http$netty$NettyServer$$config.name()).append(" server at ").append(this.localAddress()).toString());
            }
            this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this.httpLogger.close();
            this.channelFuture.foreach((Function1 & Serializable)_$4 -> _$4.close().await(1L, TimeUnit.SECONDS));
            return;
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    public void awaitTermination() {
        this.channelFuture.foreach((Function1 & Serializable)_$5 -> _$5.closeFuture().sync());
    }

    private static final HttpMessage.Response apply$$anonfun$1$$anonfun$1(HttpMessage.Response v$1) {
        return v$1;
    }

    public static final /* synthetic */ RxOps wvlet$airframe$http$netty$NettyServer$$anon$1$$_$apply$$anonfun$1(NettyRPCContext context$1, Try v) {
        Compat$.MODULE$.detachRPCContext((RPCContext)context$1);
        Try try_ = v;
        if (try_ instanceof Success) {
            HttpMessage.Response v2 = (HttpMessage.Response)((Success)try_).value();
            return Rx$.MODULE$.single(() -> NettyServer.apply$$anonfun$1$$anonfun$1(v2));
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return Rx$.MODULE$.exception(e);
        }
        throw new MatchError((Object)try_);
    }
}

