/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.HttpStatus$;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.ServerAddress$;
import wvlet.airframe.http.netty.NettyBackend$;
import wvlet.airframe.http.netty.NettyRequestHandler$;
import wvlet.airframe.http.netty.NettyServerConfig;
import wvlet.airframe.rx.OnCompletion$;
import wvlet.airframe.rx.OnError;
import wvlet.airframe.rx.OnError$;
import wvlet.airframe.rx.OnNext;
import wvlet.airframe.rx.OnNext$;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.rx.RxEvent;
import wvlet.airframe.rx.RxOps;
import wvlet.airframe.rx.RxRunner$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;

public class NettyRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NettyRequestHandler.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher;

    public static DefaultFullHttpResponse toNettyResponse(HttpMessage.Response response) {
        return NettyRequestHandler$.MODULE$.toNettyResponse(response);
    }

    public NettyRequestHandler(NettyServerConfig config, HttpFilter<HttpMessage.Request, HttpMessage.Response, Rx> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        NettyRequestHandler LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.WARN$.MODULE$, LogSource$.MODULE$.apply("", "NettyRequestHandler.scala", 45, 15), (Object)cause);
        }
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        HttpMessage.Request request2;
        String string = msg.method().name().toUpperCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -531492226: {
                if (!"OPTIONS".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.request("OPTIONS", msg.uri());
                break;
            }
            case 70454: {
                if (!"GET".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.GET(msg.uri());
                break;
            }
            case 79599: {
                if (!"PUT".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.PUT(msg.uri());
                break;
            }
            case 2213344: {
                if (!"HEAD".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.request("HEAD", msg.uri());
                break;
            }
            case 2461856: {
                if (!"POST".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.POST(msg.uri());
                break;
            }
            case 75900968: {
                if (!"PATCH".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.PATCH(msg.uri());
                break;
            }
            case 80083237: {
                if (!"TRACE".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.request("TRACE", msg.uri());
                break;
            }
            case 2012838315: {
                if (!"DELETE".equals(string)) throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
                request2 = Http$.MODULE$.DELETE(msg.uri());
                break;
            }
            default: {
                throw RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException(new StringBuilder(25).append("Unsupported HTTP method: ").append(msg.method()).toString(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$2(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$3(), RPCStatus.INVALID_REQUEST_U1$.MODULE$.newException$default$4());
            }
        }
        try {
            try {
                ObjectRef req = ObjectRef.create((Object)request2);
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress x2 = (InetSocketAddress)socketAddress;
                    req.elem = ((HttpMessage.Request)req.elem).withRemoteAddress(ServerAddress$.MODULE$.apply(new StringBuilder(1).append(x2.getHostString()).append(":").append(x2.getPort()).toString()));
                }
                CollectionConverters$.MODULE$.SetHasAsScala(msg.headers().names()).asScala().map((Function1)(JProcedure1 & Serializable)x -> {
                    req$1.elem = (HttpMessage.Request)((HttpMessage.Request)req$1.elem).withHeader(x, msg.headers().get(x));
                });
                ByteArrayOutputStream bodyBuf = null;
                ByteBuf requestBody = msg.content();
                while (requestBody.isReadable()) {
                    int size = requestBody.readableBytes();
                    if (bodyBuf == null) {
                        bodyBuf = new ByteArrayOutputStream(size);
                    }
                    requestBody.readBytes((OutputStream)bodyBuf, size);
                }
                if (bodyBuf != null && bodyBuf.size() > 0) {
                    req.elem = (HttpMessage.Request)((HttpMessage.Request)req.elem).withContent(bodyBuf.toByteArray());
                }
                Rx rxResponse = (Rx)this.dispatcher.apply((Object)((HttpMessage.Request)req.elem), NettyBackend$.MODULE$.newContext((Function1 & Serializable)request -> Rx$.MODULE$.single(NettyRequestHandler::$anonfun$1$$anonfun$1)));
                RxRunner$.MODULE$.run((RxOps)rxResponse, (Function1)(JProcedure1 & Serializable)x$1 -> {
                    RxEvent rxEvent = x$1;
                    if (rxEvent instanceof OnNext) {
                        Object object;
                        OnNext onNext = OnNext$.MODULE$.unapply((OnNext)rxEvent);
                        Object v = object = onNext._1();
                        DefaultFullHttpResponse nettyResponse = NettyRequestHandler$.MODULE$.toNettyResponse((HttpMessage.Response)v);
                        this.writeResponse((HttpRequest)msg, ctx, (DefaultHttpResponse)nettyResponse);
                        return;
                    }
                    if (rxEvent instanceof OnError) {
                        Throwable throwable;
                        OnError onError = OnError$.MODULE$.unapply((OnError)rxEvent);
                        Throwable ex = throwable = onError._1();
                        HttpMessage.Response resp = RPCStatus.INTERNAL_ERROR_I0$.MODULE$.newException(ex.getMessage(), ex, RPCStatus.INTERNAL_ERROR_I0$.MODULE$.newException$default$3(), RPCStatus.INTERNAL_ERROR_I0$.MODULE$.newException$default$4()).toResponse();
                        DefaultFullHttpResponse nettyResponse = NettyRequestHandler$.MODULE$.toNettyResponse(resp);
                        this.writeResponse((HttpRequest)msg, ctx, (DefaultHttpResponse)nettyResponse);
                        return;
                    }
                    if (OnCompletion$.MODULE$.equals(rxEvent)) {
                        return;
                    }
                    throw new MatchError((Object)rxEvent);
                });
                return;
            }
            catch (RPCException e) {
                this.writeResponse((HttpRequest)msg, ctx, (DefaultHttpResponse)NettyRequestHandler$.MODULE$.toNettyResponse(e.toResponse()));
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            NettyBackend$.MODULE$.clearThreadLocal();
        }
    }

    private void writeResponse(HttpRequest req, ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        BoxedUnit boxedUnit;
        boolean keepAlive;
        boolean bl = keepAlive = HttpStatus$.MODULE$.ofCode(resp.status().code()).isSuccessful() && HttpUtil.isKeepAlive((HttpMessage)req);
        if (keepAlive) {
            if (!req.protocolVersion().isKeepAliveDefault()) {
                resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
        ChannelFuture f = ctx.write((Object)resp);
        if (!keepAlive) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
    }

    private static final HttpMessage.Response $anonfun$1$$anonfun$1() {
        return Http$.MODULE$.response((HttpStatus)HttpStatus.NotFound_404$.MODULE$);
    }
}

