/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package wvlet.airframe.http

import wvlet.airframe.codec.{JSONCodec, MessageCodec, MessageHolder}
import wvlet.airframe.msgpack.spi.{Packer, Unpacker}

/**
  *
  */
class HttpResponseCodec[Resp: HttpResponseAdapter] extends MessageCodec[HttpResponse[_]] {
  override def pack(p: Packer, v: HttpResponse[_]): Unit = {
    v.contentType match {
      case Some("application/x-msgpack") =>
        val b = v.contentBytes
        p.packArrayHeader(b.length)
        p.writePayload(b)
      case Some(x) if x.startsWith("application/json") =>
        // JSON -> MsgPack
        JSONCodec.pack(p, v.contentString)
      case _ =>
        val content = v.contentString
        if (content.startsWith("{") || content.startsWith("[")) {
          // JSON -> MsgPack
          JSONCodec.pack(p, v.contentString)
        } else {
          p.packString(content)
        }
    }
  }
  override def unpack(u: Unpacker, v: MessageHolder): Unit = ???
}
