/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import wvlet.airframe.control.ResultClass;
import wvlet.airframe.control.ResultClass$;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.HttpStatus$BadRequest_400$;
import wvlet.airframe.http.HttpStatus$ClientClosedRequest_499$;
import wvlet.airframe.http.HttpStatus$Gone_410$;
import wvlet.airframe.http.HttpStatus$TooManyRequests_429$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClientException$
implements LogSupport {
    public static HttpClientException$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HttpClientException$();
    }

    private Logger logger$lzycompute() {
        HttpClientException$ httpClientException$ = this;
        synchronized (httpClientException$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private <Resp> HttpClientException requestFailure(Resp response, HttpResponseAdapter<Resp> adapter) {
        HttpStatus status = adapter.statusOf(response);
        String content = adapter.contentStringOf(response);
        return content == null || content.isEmpty() ? new HttpClientException(adapter.httpResponseOf(response), status) : new HttpClientException(adapter.httpResponseOf(response), status, new StringBuilder(16).append("Request failed: ").append(content).toString());
    }

    public <Resp> ResultClass classifyHttpResponse(Resp response, HttpResponseAdapter<Resp> adapter) {
        ResultClass.Succeeded$ succeeded$;
        HttpStatus status = adapter.statusOf(response);
        HttpStatus httpStatus = status;
        if (httpStatus.isSuccessful()) {
            succeeded$ = ResultClass.Succeeded$.MODULE$;
        } else if (httpStatus.isServerError()) {
            succeeded$ = ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
        } else if (httpStatus.isClientError()) {
            HttpStatus httpStatus2 = httpStatus;
            ResultClass.Failed failed = HttpStatus$BadRequest_400$.MODULE$.equals(httpStatus2) && this.isRetryable400ErrorMessage(adapter.contentStringOf(response)) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : (HttpStatus$Gone_410$.MODULE$.equals(httpStatus2) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : (HttpStatus$TooManyRequests_429$.MODULE$.equals(httpStatus2) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : (HttpStatus$ClientClosedRequest_499$.MODULE$.equals(httpStatus2) ? ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter)) : ResultClass$.MODULE$.nonRetryableFailure((Throwable)this.requestFailure(response, adapter)))));
            succeeded$ = failed;
        } else {
            succeeded$ = ResultClass$.MODULE$.nonRetryableFailure((Throwable)this.requestFailure(response, adapter));
        }
        return succeeded$;
    }

    private boolean isRetryable400ErrorMessage(String m) {
        Seq retriable400ErrorMessage = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Regex[]{new StringOps(Predef$.MODULE$.augmentString("Idle connections will be closed")).r()}));
        return retriable400ErrorMessage.find((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)HttpClientException$.$anonfun$isRetryable400ErrorMessage$1(m, pattern))).isDefined();
    }

    public ResultClass.Failed classifyHttpClientException(Throwable e) {
        return (ResultClass.Failed)this.ioExceptionClassifier().orElse(this.executionFailureClassifier()).applyOrElse((Object)e, this.nonRetryable());
    }

    public PartialFunction<Throwable, ResultClass.Failed> ioExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IOException) {
                    IOException iOException = (IOException)A1;
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(iOException);
                } else if (A1 instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)A1;
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(invocationTargetException);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IOException ? true : throwable instanceof InvocationTargetException;
                return bl;
            }
        };
    }

    public ResultClass.Failed classifyExecutionFailure(Throwable ex) {
        return (ResultClass.Failed)this.executionFailureClassifier().applyOrElse((Object)ex, this.nonRetryable());
    }

    public PartialFunction<Throwable, ResultClass.Failed> executionFailureClassifier() {
        return this.timeoutExceptionClassifier().orElse(this.connectionExceptionClassifier()).orElse(this.sslExceptionClassifier()).orElse(this.invocationTargetExceptionClassifier());
    }

    public PartialFunction<Throwable, ResultClass.Failed> timeoutExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)A1;
                    object = ResultClass$.MODULE$.retryableFailure((Throwable)timeoutException);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof TimeoutException;
                return bl;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> connectionExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A1;
                    object = ResultClass$.MODULE$.retryableFailure((Throwable)interruptedException);
                } else if (A1 instanceof ProtocolException) {
                    ProtocolException protocolException = (ProtocolException)A1;
                    object = ResultClass$.MODULE$.retryableFailure((Throwable)protocolException);
                } else if (A1 instanceof ConnectException) {
                    ConnectException connectException = (ConnectException)A1;
                    object = ResultClass$.MODULE$.retryableFailure((Throwable)connectException);
                } else if (A1 instanceof EOFException) {
                    EOFException eOFException = (EOFException)A1;
                    object = ResultClass$.MODULE$.retryableFailure((Throwable)eOFException);
                } else if (A1 instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)A1;
                    object = ResultClass$.MODULE$.retryableFailure((Throwable)timeoutException);
                } else if (A1 instanceof SocketException) {
                    SocketException socketException = (SocketException)A1;
                    SocketException socketException2 = socketException;
                    ResultClass.Failed failed = socketException2 instanceof BindException ? ResultClass$.MODULE$.retryableFailure((Throwable)socketException) : (socketException2 instanceof ConnectException ? ResultClass$.MODULE$.retryableFailure((Throwable)socketException) : (socketException2 instanceof NoRouteToHostException ? ResultClass$.MODULE$.retryableFailure((Throwable)socketException) : (socketException2 instanceof PortUnreachableException ? ResultClass$.MODULE$.retryableFailure((Throwable)socketException) : ResultClass$.MODULE$.nonRetryableFailure((Throwable)socketException))));
                    object = failed;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof InterruptedException ? true : (throwable instanceof ProtocolException ? true : (throwable instanceof ConnectException ? true : (throwable instanceof EOFException ? true : (throwable instanceof TimeoutException ? true : throwable instanceof SocketException))));
                return bl;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> sslExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SSLException) {
                    SSLException sSLException = (SSLException)A1;
                    SSLException sSLException2 = sSLException;
                    ResultClass.Failed failed = sSLException2 instanceof SSLHandshakeException ? ResultClass$.MODULE$.nonRetryableFailure((Throwable)sSLException) : (sSLException2 instanceof SSLKeyException ? ResultClass$.MODULE$.nonRetryableFailure((Throwable)sSLException) : (sSLException2 instanceof SSLPeerUnverifiedException ? ResultClass$.MODULE$.nonRetryableFailure((Throwable)sSLException) : ResultClass$.MODULE$.retryableFailure((Throwable)sSLException)));
                    object = failed;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof SSLException;
                return bl;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> invocationTargetExceptionClassifier() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                ExecutionException executionException;
                A1 A1 = x1;
                if (A1 instanceof ExecutionException && (executionException = (ExecutionException)A1).getCause() != null) {
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(executionException.getCause());
                } else if (A1 instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)A1;
                    object = HttpClientException$.MODULE$.classifyExecutionFailure(invocationTargetException.getTargetException());
                } else {
                    object = A1.getCause() != null ? HttpClientException$.MODULE$.classifyExecutionFailure(A1.getCause()) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                ExecutionException executionException;
                Throwable throwable = x1;
                boolean bl = throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null ? true : (throwable instanceof InvocationTargetException ? true : throwable.getCause() != null);
                return bl;
            }
        };
    }

    public Function1<Throwable, ResultClass.Failed> nonRetryable() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            ResultClass.Failed failed = ResultClass$.MODULE$.nonRetryableFailure(throwable);
            return failed;
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$isRetryable400ErrorMessage$1(String m$1, Regex pattern) {
        return pattern.findFirstIn((CharSequence)m$1).isDefined();
    }

    private HttpClientException$() {
        MODULE$ = this;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

