/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageCodec$;
import wvlet.airframe.control.Retry;
import wvlet.airframe.control.Retry$;
import wvlet.airframe.http.HttpClientException$;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpMultiMap$;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.package$;
import wvlet.airframe.json.JSON;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClient$
implements LogSupport {
    public static HttpClient$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HttpClient$();
    }

    private Logger logger$lzycompute() {
        HttpClient$ httpClient$ = this;
        synchronized (httpClient$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public <Req, Resp> Retry.RetryContext defaultHttpClientRetry(HttpRequestAdapter<Req> evidence$62, ClassTag<Req> evidence$63, HttpResponseAdapter<Resp> evidence$64) {
        return Retry$.MODULE$.withBackOff(10, Retry$.MODULE$.withBackOff$default$2(), Retry$.MODULE$.withBackOff$default$3(), Retry$.MODULE$.withBackOff$default$4()).withResultClassifier((Function1 & Serializable & scala.Serializable)response -> HttpClientException$.MODULE$.classifyHttpResponse(response, evidence$64)).withErrorClassifier((Function1 & Serializable & scala.Serializable)ex -> HttpClientException$.MODULE$.classifyExecutionFailure((Throwable)ex)).beforeRetry((Function1 & Serializable & scala.Serializable)ctx -> MODULE$.defaultBeforeRetryAction((Retry.RetryContext)ctx, evidence$62, evidence$63));
    }

    public <Req> Object defaultBeforeRetryAction(Retry.RetryContext ctx, HttpRequestAdapter<Req> evidence$65, ClassTag<Req> evidence$66) {
        BoxedUnit boxedUnit;
        String string;
        Some some;
        Object r;
        Class cls = ((ClassTag)Predef$.MODULE$.implicitly(evidence$66)).runtimeClass();
        Option option = ctx.context();
        if (option instanceof Some && cls.isAssignableFrom((r = (some = (Some)option).value()).getClass())) {
            HttpRequestAdapter adapter = (HttpRequestAdapter)Predef$.MODULE$.implicitly(evidence$65);
            Object req = r;
            String path = adapter.pathOf(req);
            string = new java.lang.StringBuilder(23).append("Request to ").append(path).append(" is failed: ").append(ctx.lastError().getMessage()).toString();
        } else {
            string = new java.lang.StringBuilder(19).append("Request is failed: ").append(ctx.lastError().getMessage()).toString();
        }
        String errorMessage = string;
        int nextWaitMillis = ctx.nextWaitMillis();
        if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)ctx.retryCount());
            Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)ctx.maxRetry());
            String arg$macro$3 = errorMessage;
            double arg$macro$4 = (double)nextWaitMillis / 1000.0;
            this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-http/src/main/scala/wvlet/airframe/http/HttpClient.scala", "HttpClient.scala", 401, 9), (Object)new StringOps("[%s/%s] %s. Retry the request in %.3f sec.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public String urlEncode(String s) {
        return package$.MODULE$.compat().urlEncode(s);
    }

    public <Resource> String buildResourceUri(String path, Resource resource, Surface resourceSurface) {
        BoxedUnit boxedUnit;
        HttpMultiMap queryParams = this.flattenResourceToQueryParams(resource, resourceSurface);
        StringBuilder pathWithParams = new StringBuilder();
        pathWithParams.append(path);
        if (queryParams.nonEmpty()) {
            String queryParamString = ((TraversableOnce)queryParams.entries().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(1).append(x.key()).append("=").append(x.value()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("&");
            pathWithParams.append("?");
            boxedUnit = pathWithParams.append(queryParamString);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return pathWithParams.result();
    }

    public <Resource> HttpMultiMap flattenResourceToQueryParams(Resource resource, Surface resourceSurface) {
        MessageCodec resourceCodec = MessageCodec$.MODULE$.ofSurface(resourceSurface);
        JSON.JSONObject resourceJson = (JSON.JSONObject)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> resourceCodec.toJSONObject(resource)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JSON.JSONObject$.MODULE$.empty());
        HttpMultiMap.HttpMultiMapBuilder queryParams = HttpMultiMap$.MODULE$.newBuilder();
        resourceJson.v().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue j = (JSON.JSONValue)tuple2._2();
                if (j instanceof JSON.JSONArray) {
                    JSON.JSONArray jSONArray = (JSON.JSONArray)j;
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(jSONArray.toJSON())));
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue j = (JSON.JSONValue)tuple2._2();
                if (j instanceof JSON.JSONObject) {
                    JSON.JSONObject jSONObject = (JSON.JSONObject)j;
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(jSONObject.toJSON())));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple2._1();
            JSON.JSONValue other = (JSON.JSONValue)tuple2._2();
            return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(other.toString())));
        }, Seq$.MODULE$.canBuildFrom());
        return queryParams.result();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HttpClient$() {
        MODULE$ = this;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

