/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.json;

import scala.Byte$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.json.JSONContext;
import wvlet.airframe.json.JSONHandler;
import wvlet.airframe.json.JSONScanner$;
import wvlet.airframe.json.JSONSource;
import wvlet.airframe.json.UnexpectedEOF;
import wvlet.airframe.json.UnexpectedToken;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;

public class JSONScanner<J>
implements LogSupport {
    private Logger logger$lzy1;
    private boolean loggerbitmap$1;
    private final JSONSource s;
    private final JSONHandler<J> handler;
    private int cursor;
    private int lineStartPos;
    private int line;
    private final StringBuilder sb;

    public static int ARRAY_END() {
        return JSONScanner$.MODULE$.ARRAY_END();
    }

    public static int ARRAY_START() {
        return JSONScanner$.MODULE$.ARRAY_START();
    }

    public static int DATA() {
        return JSONScanner$.MODULE$.DATA();
    }

    public static int[] HexChars() {
        return JSONScanner$.MODULE$.HexChars();
    }

    public static int OBJECT_END() {
        return JSONScanner$.MODULE$.OBJECT_END();
    }

    public static int OBJECT_KEY() {
        return JSONScanner$.MODULE$.OBJECT_KEY();
    }

    public static int OBJECT_START() {
        return JSONScanner$.MODULE$.OBJECT_START();
    }

    public static int SEPARATOR() {
        return JSONScanner$.MODULE$.SEPARATOR();
    }

    public static <J> J scanAny(JSONSource jSONSource, JSONContext<J> jSONContext) {
        return JSONScanner$.MODULE$.scanAny(jSONSource, jSONContext);
    }

    public static long utf8CharLenTable() {
        return JSONScanner$.MODULE$.utf8CharLenTable();
    }

    public static long validUtf8BitVector() {
        return JSONScanner$.MODULE$.validUtf8BitVector();
    }

    public static long[] whiteSpaceBitVector() {
        return JSONScanner$.MODULE$.whiteSpaceBitVector();
    }

    public JSONScanner(JSONSource s, JSONHandler<J> handler) {
        this.s = s;
        this.handler = handler;
        this.cursor = 0;
        this.lineStartPos = 0;
        this.line = 0;
        this.sb = new StringBuilder();
    }

    public Logger logger() {
        if (!this.loggerbitmap$1) {
            this.logger$lzy1 = LazyLogger.logger$((LazyLogger)this);
            this.loggerbitmap$1 = true;
        }
        return this.logger$lzy1;
    }

    private void skipWhiteSpaces() {
        boolean toContinue = true;
        block4: while (toContinue && this.cursor < this.s.length()) {
            byte ch;
            byte by = ch = this.s.apply(this.cursor);
            switch (by) {
                case 9: 
                case 13: 
                case 32: {
                    ++this.cursor;
                    continue block4;
                }
                case 10: {
                    ++this.line;
                    this.lineStartPos = ++this.cursor;
                    continue block4;
                }
            }
            toContinue = false;
        }
    }

    private Exception unexpected(String expected) {
        byte by = this.s.apply(this.cursor);
        return new UnexpectedToken(this.line, this.cursor - this.lineStartPos, this.cursor, StringOps$.MODULE$.format$extension("Found '%s' 0x%02x. expected: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{String.valueOf((char)by), BoxesRunTime.boxToByte((byte)by), expected})));
    }

    public void scan() {
        block4: {
            try {
                this.skipWhiteSpaces();
                byte by = this.s.apply(this.cursor);
                if (123 == by) {
                    ++this.cursor;
                    JSONContext<J> jSONContext = this.handler.objectContext(this.s, this.cursor - 1);
                    this.rscan(2, package$.MODULE$.Nil().$colon$colon(jSONContext));
                    break block4;
                }
                if (91 == by) {
                    ++this.cursor;
                    JSONContext<J> jSONContext = this.handler.arrayContext(this.s, this.cursor - 1);
                    this.rscan(5, package$.MODULE$.Nil().$colon$colon(jSONContext));
                    break block4;
                }
                byte other = by;
                throw this.unexpected("object or array");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new UnexpectedEOF(this.line, this.cursor - this.lineStartPos, this.cursor, "Unexpected EOF");
            }
        }
    }

    private final void scanObject(List<JSONContext<J>> stack) {
        ++this.cursor;
        JSONContext jSONContext = ((JSONHandler)stack.head()).objectContext(this.s, this.cursor - 1);
        this.rscan(2, stack.$colon$colon(jSONContext));
    }

    private final void scanArray(List<JSONContext<J>> stack) {
        ++this.cursor;
        JSONContext jSONContext = ((JSONHandler)stack.head()).arrayContext(this.s, this.cursor - 1);
        this.rscan(5, stack.$colon$colon(jSONContext));
    }

    public final J wvlet$airframe$json$JSONScanner$$scanAny(JSONContext<J> ctx) {
        this.skipWhiteSpaces();
        if (this.cursor >= this.s.length()) {
            throw new UnexpectedEOF(this.line, this.cursor - this.lineStartPos, this.cursor, "Unexpected EOF");
        }
        byte by = this.s.apply(this.cursor);
        switch (by) {
            case 34: {
                this.scanString(ctx);
                break;
            }
            case 123: {
                JSONContext objectCtx = ctx.objectContext(this.s, this.cursor);
                ++this.cursor;
                this.rscan(2, package$.MODULE$.Nil().$colon$colon(objectCtx));
                ctx.add(objectCtx.result());
                break;
            }
            case 91: {
                JSONContext arrayCtx = ctx.arrayContext(this.s, this.cursor);
                ++this.cursor;
                this.rscan(5, package$.MODULE$.Nil().$colon$colon(arrayCtx));
                ctx.add(arrayCtx.result());
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.scanNumber(ctx);
                break;
            }
            case 116: {
                this.scanTrue(ctx);
                break;
            }
            case 102: {
                this.scanFalse(ctx);
                break;
            }
            case 110: {
                this.scanNull(ctx);
                break;
            }
            default: {
                throw this.unexpected("unknown json token");
            }
        }
        return ctx.result();
    }

    private final void rscan(int state, List<JSONContext<J>> stack) {
        while (true) {
            byte ch;
            if ((ch = this.s.apply(this.cursor)) == 10) {
                ++this.line;
                this.lineStartPos = ++this.cursor;
                continue;
            }
            if (ch == 32 || ch == 9 || ch == 13) {
                ++this.cursor;
                continue;
            }
            if (state == 1) {
                if (ch == 91) {
                    ++this.cursor;
                    int n = 5;
                    JSONContext jSONContext = ((JSONHandler)stack.head()).arrayContext(this.s, this.cursor - 1);
                    List list = stack.$colon$colon(jSONContext);
                    state = n;
                    stack = list;
                    continue;
                }
                if (ch == 123) {
                    ++this.cursor;
                    int n = 2;
                    JSONContext jSONContext = ((JSONHandler)stack.head()).objectContext(this.s, this.cursor - 1);
                    List list = stack.$colon$colon(jSONContext);
                    state = n;
                    stack = list;
                    continue;
                }
                JSONContext ctx = (JSONContext)stack.head();
                if (ch >= 48 && ch <= 57 || ch == 45) {
                    this.scanNumber(ctx);
                    state = ctx.endScannerState();
                    continue;
                }
                if (ch == 34) {
                    this.scanString(ctx);
                    state = ctx.endScannerState();
                    continue;
                }
                if (ch == 116) {
                    this.scanTrue(ctx);
                    state = ctx.endScannerState();
                    continue;
                }
                if (ch == 102) {
                    this.scanFalse(ctx);
                    state = ctx.endScannerState();
                    continue;
                }
                if (ch == 110) {
                    this.scanNull(ctx);
                    state = ctx.endScannerState();
                    continue;
                }
                throw this.unexpected("json value");
            }
            if (ch == 93 && (state == 6 || state == 5) || ch == 125 && (state == 4 || state == 2)) {
                if (stack.isEmpty()) {
                    throw this.unexpected("obj or array");
                }
                JSONContext ctx1 = (JSONContext)stack.head();
                List tail = (List)stack.tail();
                ctx1.closeContext(this.s, this.cursor);
                ++this.cursor;
                if (tail.isEmpty()) {
                    return;
                }
                JSONContext ctx2 = (JSONContext)tail.head();
                int n = ctx2.endScannerState();
                List list = tail;
                state = n;
                stack = list;
                continue;
            }
            if (state == 3) {
                if (ch == 34) {
                    this.scanString((JSONContext)stack.head());
                    state = 7;
                    continue;
                }
                throw this.unexpected("DoubleQuote");
            }
            if (state == 7) {
                if (ch == 58) {
                    ++this.cursor;
                    state = 1;
                    continue;
                }
                throw this.unexpected("Colon");
            }
            if (state == 6) {
                if (ch == 44) {
                    ++this.cursor;
                    state = 1;
                    continue;
                }
                throw this.unexpected("RSquare or comma");
            }
            if (state == 4) {
                if (ch == 44) {
                    ++this.cursor;
                    state = 3;
                    continue;
                }
                throw this.unexpected("RBracket or comma");
            }
            if (state == 5) {
                state = 1;
                continue;
            }
            state = 3;
        }
    }

    private byte cursorChar() {
        if (this.cursor < this.s.length()) {
            return this.s.apply(this.cursor);
        }
        return -1;
    }

    private void scanNumber(JSONContext<J> ctx) {
        int numberEnd;
        int numberStart = this.cursor;
        byte ch = this.s.apply(this.cursor);
        if (ch == 45) {
            ++this.cursor;
            ch = this.s.apply(this.cursor);
        }
        if (ch == 48) {
            ++this.cursor;
            ch = this.cursorChar();
        } else if (49 <= ch && ch <= 57) {
            while (48 <= ch && ch <= 57) {
                ++this.cursor;
                ch = this.cursorChar();
            }
        } else {
            throw this.unexpected("digits");
        }
        int dotIndex = -1;
        if (ch == 46) {
            dotIndex = this.cursor++;
            ch = this.s.apply(this.cursor);
            if (48 <= ch && ch <= 57) {
                while (48 <= ch && ch <= 57) {
                    ++this.cursor;
                    ch = this.cursorChar();
                }
            } else {
                throw this.unexpected("digist");
            }
        }
        int expIndex = -1;
        if (ch == 101 || ch == 69) {
            expIndex = this.cursor++;
            ch = this.s.apply(this.cursor);
            if (ch == 43 | ch == 45) {
                ++this.cursor;
                ch = this.s.apply(this.cursor);
            }
            if (48 <= ch && ch <= 57) {
                while (48 <= ch && ch <= 57) {
                    ++this.cursor;
                    ch = this.cursorChar();
                }
            } else {
                throw this.unexpected("digits");
            }
        }
        if (numberStart < (numberEnd = this.cursor)) {
            ctx.addNumber(this.s, numberStart, numberEnd, dotIndex, expIndex);
            return;
        }
    }

    private void ensure(int length) {
        if (this.cursor + length > this.s.length()) {
            throw new UnexpectedEOF(this.line, this.cursor - this.lineStartPos, this.cursor, new java.lang.StringBuilder(41).append("Expected having ").append(length).append(" characters, but ").append(this.s.length() - this.cursor).append(" is left").toString());
        }
    }

    private void scanTrue(JSONContext<J> ctx) {
        this.ensure(4);
        if (this.s.apply(this.cursor) == 116 && this.s.apply(this.cursor + 1) == 114 && this.s.apply(this.cursor + 2) == 117 && this.s.apply(this.cursor + 3) == 101) {
            this.cursor += 4;
            ctx.addBoolean(this.s, true, this.cursor - 4, this.cursor);
            return;
        }
        throw this.unexpected("true");
    }

    private void scanFalse(JSONContext<J> ctx) {
        this.ensure(5);
        if (this.s.apply(this.cursor) == 102 && this.s.apply(this.cursor + 1) == 97 && this.s.apply(this.cursor + 2) == 108 && this.s.apply(this.cursor + 3) == 115 && this.s.apply(this.cursor + 4) == 101) {
            this.cursor += 5;
            ctx.addBoolean(this.s, false, this.cursor - 5, this.cursor);
            return;
        }
        throw this.unexpected("false");
    }

    private void scanNull(JSONContext<J> ctx) {
        this.ensure(4);
        if (this.s.apply(this.cursor) == 110 && this.s.apply(this.cursor + 1) == 117 && this.s.apply(this.cursor + 2) == 108 && this.s.apply(this.cursor + 3) == 108) {
            this.cursor += 4;
            ctx.addNull(this.s, this.cursor - 4, this.cursor);
            return;
        }
        throw this.unexpected("null");
    }

    private final int scanSimpleString() {
        int i = 0;
        int ch = this.s.apply(this.cursor + i) & 0xFF;
        while (ch != 34) {
            if (ch < 32) {
                throw this.unexpected("utf8");
            }
            if (ch == 92) {
                return -1;
            }
            ch = this.s.apply(this.cursor + ++i) & 0xFF;
        }
        return i;
    }

    private final void scanString(JSONContext<J> ctx) {
        ++this.cursor;
        int stringStart = this.cursor;
        int k = this.scanSimpleString();
        if (k != -1) {
            this.cursor += k + 1;
            ctx.addString(this.s, stringStart, this.cursor - 1);
            return;
        }
        this.sb.clear();
        boolean bl = true;
        while (bl) {
            byte ch = this.s.apply(this.cursor);
            byte by = ch;
            if (34 == by) {
                ++this.cursor;
                bl = false;
                continue;
            }
            if (92 == by) {
                this.scanEscape(this.sb);
                continue;
            }
            this.scanUtf8(this.sb);
        }
        ctx.addUnescapedString(this.sb.result());
    }

    private void scanUtf8(StringBuilder sb) {
        byte ch = this.s.apply(this.cursor);
        int first5bit = (ch & 0xF8) >> 3;
        long isValidUtf8Header = JSONScanner$.MODULE$.validUtf8BitVector() & 1L << first5bit;
        if (isValidUtf8Header != 0L) {
            int pos = (ch & 0xF0) >> 3;
            long mask = 3L << pos;
            long utf8len = (JSONScanner$.MODULE$.utf8CharLenTable() & mask) >> pos;
            int start = this.cursor++;
            this.scanUtf8Body((int)utf8len);
            sb.append(this.s.substring(start, this.cursor));
            return;
        }
        throw this.unexpected("utf8");
    }

    private void scanUtf8Body(int n) {
        while (n > 0) {
            byte ch = this.s.apply(this.cursor);
            int b = ch & 0xFF;
            if ((b & 0xC0) == 128) {
                ++this.cursor;
                --n;
                continue;
            }
            throw this.unexpected("utf8 body");
        }
    }

    private void scanEscape(StringBuilder sb) {
        byte ch;
        ++this.cursor;
        byte by = ch = this.s.apply(this.cursor);
        switch (by) {
            case 34: {
                sb.append('\"');
                ++this.cursor;
                return;
            }
            case 92: {
                sb.append('\\');
                ++this.cursor;
                return;
            }
            case 47: {
                sb.append('/');
                ++this.cursor;
                return;
            }
            case 98: {
                sb.append('\b');
                ++this.cursor;
                return;
            }
            case 102: {
                sb.append('\f');
                ++this.cursor;
                return;
            }
            case 110: {
                sb.append('\n');
                ++this.cursor;
                return;
            }
            case 114: {
                sb.append('\r');
                ++this.cursor;
                return;
            }
            case 116: {
                sb.append('\t');
                ++this.cursor;
                return;
            }
            case 117: {
                ++this.cursor;
                char hexCode = (char)this.scanHex(4, 0);
                sb.append(hexCode);
                return;
            }
        }
        throw this.unexpected("escape");
    }

    private int scanHex(int n, int code) {
        while (true) {
            if (n == 0) {
                return code;
            }
            byte ch = this.s.apply(this.cursor);
            if (!(ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70) && (ch < 48 || ch > 57)) break;
            ++this.cursor;
            int n2 = n - 1;
            int n3 = code << 4 | JSONScanner$.MODULE$.HexChars()[Byte$.MODULE$.byte2int(ch)];
            n = n2;
            code = n3;
        }
        throw this.unexpected("hex");
    }
}

