/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import wvlet.log.Guard;
import wvlet.log.LogLevelScanner$;
import wvlet.log.LogLevelScanner$RUNNING$;
import wvlet.log.LogLevelScanner$STOPPED$;
import wvlet.log.LogLevelScanner$STOPPING$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.LogLevelScannerConfig$;

@ScalaSignature(bytes="\u0006\u0005\u0005]x!\u0002\u001a4\u0011\u0003Ad!\u0002\u001e4\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005b\u0002#\u0002\u0005\u0004%I!\u0012\u0005\u0007\u0013\u0006\u0001\u000b\u0011\u0002$\t\u000b)\u000bA\u0011A&\t\u000fe\u000b!\u0019!C\u00015\"1\u0011.\u0001Q\u0001\nmCQA[\u0001\u0005\u0002-DQA[\u0001\u0005\u00021Da!a\u0001\u0002\t\u0003Y\u0007bCA\u0003\u0003!\u0015\r\u0011\"\u00014\u0003\u000fAq!a\u0001\u0002\t\u0003\ty\rC\u0004\u0002\u0004\u0005!\t!a5\t\r\u0005\u0015\u0018\u0001\"\u0001l\u0011!\t9/\u0001C\u0001g\u0005%hACA8\u0003A\u0005\u0019\u0013E\u001a\u0002r\u001dA\u0011\u0011_\u0001\t\u0002M\nyH\u0002\u0005\u0002v\u0005A\taMA<\u0011\u0019\u0011%\u0003\"\u0001\u0002~\u001dA\u00111_\u0001\t\u0002M\nyI\u0002\u0005\u0002\n\u0006A\taMAF\u0011\u0019\u0011U\u0003\"\u0001\u0002\u000e\u001eA\u0011Q_\u0001\t\u0002M\n9I\u0002\u0005\u0002\u0002\u0006A\taMAB\u0011\u0019\u0011\u0005\u0004\"\u0001\u0002\u0006\u001a1!h\r\u00014\u0003\u0017AaA\u0011\u000e\u0005\u0002\u0005M\u0001\"CA\u000b5\t\u0007I\u0011BA\f\u0011!\t\u0019D\u0007Q\u0001\n\u0005e\u0001\"CA\u001b5\t\u0007I\u0011BA\u001c\u0011!\t)E\u0007Q\u0001\n\u0005e\u0002BCA$5\t\u0007I\u0011A\u001a\u0002J!A\u0011\u0011\u000b\u000e!\u0002\u0013\tY\u0005C\u0004\u0002Ti!\t!!\u0016\t\u000f\u0005]#\u0004\"\u0001\u0002Z!I\u0011Q\f\u000eC\u0002\u0013%\u0011q\f\u0005\t\u0003#S\u0002\u0015!\u0003\u0002b!1\u00111\u0013\u000e\u0005\u0002-Da!!&\u001b\t\u0003Y\u0007\"CAL5\u0001\u0007I\u0011BAM\u0011%\t9K\u0007a\u0001\n\u0013\tI\u000b\u0003\u0005\u00020j\u0001\u000b\u0015BAN\u0011%\t\tL\u0007a\u0001\n\u0013\tI\nC\u0005\u00024j\u0001\r\u0011\"\u0003\u00026\"A\u0011\u0011\u0018\u000e!B\u0013\tY\n\u0003\u0004\u0002<j!Ia\u001b\u0004\u0007\u0003{SB!a0\t\r\t{C\u0011AAd\u0011\u001d\tYl\fC!\u0003\u001b\fq\u0002T8h\u0019\u00164X\r\\*dC:tWM\u001d\u0006\u0003iU\n1\u0001\\8h\u0015\u00051\u0014!B<wY\u0016$8\u0001\u0001\t\u0003s\u0005i\u0011a\r\u0002\u0010\u0019><G*\u001a<fYN\u001b\u0017M\u001c8feN\u0011\u0011\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0014A\u00027pO\u001e,'/F\u0001G!\tIt)\u0003\u0002Ig\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0007tKRdun\u001a'fm\u0016d7\u000f\u0006\u0002M\u001fB\u0011Q(T\u0005\u0003\u001dz\u0012A!\u00168ji\")\u0001+\u0002a\u0001#\u0006!a-\u001b7f!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0002j_*\ta+\u0001\u0003kCZ\f\u0017B\u0001-T\u0005\u00111\u0015\u000e\\3\u0002A\u0011+e)Q+M)~cuj\u0012'F-\u0016cuLR%M\u000b~\u001b\u0015I\u0014#J\t\u0006#ViU\u000b\u00027B\u0019A,Y2\u000e\u0003uS!AX0\u0002\u0013%lW.\u001e;bE2,'B\u00011?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u00131aU3r!\t!w-D\u0001f\u0015\t1W+\u0001\u0003mC:<\u0017B\u00015f\u0005\u0019\u0019FO]5oO\u0006\tC)\u0012$B+2#v\fT(H\u0019\u00163V\tT0G\u00132+ulQ!O\t&#\u0015\tV#TA\u0005i1oY1o\u0019><G*\u001a<fYN,\u0012\u0001\u0014\u000b\u0003\u00196DQA\\\u0005A\u0002=\fa\u0003\\8hY\u00164X\r\u001c$jY\u0016\u001c\u0015M\u001c3jI\u0006$Xm\u001d\t\u0004abThBA9w\u001d\t\u0011X/D\u0001t\u0015\t!x'\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0011qOP\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0011\u0017P\u0003\u0002x}A\u00111p \b\u0003yv\u0004\"A\u001d \n\u0005yt\u0014A\u0002)sK\u0012,g-C\u0002i\u0003\u0003Q!A  \u0002)M\u001c\u0007.\u001a3vY\u0016dun\u001a'fm\u0016d7kY1o\u0003=awn\u001a'fm\u0016d7kY1o]\u0016\u0014XCAA\u0005!\tI$d\u0005\u0003\u001by\u00055\u0001cA\u001d\u0002\u0010%\u0019\u0011\u0011C\u001a\u0003\u000b\u001d+\u0018M\u001d3\u0015\u0005\u0005%\u0011AB2p]\u001aLw-\u0006\u0002\u0002\u001aA1\u00111DA\u0015\u0003[i!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0007CR|W.[2\u000b\t\u0005\r\u0012QE\u0001\u000bG>t7-\u001e:sK:$(bAA\u0014+\u0006!Q\u000f^5m\u0013\u0011\tY#!\b\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042!OA\u0018\u0013\r\t\td\r\u0002\u0016\u0019><G*\u001a<fYN\u001b\u0017M\u001c8fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nQbY8oM&<7\t[1oO\u0016$WCAA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"\u0002BA \u0003C\tQ\u0001\\8dWNLA!a\u0011\u0002>\tI1i\u001c8eSRLwN\\\u0001\u000fG>tg-[4DQ\u0006tw-\u001a3!\u0003%\u00198-\u00198D_VtG/\u0006\u0002\u0002LA!\u00111DA'\u0013\u0011\ty%!\b\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u0006tG\u0006t7i\\;oi\u0002\n\u0011bZ3u\u0007>tg-[4\u0016\u0005\u00055\u0012!C:fi\u000e{gNZ5h)\ra\u00151\f\u0005\b\u0003+\u0019\u0003\u0019AA\u0017\u0003\u0015\u0019H/\u0019;f+\t\t\t\u0007\u0005\u0004\u0002\u001c\u0005%\u00121\r\t\u0004\u0003K\u0002bbAA4\u00019!\u0011\u0011NA7\u001d\r\u0011\u00181N\u0005\u0002m%\u0011A'\u000e\u0002\r'\u000e\fgN\\3s'R\fG/Z\n\u0003!qJC\u0001\u0005\n\u0019+\t9!+\u0016(O\u0013:;5\u0003\u0002\n=\u0003s\u00022!a\u001f\u0011\u001b\u0005\tACAA@!\r\tYH\u0005\u0002\b'R{\u0005\u000bU#E'\u0011AB(!\u001f\u0015\u0005\u0005\u001d\u0005cAA>1\tA1\u000bV(Q!&sui\u0005\u0003\u0016y\u0005eDCAAH!\r\tY(F\u0001\u0007gR\fG/\u001a\u0011\u0002\u000bM$\u0018M\u001d;\u0002\tM$x\u000e]\u0001\u0014Y\u0006\u001cHoU2iK\u0012,H.\u001a3NS2d\u0017n]\u000b\u0003\u00037\u0003R!PAO\u0003CK1!a(?\u0005\u0019y\u0005\u000f^5p]B\u0019Q(a)\n\u0007\u0005\u0015fH\u0001\u0003M_:<\u0017a\u00067bgR\u001c6\r[3ek2,G-T5mY&\u001cx\fJ3r)\ra\u00151\u0016\u0005\n\u0003[K\u0013\u0011!a\u0001\u00037\u000b1\u0001\u001f\u00132\u0003Qa\u0017m\u001d;TG\",G-\u001e7fI6KG\u000e\\5tA\u0005\tB.Y:u'\u000e\fgN\\3e\u001b&dG.[:\u0002+1\f7\u000f^*dC:tW\rZ'jY2L7o\u0018\u0013fcR\u0019A*a.\t\u0013\u00055F&!AA\u0002\u0005m\u0015A\u00057bgR\u001c6-\u00198oK\u0012l\u0015\u000e\u001c7jg\u0002\n1A];o\u0005Uaun\u001a'fm\u0016d7kY1o]\u0016\u0014H\u000b\u001b:fC\u0012\u001c2aLAa!\r!\u00171Y\u0005\u0004\u0003\u000b,'A\u0002+ie\u0016\fG\r\u0006\u0002\u0002JB\u0019\u00111Z\u0018\u000e\u0003i!\u0012\u0001\u0014\u000b\u0004\u0019\u0006E\u0007bBA\u000b\u0019\u0001\u0007\u0011Q\u0006\u000b\u0004\u0019\u0006U\u0007bBAl\u001b\u0001\u0007\u0011\u0011\\\u0001\tIV\u0014\u0018\r^5p]B!\u00111\\Aq\u001b\t\tiN\u0003\u0003\u0002X\u0006}'bAA\u0012}%!\u00111]Ao\u0005!!UO]1uS>t\u0017!G:u_B\u001c6\r[3ek2,G\rT8h\u0019\u00164X\r\\*dC:\fAa]2b]R1\u00111TAv\u0003_Da!!<\u0010\u0001\u0004y\u0017A\u00067pO2+g/\u001a7GS2,7)\u00198eS\u0012\fG/Z:\t\u000f\u0005Ev\u00021\u0001\u0002\u001c\u00069!+\u0016(O\u0013:;\u0015\u0001C*U\u001fB\u0003\u0016JT$\u0002\u000fM#v\n\u0015)F\t\u0002")
public class LogLevelScanner
implements Guard {
    private final AtomicReference<LogLevelScannerConfig> config;
    private final Condition configChanged;
    private final AtomicLong scanCount;
    private final AtomicReference<ScannerState> state;
    private Option<Object> lastScheduledMillis;
    private Option<Object> lastScannedMillis;
    private ReentrantLock wvlet$log$Guard$$lock;

    public static void stopScheduledLogLevelScan() {
        LogLevelScanner$.MODULE$.stopScheduledLogLevelScan();
    }

    public static void scheduleLogLevelScan(Duration duration) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(duration);
    }

    public static void scheduleLogLevelScan(LogLevelScannerConfig logLevelScannerConfig) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(logLevelScannerConfig);
    }

    public static void scheduleLogLevelScan() {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan();
    }

    public static void scanLogLevels(Seq<String> seq) {
        LogLevelScanner$.MODULE$.scanLogLevels(seq);
    }

    public static void scanLogLevels() {
        LogLevelScanner$.MODULE$.scanLogLevels();
    }

    public static Seq<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return LogLevelScanner$.MODULE$.DEFAULT_LOGLEVEL_FILE_CANDIDATES();
    }

    public static void setLogLevels(File file) {
        LogLevelScanner$.MODULE$.setLogLevels(file);
    }

    @Override
    public Condition newCondition() {
        return Guard.newCondition$(this);
    }

    @Override
    public <U> U guard(Function0<U> body) {
        return (U)Guard.guard$(this, body);
    }

    @Override
    public ReentrantLock wvlet$log$Guard$$lock() {
        return this.wvlet$log$Guard$$lock;
    }

    @Override
    public final void wvlet$log$Guard$_setter_$wvlet$log$Guard$$lock_$eq(ReentrantLock x$1) {
        this.wvlet$log$Guard$$lock = x$1;
    }

    private AtomicReference<LogLevelScannerConfig> config() {
        return this.config;
    }

    private Condition configChanged() {
        return this.configChanged;
    }

    public AtomicLong scanCount() {
        return this.scanCount;
    }

    public LogLevelScannerConfig getConfig() {
        return this.config().get();
    }

    public void setConfig(LogLevelScannerConfig config) {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogLevelScannerConfig prev = this.config().get();
            Seq<String> seq = prev.logLevelFileCandidates();
            Seq<String> seq2 = config.logLevelFileCandidates();
            if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                this.lastScannedMillis_$eq((Option<Object>)None$.MODULE$);
            }
            this.config().set(config);
            this.configChanged().signalAll();
        });
    }

    private AtomicReference<ScannerState> state() {
        return this.state;
    }

    public void start() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$RUNNING$.MODULE$);
                if (!this.state().compareAndSet(LogLevelScanner$STOPPED$.MODULE$, LogLevelScanner$RUNNING$.MODULE$)) break block0;
                new LogLevelScannerThread().start();
            }
        });
    }

    public void stop() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.state().set(LogLevelScanner$STOPPING$.MODULE$));
    }

    private Option<Object> lastScheduledMillis() {
        return this.lastScheduledMillis;
    }

    private void lastScheduledMillis_$eq(Option<Object> x$1) {
        this.lastScheduledMillis = x$1;
    }

    private Option<Object> lastScannedMillis() {
        return this.lastScannedMillis;
    }

    private void lastScannedMillis_$eq(Option<Object> x$1) {
        this.lastScannedMillis = x$1;
    }

    public void wvlet$log$LogLevelScanner$$run() {
        while (!this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$STOPPED$.MODULE$)) {
            long currentTimeMillis = System.currentTimeMillis();
            long scanIntervalMillis = this.getConfig().scanInterval().toMillis();
            if (this.lastScheduledMillis().isEmpty() || currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get()) > scanIntervalMillis) {
                Option<Object> updatedLastScannedMillis = LogLevelScanner$.MODULE$.scan(this.getConfig().logLevelFileCandidates(), this.lastScannedMillis());
                this.scanCount().incrementAndGet();
                this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lastScannedMillis_$eq(updatedLastScannedMillis));
                this.lastScheduledMillis_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)currentTimeMillis)));
            }
            long sleepTime = scanIntervalMillis - package$.MODULE$.max(0L, package$.MODULE$.min(scanIntervalMillis, currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get())));
            this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (!this.configChanged().await(sleepTime, TimeUnit.MILLISECONDS)) {
                    // empty if block
                }
            });
        }
    }

    public LogLevelScanner() {
        Guard.$init$(this);
        this.config = new AtomicReference<LogLevelScannerConfig>(new LogLevelScannerConfig((Seq<String>)((Seq)Seq$.MODULE$.empty()), LogLevelScannerConfig$.MODULE$.apply$default$2()));
        this.configChanged = this.newCondition();
        this.scanCount = new AtomicLong(0L);
        this.state = new AtomicReference<LogLevelScanner$STOPPED$>(LogLevelScanner$STOPPED$.MODULE$);
        this.lastScheduledMillis = None$.MODULE$;
        this.lastScannedMillis = None$.MODULE$;
        Statics.releaseFence();
    }

    public class LogLevelScannerThread
    extends Thread {
        @Override
        public void run() {
            this.wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer().wvlet$log$LogLevelScanner$$run();
        }

        public /* synthetic */ LogLevelScanner wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer() {
            return LogLevelScanner.this;
        }

        public LogLevelScannerThread() {
            if (LogLevelScanner.this == null) {
                throw null;
            }
            this.setName("WvletLogLevelScanner");
            this.setDaemon(true);
        }
    }

    public static interface ScannerState {
    }
}

