/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.regex.Pattern;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$DEBUG$;
import wvlet.log.LogLevel$ERROR$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.LogLevel$TRACE$;
import wvlet.log.LogLevel$WARN$;
import wvlet.log.LogRecord;

public final class LogFormatter$ {
    public static final LogFormatter$ MODULE$ = new LogFormatter$();
    private static final Pattern testFrameworkFilter = Pattern.compile("\\s+at (sbt\\.|org\\.scalatest\\.|wvlet\\.airspec\\.).*");
    private static final Function1<String, Object> DEFAULT_STACKTRACE_FILTER = (Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)LogFormatter$.$anonfun$DEFAULT_STACKTRACE_FILTER$1(line));
    private static Function1<String, Object> stackTraceFilter = MODULE$.DEFAULT_STACKTRACE_FILTER();

    public String currentThreadName() {
        return Thread.currentThread().getName();
    }

    private Pattern testFrameworkFilter() {
        return testFrameworkFilter;
    }

    public Function1<String, Object> DEFAULT_STACKTRACE_FILTER() {
        return DEFAULT_STACKTRACE_FILTER;
    }

    private Function1<String, Object> stackTraceFilter() {
        return stackTraceFilter;
    }

    private void stackTraceFilter_$eq(Function1<String, Object> x$1) {
        stackTraceFilter = x$1;
    }

    public void setStackTraceFilter(Function1<String, Object> filter) {
        this.stackTraceFilter_$eq(filter);
    }

    public String formatStacktrace(Throwable e) {
        String string;
        Throwable throwable = e;
        if (throwable == null) {
            string = "";
        } else {
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            String stackTrace = trace.toString();
            Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])stackTrace.split("\n")), this.stackTraceFilter()));
            int x$1 = 2;
            int x$2 = ArrayOps$.MODULE$.sliding$default$2$extension(qual$1);
            Iterator filtered = ArrayOps$.MODULE$.sliding$extension(qual$1, 2, x$2).collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends String[], B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    Object object2;
                    A1 A1 = x1;
                    if (A1 != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq(A1)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
                        String a = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                        String b = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                        String string = a;
                        String string2 = b;
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            object = a;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(String[] x1) {
                    String[] stringArray = x1;
                    if (stringArray == null) return false;
                    Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object)) return false;
                    if (new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null) return false;
                    if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) return false;
                    String a = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String b = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    String string = a;
                    String string2 = b;
                    if (string == null) {
                        if (string2 == null) return false;
                        return true;
                    } else if (string.equals(string2)) return false;
                    return true;
                }
            });
            string = filtered.mkString("\n");
        }
        return string;
    }

    public String withColor(String prefix, String s) {
        return new StringBuilder(4).append(prefix).append(s).append("\u001b[0m").toString();
    }

    public String highlightLog(LogLevel level, String message) {
        LogLevel logLevel = level;
        String string = LogLevel$ERROR$.MODULE$.equals(logLevel) ? "\u001b[31m" : (LogLevel$WARN$.MODULE$.equals(logLevel) ? "\u001b[33m" : (LogLevel$INFO$.MODULE$.equals(logLevel) ? "\u001b[36m" : (LogLevel$DEBUG$.MODULE$.equals(logLevel) ? "\u001b[32m" : (LogLevel$TRACE$.MODULE$.equals(logLevel) ? "\u001b[35m" : "\u001b[0m"))));
        String color = string;
        return this.withColor(color, message);
    }

    public String appendStackTrace(String m, LogRecord r) {
        String string;
        Option<Throwable> option = r.cause();
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable ex = (Throwable)some.value();
            string = new StringBuilder(1).append(m).append("\n").append(this.highlightLog(r.level(), this.formatStacktrace(ex))).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = m;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$DEFAULT_STACKTRACE_FILTER$1(String line) {
        return !MODULE$.testFrameworkFilter().matcher(line).matches();
    }

    private LogFormatter$() {
    }
}

