/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wvlet.log.LogLevel$WARN$;
import wvlet.log.LogLevelScanner;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.Logger;
import wvlet.log.Logger$;
import wvlet.log.io.IOUtil$;
import wvlet.log.io.Resource$;

public final class LogLevelScanner$ {
    public static final LogLevelScanner$ MODULE$ = new LogLevelScanner$();
    private static LogLevelScanner logLevelScanner;
    private static final Logger logger;
    private static final List<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    private static volatile boolean bitmap$0;

    static {
        logger = Logger$.MODULE$.apply("wvlet.log.LogLevelScanner");
        DEFAULT_LOGLEVEL_FILE_CANDIDATES = new .colon.colon((Object)"log-test.properties", (List)new .colon.colon((Object)"log.properties", (List)Nil$.MODULE$));
    }

    private Logger logger() {
        return logger;
    }

    public void setLogLevels(File file) {
        Properties logLevels = new Properties();
        IOUtil$.MODULE$.withResource(new FileReader(file), (Function1 & Serializable)in -> {
            logLevels.load(in);
            return BoxedUnit.UNIT;
        });
        Logger$.MODULE$.setLogLevels(logLevels);
    }

    public List<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    }

    public void scanLogLevels() {
        this.scanLogLevels((Seq<String>)this.DEFAULT_LOGLEVEL_FILE_CANDIDATES());
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        this.scan((List<String>)loglevelFileCandidates.toList(), (Option<Object>)None$.MODULE$);
    }

    public void scheduleLogLevelScan() {
        this.scheduleLogLevelScan(new LogLevelScannerConfig(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES)));
    }

    private LogLevelScanner logLevelScanner$lzycompute() {
        LogLevelScanner$ logLevelScanner$ = this;
        synchronized (logLevelScanner$) {
            if (!bitmap$0) {
                logLevelScanner = new LogLevelScanner();
                bitmap$0 = true;
            }
        }
        return logLevelScanner;
    }

    public LogLevelScanner logLevelScanner() {
        if (!bitmap$0) {
            return this.logLevelScanner$lzycompute();
        }
        return logLevelScanner;
    }

    public void scheduleLogLevelScan(LogLevelScannerConfig config) {
        this.logLevelScanner().setConfig(config);
        this.logLevelScanner().start();
    }

    public void scheduleLogLevelScan(Duration duration) {
        this.scheduleLogLevelScan(new LogLevelScannerConfig(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES(), duration));
    }

    public void stopScheduledLogLevelScan() {
        this.logLevelScanner().stop();
    }

    public Option<Object> scan(List<String> logLevelFileCandidates, Option<Object> lastScannedMillis) {
        Option<Object> option;
        try {
            Option logFileURL = this.findLogLevelFile$1(logLevelFileCandidates);
            option = (Option<Object>)logFileURL.map((Function1 & Serializable)url -> {
                String string = url.getProtocol();
                switch (string == null ? 0 : string.hashCode()) {
                    case 3143036: {
                        if (!"file".equals(string)) break;
                        File f = new File(url.toURI());
                        long lastModified = f.lastModified();
                        if (lastScannedMillis.isEmpty() || BoxesRunTime.unboxToLong((Object)lastScannedMillis.get()) < lastModified) {
                            MODULE$.setLogLevels(f);
                            return new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                        }
                        return lastScannedMillis;
                    }
                }
                if (lastScannedMillis.isEmpty()) {
                    return (Option)IOUtil$.MODULE$.withResource(url.openStream(), (Function1 & Serializable)in -> {
                        Properties p = new Properties();
                        p.load((InputStream)in);
                        Logger$.MODULE$.setLogLevels(p);
                        return new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                    });
                }
                return None$.MODULE$;
            }).getOrElse((Function0 & Serializable)() -> lastScannedMillis);
        }
        catch (Throwable e) {
            this.logger().wrapped().log(LogLevel$WARN$.MODULE$.jlLevel(), new StringBuilder(46).append("Error occurred while scanning log properties: ").append(e.getMessage()).toString(), e);
            option = lastScannedMillis;
        }
        return option;
    }

    private final Option findLogLevelFile$1(List candidates) {
        Option<URL> option;
        while (true) {
            if (candidates.isEmpty()) {
                return None$.MODULE$;
            }
            option = Resource$.MODULE$.find((String)candidates.head());
            if (option instanceof Some) {
                Some some = (Some)option;
                return some;
            }
            if (!None$.MODULE$.equals(option)) break;
            candidates = (List)candidates.tail();
        }
        throw new MatchError(option);
    }

    private LogLevelScanner$() {
    }
}

