/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wvlet.log.io.Resource$;

public final class IOUtil$ {
    public static final IOUtil$ MODULE$ = new IOUtil$();

    public <Resource extends AutoCloseable, U> U withResource(Resource resource, Function1<Resource, U> body) {
        Object object;
        try {
            object = body.apply(resource);
        }
        finally {
            resource.close();
        }
        return (U)object;
    }

    public <U> U withTempFile(String name, String suffix, String dir, Function1<File, U> body) {
        Object object;
        File d = new File(dir);
        d.mkdirs();
        File f = File.createTempFile(name, suffix, d);
        try {
            object = body.apply((Object)f);
        }
        finally {
            f.delete();
        }
        return (U)object;
    }

    public <U> String withTempFile$default$2() {
        return ".tmp";
    }

    public <U> String withTempFile$default$3() {
        return "target";
    }

    public int randomPort() {
        return this.unusedPort();
    }

    public int unusedPort() {
        return BoxesRunTime.unboxToInt(this.withResource(new ServerSocket(0), (Function1 & Serializable)socket -> BoxesRunTime.boxToInteger((int)socket.getLocalPort())));
    }

    public Option<File> findPath(String path) {
        return this.findPath(new File(path));
    }

    public Option<File> findPath(File path) {
        if (path.exists()) {
            return new Some((Object)path);
        }
        File defaultPath = new File(new File(System.getProperty("prog.home", "")), path.getPath());
        if (defaultPath.exists()) {
            return new Some((Object)defaultPath);
        }
        return None$.MODULE$;
    }

    public String readAsString(File f) {
        return this.readAsString(f.toURI().toURL());
    }

    public String readAsString(URL url) {
        return (String)this.withResource(url.openStream(), (Function1 & Serializable)in -> MODULE$.readAsString((InputStream)in));
    }

    public String readAsString(String resourcePath) {
        Predef$.MODULE$.require(resourcePath != null, (Function0 & Serializable)() -> "resourcePath is null");
        return (String)Resource$.MODULE$.find(resourcePath).map((Function1 & Serializable)x$1 -> MODULE$.readAsString((URL)x$1)).getOrElse((Function0 & Serializable)() -> {
            Option<File> file = MODULE$.findPath(new File(resourcePath));
            if (file.isEmpty()) {
                throw new FileNotFoundException(new StringBuilder(10).append("Not found ").append(resourcePath).toString());
            }
            return MODULE$.readAsString(new FileInputStream((File)file.get()));
        });
    }

    public String readAsString(InputStream in) {
        return (String)this.readFully(in, (Function1 & Serializable)data -> new String((byte[])data, StandardCharsets.UTF_8));
    }

    public <U> U readFully(InputStream in, Function1<byte[], U> f) {
        byte[] byteArray = (byte[])this.withResource(new ByteArrayOutputStream(), (Function1 & Serializable)b -> {
            byte[] buf = new byte[8192];
            MODULE$.withResource(in, (Function1 & Serializable)src -> {
                IOUtil$.$anonfun$readFully$2(buf, b, src);
                return BoxedUnit.UNIT;
            });
            return b.toByteArray();
        });
        return (U)f.apply((Object)byteArray);
    }

    public static final /* synthetic */ void $anonfun$readFully$2(byte[] buf$1, ByteArrayOutputStream b$1, InputStream src) {
        int readBytes = 0;
        while ((readBytes = src.read(buf$1)) != -1) {
            b$1.write(buf$1, 0, readBytes);
        }
    }

    private IOUtil$() {
    }
}

