/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import wvlet.airframe.metrics.DataSize;
import wvlet.airframe.metrics.DataSize$BYTE$;
import wvlet.airframe.metrics.DataSize$GIGABYTE$;
import wvlet.airframe.metrics.DataSize$KILOBYTE$;
import wvlet.airframe.metrics.DataSize$MEGABYTE$;
import wvlet.airframe.metrics.DataSize$PETABYTE$;
import wvlet.airframe.metrics.DataSize$TERABYTE$;
import wvlet.airframe.surface.GenericSurface;
import wvlet.airframe.surface.GenericSurface$;
import wvlet.airframe.surface.MethodRef;
import wvlet.airframe.surface.ObjectFactory;
import wvlet.airframe.surface.Parameter;
import wvlet.airframe.surface.Primitive$Double$;
import wvlet.airframe.surface.StdMethodParameter;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.surface.Zero$;

public final class DataSize$
implements Serializable {
    public static final DataSize$ MODULE$ = new DataSize$();
    private static final Regex dataSizePattern;
    private static final List<DataSize.DataSizeUnit> units;
    private static final Map<String, DataSize.DataSizeUnit> unitTable;

    static {
        Zero$.MODULE$.register((Surface)wvlet.airframe.surface.package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"wvlet.airframe.metrics.DataSize.DataSizeUnit", (Function0 & Serializable)() -> new GenericSurface(DataSize.DataSizeUnit.class, GenericSurface$.MODULE$.$lessinit$greater$default$2(), GenericSurface$.MODULE$.$lessinit$greater$default$3(), GenericSurface$.MODULE$.$lessinit$greater$default$4())), DataSize$BYTE$.MODULE$);
        Zero$.MODULE$.register((Surface)wvlet.airframe.surface.package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"wvlet.airframe.metrics.DataSize", (Function0 & Serializable)() -> new GenericSurface(DataSize.class, (Seq<Surface>)((Seq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$)), (Seq<Parameter>)((Seq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StdMethodParameter[]{new StdMethodParameter(new MethodRef(DataSize.class, "<init>", (Seq)new .colon.colon(Double.TYPE, (List)new .colon.colon(DataSize.DataSizeUnit.class, (List)Nil$.MODULE$)), true), 0, "value", false, false, (Surface)wvlet.airframe.surface.package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"scala.Double", (Function0 & Serializable)() -> Primitive$Double$.MODULE$), (Option<Object>)None$.MODULE$, (Option<Function1<Object, Object>>)new Some((Function1 & Serializable)x -> BoxesRunTime.boxToDouble((double)DataSize$.$anonfun$new$7(x)))), new StdMethodParameter(new MethodRef(DataSize.class, "<init>", (Seq)new .colon.colon(Double.TYPE, (List)new .colon.colon(DataSize.DataSizeUnit.class, (List)Nil$.MODULE$)), true), 1, "unit", false, false, (Surface)wvlet.airframe.surface.package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"wvlet.airframe.metrics.DataSize.DataSizeUnit", (Function0 & Serializable)() -> new GenericSurface(DataSize.DataSizeUnit.class, GenericSurface$.MODULE$.$lessinit$greater$default$2(), GenericSurface$.MODULE$.$lessinit$greater$default$3(), GenericSurface$.MODULE$.$lessinit$greater$default$4())), (Option<Object>)None$.MODULE$, (Option<Function1<Object, Object>>)new Some((Function1 & Serializable)x -> ((DataSize)x).unit()))}))), (Option<ObjectFactory>)new Some((Object)new ObjectFactory(){

            public DataSize newInstance(Seq<Object> args) {
                return new DataSize(BoxesRunTime.unboxToDouble((Object)args.apply(0)), (DataSize.DataSizeUnit)args.apply(1));
            }
        }))), new DataSize(0.0, DataSize$BYTE$.MODULE$));
        dataSizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*(\\d+(?:\\.\\d+)?)\\s*([a-zA-Z]+)\\s*$"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"num", "unit"}));
        units = (List)new .colon.colon((Object)DataSize$BYTE$.MODULE$, (List)new .colon.colon((Object)DataSize$KILOBYTE$.MODULE$, (List)new .colon.colon((Object)DataSize$MEGABYTE$.MODULE$, (List)new .colon.colon((Object)DataSize$GIGABYTE$.MODULE$, (List)new .colon.colon((Object)DataSize$TERABYTE$.MODULE$, (List)new .colon.colon((Object)DataSize$PETABYTE$.MODULE$, (List)Nil$.MODULE$))))));
        unitTable = MODULE$.units().map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.unitString()), x)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void checkState(boolean preCondition, String errorMessage) {
        if (!preCondition) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public DataSize.StrToDataSizeConverter StrToDataSizeConverter(String dataSizeStr) {
        return new DataSize.StrToDataSizeConverter(dataSizeStr);
    }

    public DataSize.LongToDataSizeConverter LongToDataSizeConverter(long bytes) {
        return new DataSize.LongToDataSizeConverter(bytes);
    }

    private Regex dataSizePattern() {
        return dataSizePattern;
    }

    public List<DataSize.DataSizeUnit> units() {
        return units;
    }

    private Map<String, DataSize.DataSizeUnit> unitTable() {
        return unitTable;
    }

    public DataSize succinct(long bytes) {
        return new DataSize(bytes, DataSize$BYTE$.MODULE$).mostSuccinctDataSize();
    }

    public DataSize apply(long bytes) {
        return new DataSize(bytes, DataSize$BYTE$.MODULE$);
    }

    public DataSize apply(String dataSizeStr) {
        DataSize dataSize;
        Option option = this.dataSizePattern().findFirstMatchIn((CharSequence)dataSizeStr);
        if (None$.MODULE$.equals(option)) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(dataSizeStr)));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    throw new IllegalArgumentException(new StringBuilder(26).append("Invalid data size string: ").append(dataSizeStr).toString());
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            long l = BoxesRunTime.unboxToLong((Object)success.value());
            DataSize dataSize2 = this.apply(l);
            dataSize = dataSize2;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            double num = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(m.group("num")));
            String unit = m.group("unit");
            Option option2 = this.unitTable().get((Object)unit);
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException(new StringBuilder(22).append("Invalid data unit ").append(unit).append(" in ").append(dataSizeStr).toString());
            }
            if (!(option2 instanceof Some)) {
                throw new MatchError((Object)option2);
            }
            Some some2 = (Some)option2;
            DataSize.DataSizeUnit u = (DataSize.DataSizeUnit)some2.value();
            DataSize dataSize3 = new DataSize(num, u);
            dataSize = dataSize3;
        } else {
            throw new MatchError((Object)option);
        }
        return dataSize;
    }

    public DataSize apply(double value, DataSize.DataSizeUnit unit) {
        return new DataSize(value, unit);
    }

    public Option<Tuple2<Object, DataSize.DataSizeUnit>> unapply(DataSize x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)x$0.value()), (Object)x$0.unit()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DataSize$.class);
    }

    public static final /* synthetic */ double $anonfun$new$7(Object x) {
        return ((DataSize)x).value();
    }

    private DataSize$() {
    }
}

