/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.metrics.ElapsedTime;
import wvlet.airframe.surface.GenericSurface;
import wvlet.airframe.surface.GenericSurface$;
import wvlet.airframe.surface.MethodRef;
import wvlet.airframe.surface.ObjectFactory;
import wvlet.airframe.surface.Parameter;
import wvlet.airframe.surface.Primitive$Double$;
import wvlet.airframe.surface.StdMethodParameter;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.surface.Zero$;
import wvlet.airframe.surface.package$;

public final class ElapsedTime$
implements Serializable {
    public static final ElapsedTime$ MODULE$ = new ElapsedTime$();
    private static final Pattern PATTERN;

    static {
        Zero$.MODULE$.register((Surface)package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"wvlet.airframe.metrics.ElapsedTime", (Function0 & Serializable)() -> new GenericSurface(ElapsedTime.class, (Seq<Surface>)((Seq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$)), (Seq<Parameter>)((Seq)scala.package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StdMethodParameter[]{new StdMethodParameter(new MethodRef(ElapsedTime.class, "<init>", (Seq)new .colon.colon(Double.TYPE, (List)new .colon.colon(Object.class, (List)Nil$.MODULE$)), true), 0, "value", false, false, (Surface)package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"scala.Double", (Function0 & Serializable)() -> Primitive$Double$.MODULE$), (Option<Object>)None$.MODULE$, (Option<Function1<Object, Object>>)new Some((Function1 & Serializable)x -> BoxesRunTime.boxToDouble((double)ElapsedTime$.$anonfun$new$6(x)))), new StdMethodParameter(new MethodRef(ElapsedTime.class, "<init>", (Seq)new .colon.colon(Double.TYPE, (List)new .colon.colon(Object.class, (List)Nil$.MODULE$)), true), 1, "unit", false, false, (Surface)package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"java.util.concurrent.TimeUnit", (Function0 & Serializable)() -> new GenericSurface(TimeUnit.class, GenericSurface$.MODULE$.$lessinit$greater$default$2(), GenericSurface$.MODULE$.$lessinit$greater$default$3(), GenericSurface$.MODULE$.$lessinit$greater$default$4())), (Option<Object>)None$.MODULE$, (Option<Function1<Object, Object>>)new Some((Function1 & Serializable)x -> ((ElapsedTime)x).unit()))}))), (Option<ObjectFactory>)new Some((Object)new ObjectFactory(){

            public ElapsedTime newInstance(Seq<Object> args) {
                return new ElapsedTime(BoxesRunTime.unboxToDouble((Object)args.apply(0)), (TimeUnit)((Object)args.apply(1)));
            }
        }))), MODULE$.succinctMillis(0L));
        Zero$.MODULE$.register((Surface)package$.MODULE$.surfaceCache().getOrElseUpdate((Object)"java.util.concurrent.TimeUnit", (Function0 & Serializable)() -> new GenericSurface(TimeUnit.class, GenericSurface$.MODULE$.$lessinit$greater$default$2(), GenericSurface$.MODULE$.$lessinit$greater$default$3(), GenericSurface$.MODULE$.$lessinit$greater$default$4())), (Object)TimeUnit.NANOSECONDS);
        PATTERN = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s*([a-zA-Z]+)\\s*$");
    }

    public List<TimeUnit> units() {
        return (List)new .colon.colon((Object)TimeUnit.NANOSECONDS, (List)new .colon.colon((Object)TimeUnit.MICROSECONDS, (List)new .colon.colon((Object)TimeUnit.MILLISECONDS, (List)new .colon.colon((Object)TimeUnit.SECONDS, (List)new .colon.colon((Object)TimeUnit.MINUTES, (List)new .colon.colon((Object)TimeUnit.HOURS, (List)new .colon.colon((Object)TimeUnit.DAYS, (List)Nil$.MODULE$)))))));
    }

    private Pattern PATTERN() {
        return PATTERN;
    }

    public ElapsedTime nanosSince(long start) {
        return this.succinctNanos(System.nanoTime() - start);
    }

    public ElapsedTime succinctNanos(long nanos) {
        return this.succinctDuration(nanos, TimeUnit.NANOSECONDS);
    }

    public ElapsedTime succinctDuration(double value, TimeUnit unit) {
        return new ElapsedTime(value, unit).convertToMostSuccinctTimeUnit();
    }

    public ElapsedTime succinctMillis(long milliSeconds) {
        return new ElapsedTime(milliSeconds, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit();
    }

    public ElapsedTime apply(String elapsedTimeStr) {
        return this.parse(elapsedTimeStr);
    }

    public ElapsedTime parse(String s) {
        Matcher m = this.PATTERN().matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException(new StringBuilder(31).append(s).append(" is not a valid duration string").toString());
        }
        double value = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(m.group(1)));
        String unitString = m.group(2);
        return new ElapsedTime(value, this.valueOfTimeUnit(unitString));
    }

    public double millisPerTimeUnit(TimeUnit timeUnit) {
        double d;
        TimeUnit timeUnit2 = timeUnit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit2)) {
            d = 1.0E-6;
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit2)) {
            d = 0.001;
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit2)) {
            d = 1.0;
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit2)) {
            d = 1000.0;
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit2)) {
            d = 60000.0;
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit2)) {
            d = 3600000.0;
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit2)) {
            d = 8.64E7;
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported time unit ").append((Object)timeUnit).toString());
        }
        return d;
    }

    public String timeUnitToString(TimeUnit timeUnit) {
        String string;
        TimeUnit timeUnit2 = timeUnit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit2)) {
            string = "ns";
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit2)) {
            string = "us";
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit2)) {
            string = "ms";
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit2)) {
            string = "s";
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit2)) {
            string = "m";
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit2)) {
            string = "h";
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit2)) {
            string = "d";
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported time unit ").append((Object)timeUnit).toString());
        }
        return string;
    }

    public TimeUnit valueOfTimeUnit(String timeUnitString) {
        TimeUnit timeUnit;
        block17: {
            block10: {
                block11: {
                    block12: {
                        block13: {
                            block14: {
                                block15: {
                                    block16: {
                                        String string = timeUnitString;
                                        switch (string == null ? 0 : string.hashCode()) {
                                            case 100: {
                                                if (!"d".equals(string)) break block10;
                                                break block11;
                                            }
                                            case 104: {
                                                if (!"h".equals(string)) break block10;
                                                break block12;
                                            }
                                            case 109: {
                                                if (!"m".equals(string)) break block10;
                                                break block13;
                                            }
                                            case 115: {
                                                if (!"s".equals(string)) break block10;
                                                break block14;
                                            }
                                            case 3494: {
                                                if (!"ms".equals(string)) break block10;
                                                break block15;
                                            }
                                            case 3525: {
                                                if ("ns".equals(string)) {
                                                    break;
                                                }
                                                break block10;
                                            }
                                            case 3742: {
                                                if (!"us".equals(string)) break block10;
                                                break block16;
                                            }
                                            default: {
                                                break block10;
                                            }
                                        }
                                        timeUnit = TimeUnit.NANOSECONDS;
                                        break block17;
                                    }
                                    timeUnit = TimeUnit.MICROSECONDS;
                                    break block17;
                                }
                                timeUnit = TimeUnit.MILLISECONDS;
                                break block17;
                            }
                            timeUnit = TimeUnit.SECONDS;
                            break block17;
                        }
                        timeUnit = TimeUnit.MINUTES;
                        break block17;
                    }
                    timeUnit = TimeUnit.HOURS;
                    break block17;
                }
                timeUnit = TimeUnit.DAYS;
                break block17;
            }
            throw new IllegalArgumentException(new StringBuilder(19).append("Unknown time unit: ").append(timeUnitString).toString());
        }
        return timeUnit;
    }

    public ElapsedTime apply(double value, TimeUnit unit) {
        return new ElapsedTime(value, unit);
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(ElapsedTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)x$0.value()), (Object)x$0.unit()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ElapsedTime$.class);
    }

    public static final /* synthetic */ double $anonfun$new$6(Object x) {
        return ((ElapsedTime)x).value();
    }

    private ElapsedTime$() {
    }
}

