/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.index;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xmeta.Index;

public class FileIndex
extends Index {
    File file;
    Index parent;

    public FileIndex(Index parent, File file) {
        this.parent = parent;
        this.file = file;
    }

    @Override
    public Object getIndexObject() {
        return this.file;
    }

    @Override
    public Index getParent() {
        return this.parent;
    }

    @Override
    public List<Index> getChilds() {
        ArrayList<Index> indexs = new ArrayList<Index>();
        if (this.file.isDirectory()) {
            for (File child : this.file.listFiles()) {
                indexs.add(new FileIndex(this, child));
            }
        }
        return indexs;
    }

    @Override
    public String getDescription() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getLabel() {
        return this.file.getName();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getType() {
        return "file";
    }

    @Override
    public boolean refresh() {
        return true;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }
}

