/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.index;

import java.util.ArrayList;
import java.util.List;
import org.xmeta.Category;
import org.xmeta.Index;
import org.xmeta.ThingManager;
import org.xmeta.World;
import org.xmeta.index.IndexFactory;
import org.xmeta.index.WorldIndex;

public class ThingManagerIndex
extends Index {
    List<Index> childs = null;
    Index parent = null;
    ThingManager thingManager = null;

    public ThingManagerIndex(Index parent, ThingManager thingManager) {
        this.parent = parent;
        this.thingManager = thingManager;
    }

    @Override
    public Object getIndexObject() {
        return this.thingManager;
    }

    @Override
    public Index getParent() {
        return this.parent;
    }

    @Override
    public List<Index> getChilds() {
        if (!this.indexed) {
            this.refresh();
        }
        return this.childs;
    }

    @Override
    public String getDescription() {
        return this.thingManager.getName();
    }

    @Override
    public String getLabel() {
        return this.thingManager.getName();
    }

    @Override
    public String getName() {
        return this.thingManager.getName();
    }

    @Override
    public String getPath() {
        return this.thingManager.getName();
    }

    @Override
    public String getType() {
        return "thingManager";
    }

    @Override
    public boolean refresh() {
        this.indexed = true;
        if (World.getInstance().getThingManager(this.thingManager.getName()) == null) {
            return false;
        }
        if (this.childs == null) {
            this.childs = new ArrayList<Index>();
        }
        this.thingManager.refresh();
        ArrayList<Category> categorys = new ArrayList<Category>();
        for (Category category : this.thingManager.getCategorys()) {
            if (category.getName() == null || "".equals(category.getName())) continue;
            categorys.add(category);
        }
        IndexFactory.addOrRemoveChilds(this, this.childs, categorys, IndexFactory.categoryIndexFactory, "category");
        IndexFactory.addOrRemoveChilds(this, this.childs, this.thingManager.getCategory("").getThingIndexs(), IndexFactory.thingIndexFactory, "thing");
        WorldIndex.sort(this.childs);
        return true;
    }
}

