/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.xmeta.Category;
import org.xmeta.Thing;
import org.xmeta.ThingCoder;
import org.xmeta.ThingMetadata;
import org.xmeta.World;
import org.xmeta.XMetaException;
import org.xmeta.thingManagers.AbstractThingManager;
import org.xmeta.thingManagers.FileCategory;
import org.xmeta.thingManagers.FileMonitor;
import org.xmeta.util.ThingClassLoader;
import org.xmeta.util.UtilFile;

public class FileThingManager
extends AbstractThingManager {
    File thingRootFile = null;
    File rootFile = null;
    boolean hasThingsDir;
    boolean monitor = false;
    ThingClassLoader classLoader = null;

    public FileThingManager(String name, File rootFile) {
        this(name, rootFile, true);
    }

    public FileThingManager(String name, File rootFile, boolean hasThingsDir) {
        super(name);
        this.hasThingsDir = hasThingsDir;
        this.rootFile = rootFile;
        if (hasThingsDir) {
            this.thingRootFile = new File(rootFile, "things");
            World world = World.getInstance();
            this.classLoader = new ThingClassLoader(new URL[0], (ClassLoader)world.getClassLoader());
            this.classLoader.addJarOrZip(new File(rootFile, "lib"));
            this.classLoader.addJarOrZip(new File(rootFile + "/os/lib/lib_" + world.getOS()));
            this.classLoader.addJarOrZip(new File(rootFile + "/os/lib/lib_" + world.getOS() + "_" + world.getJVMBit()));
        } else {
            this.thingRootFile = rootFile;
        }
        this.rootCategory = new FileCategory(null, this, null);
    }

    public boolean hasThingsDir() {
        return this.hasThingsDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Thing doLoadThing(String thingName) {
        try {
            ThingCoder thingCoder;
            File thingFile;
            String thingPath = thingName.replace('.', '/');
            World world = World.getInstance();
            Iterator<ThingCoder> iterator = world.getThingCoders().iterator();
            do {
                if (!iterator.hasNext()) return null;
                thingCoder = iterator.next();
            } while (!(thingFile = new File(this.thingRootFile, thingPath + "." + thingCoder.getType())).exists());
            try (FileInputStream fin = new FileInputStream(thingFile);){
                Thing thing = new Thing(null, null, null, false);
                ThingMetadata metadata = thing.getMetadata();
                metadata.setPath(thingName);
                String category = null;
                String thingFileName = thingName;
                int lastDotIndex = thingName.lastIndexOf(".");
                if (lastDotIndex != -1) {
                    category = thingName.substring(0, lastDotIndex);
                    thingFileName = thingName.substring(lastDotIndex + 1, thingName.length());
                }
                metadata.setCategory(this.getCategory(category, true));
                metadata.setCoderType(thingCoder.getType());
                metadata.setReserve(thingFileName);
                thingCoder.decode(thing, fin, thingFile.lastModified());
                FileMonitor.getInstance().addFile(thingName, thing, thingFile, this.monitor);
                Thing thing2 = thing;
                return thing2;
            }
        }
        catch (Exception e) {
            throw new XMetaException("load thing from FileThingManager error, managePath=" + this.rootFile + ",thing=" + thingName, e);
        }
    }

    @Override
    public boolean doRemoveThing(Thing thing) {
        Thing rootThing = thing.getRoot();
        if (rootThing.getMetadata().getThingManager() == this) {
            File thingFile = new File(this.thingRootFile, rootThing.getMetadata().getPath().replace('.', '/') + "." + thing.getMetadata().getCoderFileType());
            if (thingFile.exists()) {
                thingFile.delete();
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doSaveThing(Thing thing) {
        Thing rootThing = thing.getRoot();
        String rootThingPath = rootThing.getMetadata().getPath();
        FileMonitor.FileEntry fileEntry = FileMonitor.getInstance().getFileEntry(rootThingPath);
        if (fileEntry != null) {
            fileEntry.check = false;
        }
        try {
            if (rootThing.getMetadata().getThingManager() == this) {
                ThingCoder thingCoder = World.getInstance().getThingCoder(rootThing.getMetadata().getCoderType());
                File thingFile = new File(this.thingRootFile, rootThingPath.replace('.', '/') + "." + thingCoder.getType());
                if (!thingFile.exists()) {
                    thingFile.getParentFile().mkdirs();
                }
                try (FileOutputStream fout = new FileOutputStream(thingFile);){
                    thingCoder.encode(rootThing, fout);
                    fout.flush();
                }
                thingFile.setLastModified(rootThing.getMetadata().getLastModified());
                if (fileEntry != null) {
                    fileEntry.lastModified = thingFile.lastModified();
                } else {
                    FileMonitor.getInstance().addFile(rootThingPath, rootThing, thingFile, this.monitor);
                }
            }
            boolean bl = true;
            if (fileEntry != null) {
                fileEntry.check = true;
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (fileEntry != null) {
                    fileEntry.check = true;
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XMetaException("save thing by FileThingManager error, managePath=" + this.thingRootFile + ",thing=" + thing.getMetadata().getPath(), e);
            }
        }
    }

    @Override
    public boolean createCategory(String categoryName) {
        if (categoryName == null || categoryName.equals("")) {
            return false;
        }
        if (this.getCategory(categoryName) != null) {
            return true;
        }
        File dir = new File(this.thingRootFile, categoryName.replace('.', '/'));
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                this.refreshParentCategory(categoryName);
                return true;
            }
            return false;
        }
        this.refreshParentCategory(categoryName);
        return true;
    }

    @Override
    public ThingClassLoader getClassLoader() {
        return World.getInstance().getClassLoader();
    }

    @Override
    public void refresh() {
        this.rootCategory.refresh(false);
    }

    @Override
    public boolean remove() {
        UtilFile.delete(this.rootFile);
        return true;
    }

    @Override
    public boolean removeCategory(String categoryName) {
        if (categoryName == null || categoryName.equals("")) {
            return false;
        }
        Category category = this.getCategory(categoryName);
        if (category == null) {
            return true;
        }
        Category parent = category.getParent();
        File dir = new File(this.thingRootFile + "/" + categoryName.replace('.', '/'));
        UtilFile.delete(dir);
        if (parent != null) {
            parent.refresh();
        }
        return true;
    }

    public String getFilePath() {
        return this.thingRootFile.getAbsolutePath();
    }

    public File getThingRootFile() {
        return this.thingRootFile;
    }

    public File getRootFile() {
        return this.rootFile;
    }

    @Override
    public String getClassPath() {
        return World.getInstance().getClassLoader().getClassPath();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        File resource = new File(this.thingRootFile, name);
        if (resource.exists() && resource.isFile()) {
            try {
                return new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                throw new XMetaException("get resource from fileThingManager error, resource=" + name + ", thingManager=" + this.rootFile, e);
            }
        }
        return this.getClassLoader().getResourceAsStream(name);
    }

    @Override
    public URL findResource(String name) {
        File file = new File(this.thingRootFile, name);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new XMetaException("FileThingManager find resource error, thingManager=" + name, e);
            }
        }
        return null;
    }

    public String toString() {
        return "FileThingManger[name:" + this.getName() + ", rootFile: " + this.rootFile.getAbsolutePath() + "]";
    }

    @Override
    public boolean isSaveable() {
        return true;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean monitor) {
        this.monitor = monitor;
    }
}

