/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.thingManagers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.xmeta.ActionException;
import org.xmeta.Category;
import org.xmeta.ThingIndex;
import org.xmeta.ThingManager;
import org.xmeta.thingManagers.CachedCategory;
import org.xmeta.thingManagers.JdbcThingManager;

public class JdbcCategory
extends CachedCategory {
    public JdbcCategory(String name, ThingManager thingManager, Category parent) {
        super(thingManager, parent, name);
        this.refresh();
    }

    @Override
    public String getFilePath() {
        return null;
    }

    public Connection getConnection() {
        return ((JdbcThingManager)this.thingManager).getConnection();
    }

    @Override
    public void refresh() {
        Connection con = this.getConnection();
        if (con == null) {
            return;
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            boolean have;
            pst = con.prepareStatement("select simpleName from tblCategorys where parent=?");
            pst.setString(1, this.name == null ? "" : this.name);
            rs = pst.executeQuery();
            HashSet<String> categorys = new HashSet<String>();
            while (rs.next()) {
                categorys.add(rs.getString("simpleName"));
            }
            ArrayList<String> childNames = new ArrayList<String>();
            for (String path : categorys) {
                if (path.indexOf(".") != -1) continue;
                childNames.add(path);
                have = false;
                for (Category category : this.childCategorys) {
                    if (!category.getSimpleName().equals(path)) continue;
                    have = true;
                    break;
                }
                if (have) continue;
                Object newCategoryPath = path;
                if (this.name != null && !"".equals(this.name)) {
                    newCategoryPath = this.name + "." + path;
                }
                JdbcCategory jdbcCategory = new JdbcCategory((String)newCategoryPath, this.getThingManager(), this);
                this.childCategorys.add(jdbcCategory);
            }
            for (int i = 0; i < this.childCategorys.size(); ++i) {
                Category category = (Category)this.childCategorys.get(i);
                have = false;
                for (String string : childNames) {
                    if (!string.equals(category.getSimpleName())) continue;
                    have = true;
                    break;
                }
                if (have) continue;
                this.childCategorys.remove(i);
                --i;
            }
            String thingPath = null;
            thingPath = this.name == null || "".equals(this.name) ? "" : this.name;
            rs.close();
            pst.close();
            pst = con.prepareStatement("select * from tblThings where category=?");
            pst.setString(1, thingPath);
            rs = pst.executeQuery();
            while (rs.next()) {
                String path;
                path = rs.getString("path");
                int index = path.lastIndexOf(".");
                if (index != -1) {
                    path = path.substring(index + 1, path.length());
                }
                if (path.indexOf(".") != -1) continue;
                childNames.add(path);
                boolean have2 = false;
                for (ThingIndex thingIndex : this.thingIndexs) {
                    if (!thingIndex.getName().equals(path)) continue;
                    have2 = true;
                    break;
                }
                if (have2) continue;
                ThingIndex thingIndex = new ThingIndex();
                thingIndex.name = path;
                thingIndex.path = this.name != null && !"".equals(this.name) ? this.name + "." + path : path;
                thingIndex.thingManager = this.thingManager;
                thingIndex.lastModified = rs.getLong("lastModified");
                thingIndex.descriptors = rs.getString("descriptors");
                thingIndex.label = rs.getString("label");
                this.thingIndexs.add(thingIndex);
            }
            for (int i = 0; i < this.thingIndexs.size(); ++i) {
                ThingIndex thingIndex = (ThingIndex)this.thingIndexs.get(i);
                boolean have3 = false;
                for (String path : childNames) {
                    if (!path.equals(thingIndex.getName())) continue;
                    have3 = true;
                    break;
                }
                if (have3) continue;
                this.thingIndexs.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            throw new ActionException("Refresh category error, thingManager=" + this.name, e);
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void refresh(boolean includeChild) {
        this.refresh();
        if (includeChild) {
            for (Category child : this.childCategorys) {
                child.refresh(includeChild);
            }
        }
    }
}

