/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.ui.session;

import java.util.ArrayList;
import java.util.List;
import org.xmeta.ActionContext;
import org.xmeta.ui.session.DefaultSessionManager;
import org.xmeta.ui.session.Session;

public abstract class SessionManager {
    private static SessionManager defaultSessionManager = new DefaultSessionManager();
    private static List<SessionManager> sessionManagers = new ArrayList<SessionManager>();
    private static ThreadLocal<SessionManager> sessionManagerLocal = new ThreadLocal();

    public static Session getSession(ActionContext actionContext) {
        return SessionManager.getSessionManager(actionContext).get(actionContext);
    }

    public static Session remove(ActionContext actionContext) {
        return SessionManager.getSessionManager(actionContext).delete(actionContext);
    }

    public static void registSessionManager(SessionManager sessionManager) {
        if (!sessionManagers.contains(sessionManager)) {
            sessionManagers.add(sessionManager);
        }
    }

    public static List<SessionManager> getSessionManagers() {
        return sessionManagers;
    }

    public static SessionManager getSessionManager(ActionContext actionContext) {
        SessionManager sessionManager = sessionManagerLocal.get();
        if (sessionManager != null) {
            return sessionManager;
        }
        for (SessionManager sm : sessionManagers) {
            if (!sm.accept(actionContext)) continue;
            return sm;
        }
        return defaultSessionManager;
    }

    public static void setLocalSessionManager(SessionManager sessionManager) {
        sessionManagerLocal.set(sessionManager);
    }

    public static SessionManager getDefaultSessionManager() {
        return defaultSessionManager;
    }

    public abstract Session get(ActionContext var1);

    public abstract Session delete(ActionContext var1);

    public abstract boolean accept(ActionContext var1);
}

