/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.util.Locale;
import java.util.ResourceBundle;
import org.xmeta.World;

public class Resources {
    ResourceBundle messages;
    Locale locale;
    String name;
    ClassLoader bundleLoader;

    public Resources(String name, Locale local) {
        this.name = name;
        if (local == null) {
            local = Locale.getDefault();
        }
        this.locale = local;
        this.messages = ResourceBundle.getBundle(name, local, World.getInstance().getClassLoader());
        this.bundleLoader = World.getInstance().getClassLoader();
    }

    public String get(String name) {
        try {
            return this.messages.getString(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String get(String name, String defaultValue) {
        String message = this.get(name);
        if (message == null) {
            return defaultValue;
        }
        return message;
    }

    public void clear() {
        ResourceBundle.clearCache(this.bundleLoader);
    }
}

