/*
 * Decompiled with CFR 0.152.
 */
package org.xmeta.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.xmeta.ActionContext;
import org.xmeta.Thing;
import org.xmeta.World;
import org.xmeta.ui.session.Session;
import org.xmeta.ui.session.SessionManager;
import org.xmeta.util.OgnlUtil;
import org.xmeta.util.UtilResource;

public class UtilString {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String[] getGroovyStringArray(String str) {
        if (str.startsWith("[") && str.endsWith("as String[]")) {
            str = str.substring(1, str.lastIndexOf("]", str.length() - 3));
        }
        String[] strs = str.split("[,]");
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = strs[i].trim();
            if (!strs[i].startsWith("\"") || !strs[i].endsWith("\"")) continue;
            strs[i] = strs[i].substring(1, strs[i].length() - 1);
        }
        return strs;
    }

    public static boolean eq(Thing thing, String attributeName, String value) {
        String attrValue = thing.getString(attributeName);
        return attrValue != null && attrValue.equals(value);
    }

    public static boolean isNull(Thing thing, String attributeName) {
        Object value = thing.getAttribute(attributeName);
        return value == null || value instanceof String && "".equals(value);
    }

    public static String[] split(String str, char ch) {
        String[] nstrs;
        int index2;
        char[] chs = str.toCharArray();
        String[] strs = new String[10];
        int strIndex = 0;
        int index1 = 0;
        for (index2 = 0; index2 < chs.length; ++index2) {
            if (chs[index2] != ch) continue;
            strs[strIndex] = new String(chs, index1, index2 - index1);
            index1 = index2 + 1;
            if (++strIndex < strs.length) continue;
            nstrs = new String[strs.length + 10];
            System.arraycopy(strs, 0, nstrs, 0, strs.length);
            strs = nstrs;
        }
        if (index1 <= index2) {
            strs[strIndex] = new String(chs, index1, index2 - index1);
            if (++strIndex >= strs.length) {
                nstrs = new String[strs.length + 10];
                System.arraycopy(strs, 0, nstrs, 0, strs.length);
                strs = nstrs;
            }
        }
        String[] fstrs = new String[strIndex];
        System.arraycopy(strs, 0, fstrs, 0, strIndex);
        return fstrs;
    }

    public static boolean haveDescriptor(String descriptors, String descriptor) {
        String[] descs;
        if (descriptors == null) {
            return false;
        }
        for (String desc : descs = descriptors.split("[,]")) {
            if (!desc.equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public static String insert(String source, String forInsert, int index) {
        if (forInsert == null || "".equals(forInsert)) {
            return source;
        }
        if (source != null && !"".equals(source)) {
            String[] srouces = source.split("[,]");
            source = "";
            int i = 0;
            boolean added = false;
            for (String src : srouces) {
                if (index == i) {
                    source = source + "," + forInsert;
                    added = true;
                }
                if (!src.equals(forInsert)) {
                    source = source + "," + src;
                }
                ++i;
            }
            if (!added) {
                source = source + "," + forInsert;
            }
            if (source.startsWith(",")) {
                source = source.substring(1, source.length());
            }
            return source;
        }
        return forInsert;
    }

    public static Object createObjectFromParams(String params, String thingPath, ActionContext actionContext) {
        if (params == null || "".equals(params)) {
            return null;
        }
        Map<String, String> values = UtilString.getParams(params);
        return UtilString.createObjectFromParams(values, thingPath, actionContext);
    }

    public static Object createObjectFromParams(Map<String, ?> values, String thingPath, ActionContext actionContext) {
        Thing thing = World.getInstance().getThing(thingPath);
        if (thing != null) {
            Thing vthing = new Thing(thingPath);
            vthing.getAttributes().putAll(values);
            return vthing.doAction("create", actionContext);
        }
        return null;
    }

    public static boolean isNotNull(String str) {
        return str != null && !"".equals(str);
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str);
    }

    public static String capFirst(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static String uncapFirst(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }

    public static void debug(ActionContext context, Object obj) {
        System.out.println(context);
        System.out.println(obj);
        System.out.println(context.get("parent"));
    }

    public static String[] getStringArray(String strArray) {
        if (strArray == null) {
            return null;
        }
        String[] ints = strArray.split("[,]");
        String[] is = new String[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            is[i] = ints[i].trim();
        }
        return is;
    }

    public static int[] toIntArray(String intArray) {
        if (intArray == null || "".equals(intArray)) {
            return null;
        }
        String[] ints = intArray.split("[,]");
        int[] is = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            is[i] = Integer.parseInt(ints[i].trim());
        }
        return is;
    }

    public static Map<String, String> getParams(String str) {
        return UtilString.getParams(str, "&", "utf-8", true);
    }

    public static Map<String, String> getParams(String str, String splitStr) {
        return UtilString.getParams(str, splitStr, "utf-8", true);
    }

    public static Map<String, String> getParams(String str, String splitStr, String encoding) {
        return UtilString.getParams(str, splitStr, encoding, true);
    }

    public static Map<String, String> getParams(String str, String splitStr, String encoding, boolean trimQuotate) {
        int i;
        if (str == null || "".equals(str)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> paras = new HashMap<String, String>();
        String[] ps = str.split("[" + splitStr + "]");
        if ("&".equals(splitStr)) {
            for (i = 0; i < ps.length - 1; ++i) {
                if (!ps[i + 1].startsWith("amp;")) continue;
                ps[i] = ps[i] + "&" + ps[i + 1].substring(4, ps[i + 1].length());
                ps[i + 1] = null;
            }
        }
        for (i = 0; i < ps.length; ++i) {
            int index;
            if (ps[i] == null || (index = ps[i].indexOf("=")) == -1 || index == 0 || index == ps[i].length()) continue;
            String name = ps[i].substring(0, index);
            String value = ps[i].substring(index + 1, ps[i].length());
            try {
                value = URLDecoder.decode(value, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (trimQuotate) {
                if (value.startsWith("\"") || value.startsWith("'")) {
                    value = value.substring(1, value.length());
                }
                if (value.endsWith("\"") || value.endsWith("'")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
            paras.put(name.trim(), value);
        }
        return paras;
    }

    public static int getInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getString(Thing thing, String attribute, ActionContext actionContext) {
        String value = thing.getString(attribute);
        return UtilString.getString(value, actionContext);
    }

    public static String getString(String value, ActionContext actionContext) {
        if (value == null) {
            return "";
        }
        if ((value = value.trim()).startsWith("res:")) {
            String svalue;
            Session session = SessionManager.getSession(actionContext);
            UtilResource resource = session.getI18nResource();
            String[] resStrs = value.split("[:]");
            String defaultValue = "";
            if (resStrs.length >= 4) {
                defaultValue = resStrs[3];
            }
            if ((svalue = resource.get(resStrs[1], resStrs[2], defaultValue)) == null) {
                return defaultValue;
            }
            return svalue;
        }
        if (value.startsWith("label:")) {
            String thingPath = value.substring(6, value.length());
            Thing labelThing = World.getInstance().getThing(thingPath);
            if (labelThing == null) {
                return thingPath;
            }
            return labelThing.getMetadata().getLabel(actionContext);
        }
        if (value.startsWith("desc:")) {
            String thingPath = value.substring(5, value.length());
            Thing labelThing = World.getInstance().getThing(thingPath);
            if (labelThing == null) {
                return thingPath;
            }
            return World.getInstance().getThing(thingPath).getMetadata().getDescription();
        }
        if (value.startsWith("attr:")) {
            String thingPath = value.substring(5, value.length());
            Object obj = World.getInstance().get(thingPath);
            if (obj != null) {
                return String.valueOf(obj);
            }
            return thingPath;
        }
        if (value.startsWith("ognl:")) {
            String exp = value.substring(5, value.length());
            Object obj = null;
            obj = OgnlUtil.getValue(exp, (Object)actionContext);
            if (obj != null) {
                return String.valueOf(obj);
            }
            return null;
        }
        if (value.startsWith("xworker:")) {
            String path = value.substring(8, value.length());
            return World.getInstance().getPath() + "/" + path;
        }
        if (value.startsWith("world:")) {
            String path = value.substring(6, value.length());
            return World.getInstance().getPath() + "/" + path;
        }
        if (value.startsWith("var:")) {
            String path = value.substring(4, value.length());
            Object obj = actionContext.get(path);
            if (obj instanceof Thing) {
                return ((Thing)obj).getMetadata().getPath();
            }
            if (obj == null) {
                return null;
            }
            return String.valueOf(obj);
        }
        if (value.startsWith("\":")) {
            if ((value = value.substring(2, value.length())).length() > 1) {
                value = value.substring(0, value.length() - 1);
            }
        } else if (value.startsWith("lang:")) {
            Session session;
            Locale locale;
            String language;
            value = value.substring(5, value.length());
            Map<String, String> params = UtilString.getParams(value);
            if ((value = params.get(language = (locale = (session = SessionManager.getSession(actionContext)).getLocale()).getLanguage())) == null) {
                value = params.get("d");
            }
            if (value == null) {
                value = params.get("default");
            }
        }
        String v = value;
        return v;
    }

    public static String toUnicode(String theString, boolean escapeSpace) {
        if (theString == null) {
            return "";
        }
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(UtilString.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(UtilString.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(UtilString.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(UtilString.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String trimFileName(String str) {
        str = str.replace('/', '_');
        str = str.replace('\\', '_');
        str = str.replace('.', '_');
        str = str.replace('?', '_');
        if ((str = str.replace(':', '_')).length() > 30) {
            str = str.substring(0, 5) + "_" + str.substring(str.length() - 25, str.length()) + "_" + str.hashCode();
        }
        return str;
    }

    public static String getThingManagerFileName(Thing thing) {
        String fileManagerName = thing.getMetadata().getThingManager().getName();
        fileManagerName = fileManagerName == null ? "null" : UtilString.trimFileName(fileManagerName);
        return fileManagerName;
    }

    public static String toHexString(byte[] bytes) {
        char[] buf = new char[bytes.length * 2];
        int radix = 16;
        int mask = radix - 1;
        for (int i = 0; i < bytes.length; ++i) {
            buf[2 * i] = hexDigit[bytes[i] >>> 4 & mask];
            buf[2 * i + 1] = hexDigit[bytes[i] & mask];
        }
        return new String(buf);
    }

    public static byte[] hexStringToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int stringLength = hex.length();
        if (stringLength % 2 != 0) {
            throw new IllegalArgumentException("Hex String must have even number of characters!");
        }
        byte[] result = new byte[stringLength / 2];
        int j = 0;
        for (int i = 0; i < result.length; ++i) {
            char hi = Character.toLowerCase(hex.charAt(j++));
            char lo = Character.toLowerCase(hex.charAt(j++));
            result[i] = (byte)(Character.digit(hi, 16) << 4 | Character.digit(lo, 16));
        }
        return result;
    }

    public static String getSizeInfo(double size) {
        DecimalFormat sf = new DecimalFormat("#.##");
        if (size < 1024.0) {
            return String.valueOf(size) + "B";
        }
        if (size < 1048576.0) {
            return sf.format(size / 1024.0) + "KB";
        }
        if (size < 1.073741824E9) {
            return sf.format(size / 1024.0 / 1024.0) + "MB";
        }
        return sf.format(size / 1024.0 / 1024.0 / 1025.0) + "G";
    }
}

