/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xbib.content.io.BytesReference;
import org.xbib.content.io.BytesStreamOutput;
import org.xbib.content.rdf.RdfContent;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.RdfContentParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.resource.IRI;

public class RdfContentBuilder<P extends RdfContentParams>
implements RdfContentGenerator<P> {
    private final RdfContentGenerator<P> generator;
    private final OutputStream out;
    private IRI subject;

    public RdfContentBuilder(RdfContent<P> rdfContent, P rdfParams) throws IOException {
        this(rdfContent, rdfParams, (OutputStream)new BytesStreamOutput());
    }

    public RdfContentBuilder(RdfContent<P> rdfContent, P rdfContentParams, OutputStream out) throws IOException {
        this.out = out;
        this.generator = rdfContent.createGenerator(out);
        this.generator.setParams(rdfContentParams);
    }

    @Override
    public P getParams() {
        return this.generator.getParams();
    }

    @Override
    public RdfContentBuilder<P> setParams(P rdfContentParams) {
        this.generator.setParams(rdfContentParams);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }

    public BytesReference bytes() throws IOException {
        this.close();
        return ((BytesStreamOutput)this.out).bytes();
    }

    public InputStream streamInput() throws IOException {
        return this.bytes().streamInput();
    }

    public String string() throws IOException {
        return this.bytes().toUtf8();
    }

    @Override
    public RdfContentBuilder<P> startStream() throws IOException {
        this.generator.startStream();
        return this;
    }

    @Override
    public RdfContentBuilder<P> endStream() throws IOException {
        this.generator.endStream();
        return this;
    }

    @Override
    public RdfContentBuilder<P> setBaseUri(String baseUri) {
        this.generator.startPrefixMapping("", baseUri);
        return this;
    }

    @Override
    public RdfContentBuilder<P> startPrefixMapping(String prefix, String uri) {
        this.generator.startPrefixMapping(prefix, uri);
        return this;
    }

    @Override
    public RdfContentBuilder<P> endPrefixMapping(String prefix) {
        this.generator.endPrefixMapping(prefix);
        return this;
    }

    @Override
    public RdfContentBuilder<P> receive(IRI identifier) throws IOException {
        this.subject = identifier;
        this.generator.receive(identifier);
        return this;
    }

    @Override
    public RdfContentBuilder<P> receive(Triple triple) throws IOException {
        this.generator.receive(triple);
        return this;
    }

    @Override
    public RdfContentBuilder<P> receive(Resource resource) throws IOException {
        this.generator.receive(resource);
        return this;
    }

    public IRI getSubject() {
        return this.subject;
    }
}

