/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xbib.content.XContent;
import org.xbib.content.XContentBuilder;
import org.xbib.content.json.JsonXContent;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.RdfXContentParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class RdfXContentGenerator<P extends RdfXContentParams>
implements RdfContentGenerator<P> {
    protected final OutputStream out;
    protected Resource resource;
    protected XContentBuilder builder;
    private P params;
    private boolean flushed;

    RdfXContentGenerator(OutputStream out) {
        this.out = out;
    }

    @Override
    public P getParams() {
        return this.params;
    }

    @Override
    public RdfXContentGenerator<P> setParams(P rdfContentParams) {
        this.params = rdfContentParams;
        ((RdfXContentParams)this.params).setGenerator(this);
        return null;
    }

    @Override
    public RdfXContentGenerator<P> startStream() {
        this.resource = new DefaultAnonymousResource();
        this.flushed = false;
        return this;
    }

    @Override
    public RdfContentGenerator<P> setBaseUri(String baseUri) {
        this.startPrefixMapping("", baseUri);
        return this;
    }

    @Override
    public RdfXContentGenerator<P> startPrefixMapping(String prefix, String uri) {
        ((RdfXContentParams)this.params).getNamespaceContext().addNamespace(prefix, uri);
        return this;
    }

    @Override
    public RdfXContentGenerator<P> endPrefixMapping(String prefix) {
        return this;
    }

    @Override
    public RdfXContentGenerator<P> receive(IRI identifier) throws IOException {
        this.resource = new DefaultResource(identifier);
        this.flushed = false;
        return this;
    }

    @Override
    public RdfXContentGenerator<P> receive(Triple triple) {
        this.resource.add(triple);
        return this;
    }

    @Override
    public RdfXContentGenerator<P> endStream() throws IOException {
        if (this.resource != null && !this.resource.isEmpty()) {
            this.flush();
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.resource == null || this.resource.isEmpty() || this.flushed) {
            return;
        }
        this.flushed = true;
        this.builder = XContentBuilder.builder((XContent)JsonXContent.jsonContent(), (OutputStream)this.out);
        this.builder.startObject();
        this.build(this.resource);
        this.builder.endObject();
    }

    @Override
    public RdfXContentGenerator<P> receive(Resource resource) throws IOException {
        if (resource != null) {
            this.resource = resource;
        }
        this.flush();
        return this;
    }

    public String string() {
        if (this.builder != null) {
            return this.builder.string();
        }
        return null;
    }

    public String get() {
        return this.string();
    }

    public void filter(IRI predicate, Node object) {
    }

    protected void build(Resource resource) throws IOException {
        if (resource == null) {
            return;
        }
        for (IRI predicate : resource.predicates()) {
            ArrayList<Object> values = new ArrayList<Object>(32);
            List<Node> nodes = resource.externalObjects(predicate);
            for (Node node : nodes) {
                Object o;
                if (node instanceof Resource) {
                    values.add(((Resource)node).id().toString());
                } else if (node instanceof Literal && (o = ((Literal)node).object()) != null) {
                    values.add(o);
                }
                this.filter(predicate, node);
            }
            if (values.size() == 1) {
                this.builder.field(((RdfXContentParams)this.params).getNamespaceContext().compact(predicate), values.get(0));
            } else if (values.size() > 1) {
                this.builder.array(((RdfXContentParams)this.params).getNamespaceContext().compact(predicate), values);
            }
            Collection<Resource> resources = resource.embeddedResources(predicate);
            if (resources.size() == 1) {
                Resource res = resources.iterator().next();
                if (res.isEmpty()) continue;
                this.builder.field(((RdfXContentParams)this.params).getNamespaceContext().compact(predicate));
                this.builder.startObject();
                this.build(res);
                this.builder.endObject();
                continue;
            }
            if (resources.size() <= 1) continue;
            this.builder.field(((RdfXContentParams)this.params).getNamespaceContext().compact(predicate));
            this.builder.startArray();
            for (Resource res : resources) {
                if (res.isEmpty()) continue;
                this.builder.startObject();
                this.build(res);
                this.builder.endObject();
            }
            this.builder.endArray();
        }
    }
}

