/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf;

import java.io.IOException;
import java.io.OutputStream;
import org.xbib.content.rdf.RdfXContentGenerator;
import org.xbib.content.rdf.RouteRdfXContent;
import org.xbib.content.rdf.RouteRdfXContentParams;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class RouteRdfXContentGenerator<R extends RouteRdfXContentParams>
extends RdfXContentGenerator<R> {
    private boolean flushed;

    RouteRdfXContentGenerator(OutputStream out) throws IOException {
        super(out);
    }

    @Override
    public RdfXContentGenerator<R> startStream() {
        super.startStream();
        this.flushed = false;
        return this;
    }

    @Override
    public RdfXContentGenerator<R> receive(IRI identifier) throws IOException {
        super.receive(identifier);
        this.flushed = false;
        return this;
    }

    @Override
    public void flush() throws IOException {
        String s;
        super.flush();
        if (this.flushed) {
            return;
        }
        this.flushed = true;
        RouteRdfXContent.RouteHandler handler = ((RouteRdfXContentParams)this.getParams()).getHandler();
        if (handler != null && (s = ((RouteRdfXContentParams)this.getParams()).getGenerator().get()) != null && !s.isEmpty()) {
            if (this.resource.id() != null) {
                ((RouteRdfXContentParams)this.getParams()).setId(this.resource.id().toString());
            }
            handler.complete(s, (RouteRdfXContentParams)this.getParams());
        }
    }

    @Override
    public void filter(IRI predicate, Node object) {
        String idPredicate;
        String typePredicate;
        String indexPredicate = ((RouteRdfXContentParams)this.getParams()).getIndexPredicate();
        if (indexPredicate != null && indexPredicate.equals(predicate.toString())) {
            ((RouteRdfXContentParams)this.getParams()).setIndex(object.toString());
        }
        if ((typePredicate = ((RouteRdfXContentParams)this.getParams()).getIdPredicate()) != null && typePredicate.equals(predicate.toString())) {
            ((RouteRdfXContentParams)this.getParams()).setType(object.toString());
        }
        if ((idPredicate = ((RouteRdfXContentParams)this.getParams()).getIdPredicate()) != null && idPredicate.equals(predicate.toString())) {
            ((RouteRdfXContentParams)this.getParams()).setId(object.toString());
        }
    }
}

