/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.internal;

import org.xbib.content.rdf.Literal;
import org.xbib.content.resource.IRI;

public class DefaultLiteral
implements Literal,
Comparable<Literal> {
    private Object value;
    private IRI type;
    private String lang;

    public DefaultLiteral(Object value) {
        this.value = value;
    }

    private static boolean equalObject(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Override
    public DefaultLiteral object(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public DefaultLiteral type(IRI type) {
        this.type = type;
        return this;
    }

    @Override
    public IRI type() {
        return this.type;
    }

    @Override
    public DefaultLiteral lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public String lang() {
        return this.lang;
    }

    @Override
    public int compareTo(Literal that) {
        if (this == that) {
            return 0;
        }
        return this.toString().compareTo(that.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Literal)) {
            return false;
        }
        Literal that = (Literal)obj;
        return DefaultLiteral.equalObject(this.value, that.object()) && DefaultLiteral.equalObject(this.lang, that.lang()) && DefaultLiteral.equalObject(this.type, that.type());
    }

    public int hashCode() {
        return (this.value + this.lang + this.type).hashCode();
    }

    public String toString() {
        return this.lexicalValue();
    }

    public String lexicalValue() {
        return (this.value != null ? this.value : "") + (this.lang != null ? "@" + this.lang : "") + (this.type != null ? "^^" + this.type : "");
    }

    @Override
    public Object object() {
        if (this.type == null || this.value == null) {
            return this.value;
        }
        String s = this.value.toString();
        try {
            switch (this.type.toString()) {
                case "xsd:long": {
                    return Long.parseLong(s);
                }
                case "xsd:int": {
                    return Integer.parseInt(s);
                }
                case "xsd:gYear": {
                    return Integer.parseInt(s);
                }
                case "xsd:boolean": {
                    return Boolean.parseBoolean(s);
                }
                case "xsd:float": {
                    return Float.valueOf(Float.parseFloat(s));
                }
                case "xsd:double": {
                    return Double.parseDouble(s);
                }
            }
            return s;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isEmbedded() {
        return false;
    }
}

