/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.RdfGraph;
import org.xbib.content.rdf.RdfGraphParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.internal.DefaultRdfGraphParams;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.rdf.internal.DefaultTriple;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.Node;

public class DefaultRdfGraph
implements RdfGraph<RdfGraphParams> {
    private static final Logger logger = Logger.getLogger(DefaultRdfGraph.class.getName());
    private RdfGraphParams params = DefaultRdfGraphParams.DEFAULT_PARAMS;
    private Map<IRI, Resource> resources = new LinkedHashMap<IRI, Resource>();

    @Override
    public Iterator<Resource> getResources() {
        return this.resources.values().stream().iterator();
    }

    @Override
    public RdfGraph<RdfGraphParams> putResource(IRI id, Resource resource) {
        this.resources.put(id, resource);
        return this;
    }

    @Override
    public Resource getResource(IRI predicate) {
        return this.resources.get(predicate);
    }

    @Override
    public Resource removeResource(IRI predicate) {
        return this.resources.remove(predicate);
    }

    @Override
    public boolean hasResource(IRI predicate) {
        return this.resources.containsKey(predicate);
    }

    @Override
    public RdfGraphParams getParams() {
        return this.params;
    }

    public DefaultRdfGraph setParams(RdfGraphParams params) {
        this.params = params;
        return this;
    }

    public DefaultRdfGraph startStream() {
        return this;
    }

    @Override
    public RdfContentGenerator<RdfGraphParams> setBaseUri(String baseUri) {
        this.startPrefixMapping("", baseUri);
        return this;
    }

    public DefaultRdfGraph startPrefixMapping(String prefix, String uri) {
        this.params.getNamespaceContext().addNamespace(prefix, uri);
        return this;
    }

    public DefaultRdfGraph endPrefixMapping(String prefix) {
        return this;
    }

    public DefaultRdfGraph receive(IRI identifier) {
        return this;
    }

    public DefaultRdfGraph receive(Triple triple) {
        IRI subject = triple.subject().id();
        if (!this.resources.containsKey(subject)) {
            this.resources.put(subject, new DefaultResource(subject));
        }
        this.resources.get(subject).add(triple);
        return this;
    }

    public DefaultRdfGraph endStream() {
        return this;
    }

    public DefaultRdfGraph receive(Resource resource) throws IOException {
        this.resources.put(resource.id(), resource);
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    public Resource expand(Resource resource) {
        DefaultResource expanded = new DefaultResource(resource.id());
        new GraphTriples(resource).triples.forEach(expanded::add);
        return expanded;
    }

    private class GraphTriples {
        private final List<Triple> triples;

        GraphTriples(Resource resource) {
            this.triples = this.unfold(resource);
        }

        private List<Triple> unfold(Resource resource) {
            LinkedList<Triple> list = new LinkedList<Triple>();
            if (resource == null) {
                return list;
            }
            resource.predicates().forEach(pred -> resource.objects((IRI)pred).forEach(node -> {
                if (node instanceof Resource) {
                    Resource resource1 = (Resource)node;
                    if (resource1.isEmbedded()) {
                        Resource r = DefaultRdfGraph.this.getResource(resource1.id());
                        if (r != null) {
                            list.add(new DefaultTriple(resource1, (IRI)pred, (Node)r.id()));
                            list.addAll(this.unfold(r));
                        } else {
                            logger.log(Level.SEVERE, "huh? {}", resource1.id());
                        }
                    } else {
                        list.addAll(this.unfold(resource1));
                    }
                } else {
                    list.add(new DefaultTriple(resource, (IRI)pred, (Node)node));
                }
            }));
            return list;
        }
    }
}

