/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.xbib.content.rdf.Literal;
import org.xbib.content.rdf.RdfConstants;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.XSDResourceIdentifiers;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultLiteral;
import org.xbib.content.rdf.internal.DefaultTriple;
import org.xbib.content.rdf.util.LinkedHashMultiMap;
import org.xbib.content.rdf.util.MultiMap;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.IRINamespaceContext;
import org.xbib.content.resource.Node;

public class DefaultResource
implements Resource,
Comparable<Resource>,
XSDResourceIdentifiers {
    static final String GENID = "genid";
    static final String PLACEHOLDER = "_:";
    private static final Logger logger = Logger.getLogger(DefaultResource.class.getName());
    private static final String UNDERSCORE = "_";
    private final MultiMap<IRI, Node> attributes;
    private final Map<IRI, Resource> children;
    private IRI iri;
    private boolean embedded;
    private boolean deleted;

    public DefaultResource(IRI iri) {
        this(iri, new LinkedHashMultiMap<IRI, Node>(), new LinkedHashMap<IRI, Resource>());
    }

    public DefaultResource(DefaultResource resource) {
        this(resource.id(), resource.getAttributes(), resource.getChildren());
        this.deleted = resource.isDeleted();
    }

    public DefaultResource(IRI iri, MultiMap<IRI, Node> attributes, Map<IRI, Resource> children) {
        this.setId(iri);
        this.attributes = attributes;
        this.children = children;
    }

    public static Resource create(String id) {
        return new DefaultResource(IRI.builder().curie(id).build());
    }

    public static Resource create(IRINamespaceContext context, String id) {
        return new DefaultResource(context.expandIRI(IRI.builder().curie(id).build()));
    }

    public static boolean isBlank(Resource resource) {
        if (resource == null) {
            return false;
        }
        String scheme = resource.id().getScheme();
        return scheme != null && (GENID.equals(scheme) || UNDERSCORE.equals(scheme));
    }

    public static Resource from(Map<String, Object> map, Resource.Mapper mapper) throws IOException {
        DefaultAnonymousResource r = new DefaultAnonymousResource();
        DefaultResource.map(mapper, r, null, map);
        return r;
    }

    private static void map(Resource.Mapper mapper, Resource r, String prefix, Map<String, Object> map) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            String p = prefix != null ? prefix + "." + key : key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                DefaultResource.map(mapper, r, p, (Map)value);
                continue;
            }
            if (value instanceof List) {
                for (Object o : (List)value) {
                    if (o instanceof Map) {
                        DefaultResource.map(mapper, r, p, (Map)o);
                        continue;
                    }
                    mapper.map(r, p, o.toString());
                }
                continue;
            }
            if (value == null) continue;
            mapper.map(r, p, value.toString());
        }
    }

    @Override
    public DefaultResource setId(IRI id) {
        this.iri = id;
        if (id != null) {
            this.embedded = DefaultResource.isBlank(this);
        }
        return this;
    }

    @Override
    public IRI id() {
        return this.iri;
    }

    @Override
    public int compareTo(Resource r) {
        return this.iri != null ? this.iri.toString().compareTo(r.id().toString()) : -1;
    }

    public int hashCode() {
        return this.iri != null ? this.iri.toString().hashCode() : -1;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Resource && this.iri != null && this.iri.toString().equals(((Resource)obj).id().toString());
    }

    @Override
    public boolean isEmbedded() {
        return this.embedded;
    }

    public MultiMap<IRI, Node> getAttributes() {
        return this.attributes;
    }

    public Map<IRI, Resource> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.embedded ? PLACEHOLDER + (this.iri != null ? this.iri.getSchemeSpecificPart() : "<null>") : (this.iri != null ? this.iri.toString() : "<null>");
    }

    @Override
    public Resource add(Triple triple) {
        if (triple == null) {
            return this;
        }
        IRI otherId = triple.subject().id();
        if (otherId != null && !otherId.equals((Object)this.id())) {
            Resource child = this.children.get(otherId);
            if (child != null) {
                return child.add(triple);
            }
            logger.info("nothing found!!! my ID is " + this.id());
            return new DefaultResource(otherId).add(triple);
        }
        this.add(triple.predicate(), triple.object());
        return this;
    }

    @Override
    public Resource add(IRI predicate, Node object) {
        this.attributes.put(predicate, object);
        if (object instanceof Resource) {
            Resource r = (Resource)object;
            this.children.put(r.id(), r);
        }
        return this;
    }

    @Override
    public Resource add(IRI predicate, IRI iri) {
        return this.add(predicate, (Resource)new DefaultResource(iri));
    }

    @Override
    public Resource add(IRI predicate, Literal literal) {
        if (predicate != null && literal != null) {
            this.attributes.put(predicate, literal);
        }
        return this;
    }

    @Override
    public Resource add(IRI predicate, Resource resource) {
        if (resource == null) {
            return this;
        }
        if (resource.id() == null) {
            resource.setId(this.id());
            Resource r = this.newResource(predicate);
            resource.triples().forEach(r::add);
        } else {
            this.attributes.put(predicate, resource);
        }
        return this;
    }

    @Override
    public Resource add(IRI predicate, String value) {
        return this.add(predicate, this.newLiteral(value));
    }

    @Override
    public Resource add(IRI predicate, Integer value) {
        return this.add(predicate, this.newLiteral(value));
    }

    @Override
    public Resource add(IRI predicate, Boolean value) {
        return this.add(predicate, this.newLiteral(value));
    }

    @Override
    public Resource add(IRI predicate, List<Object> list) {
        list.forEach(object -> {
            if (object instanceof Map) {
                this.add(predicate, (Map<Object, Object>)((Map)object));
            } else if (object instanceof List) {
                this.add(predicate, (List<Object>)((List)object));
            } else if (object instanceof Resource) {
                this.add(predicate, (Resource)object);
            } else {
                this.add(predicate, this.newLiteral(object));
            }
        });
        return this;
    }

    @Override
    public Resource add(IRI predicate, Map<Object, Object> map) {
        Resource r = this.newResource(predicate);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object pred = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                r.add(this.newPredicate(pred), (Map<Object, Object>)((Map)obj));
                continue;
            }
            if (obj instanceof List) {
                r.add(this.newPredicate(pred), (List<Object>)((List)obj));
                continue;
            }
            if (obj instanceof Resource) {
                r.add(this.newPredicate(pred), (Resource)obj);
                continue;
            }
            r.add(this.newPredicate(pred), this.newLiteral(obj));
        }
        return this;
    }

    @Override
    public Resource add(String predicate, String value) {
        return this.add(this.newPredicate(predicate), value);
    }

    @Override
    public Resource add(String predicate, Integer value) {
        return this.add(this.newPredicate(predicate), value);
    }

    @Override
    public Resource add(String predicate, Boolean value) {
        return this.add(this.newPredicate(predicate), value);
    }

    @Override
    public Resource add(String predicate, Literal value) {
        return this.add(this.newPredicate(predicate), value);
    }

    @Override
    public Resource add(String predicate, IRI externalResource) {
        return this.add(this.newPredicate(predicate), externalResource);
    }

    @Override
    public Resource add(String predicate, Resource resource) {
        return this.add(this.newPredicate(predicate), resource);
    }

    @Override
    public Resource add(String predicate, Map<Object, Object> map) {
        return this.add(this.newPredicate(predicate), map);
    }

    @Override
    public Resource add(String predicate, List<Object> list) {
        return this.add(this.newPredicate(predicate), list);
    }

    @Override
    public Resource add(Map<Object, Object> map) {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object pred = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                Resource r = this.newResource(this.newPredicate(pred));
                r.add((Map)obj);
                continue;
            }
            if (obj instanceof List) {
                this.add(this.newPredicate(pred), (List<Object>)((List)obj));
                continue;
            }
            if (obj instanceof Resource) {
                this.add(this.newPredicate(pred), (Resource)obj);
                continue;
            }
            this.add(this.newPredicate(pred), this.newLiteral(obj));
        }
        return this;
    }

    @Override
    public Resource rename(IRI oldPredicate, IRI newPredicate) {
        Resource resource;
        Collection<Node> node = this.attributes.remove(oldPredicate);
        if (node != null) {
            node.forEach(n -> this.attributes.put(newPredicate, (Node)n));
        }
        if ((resource = this.children.remove(oldPredicate)) != null) {
            this.children.put(newPredicate, resource);
        }
        return this;
    }

    @Override
    public Resource rename(String oldPredicate, String newPredicate) {
        this.rename(this.newPredicate(oldPredicate), this.newPredicate(newPredicate));
        return this;
    }

    public Resource remove(IRI predicate) {
        if (predicate == null) {
            return this;
        }
        this.embeddedResources(predicate).forEach(resource -> this.children.remove(resource.id()));
        this.attributes.remove(predicate);
        return this;
    }

    public Resource remove(IRI predicate, Node object) {
        if (predicate == null) {
            return this;
        }
        this.attributes.remove(predicate, object);
        return this;
    }

    @Override
    public Resource a(IRI externalResource) {
        this.add(this.newPredicate(RdfConstants.RDF_TYPE), externalResource);
        return this;
    }

    @Override
    public Set<IRI> predicates() {
        return this.attributes.keySet();
    }

    @Override
    public List<Node> objects(IRI predicate) {
        return this.attributes.containsKey(predicate) ? new ArrayList<Node>(this.attributes.get(predicate)) : new ArrayList();
    }

    @Override
    public List<Node> objects(String predicate) {
        return this.objects(this.newPredicate(predicate));
    }

    @Override
    public List<Resource> resources(IRI predicate) {
        return this.attributes.get(predicate).stream().filter(n -> n instanceof Resource).map(Resource.class::cast).collect(Collectors.toList());
    }

    public List<Resource> embeddedResources(IRI predicate) {
        return this.attributes.get(predicate).stream().filter(n -> n instanceof Resource).map(Resource.class::cast).filter(Resource::isEmbedded).collect(Collectors.toList());
    }

    @Override
    public List<Node> externalObjects(IRI predicate) {
        return this.attributes.get(predicate).stream().filter(n -> !n.isEmbedded()).collect(Collectors.toList());
    }

    @Override
    public void compactPredicate(IRI predicate) {
        Collection resources = this.embeddedResources(predicate);
        if (resources.size() == 1) {
            Resource r = (Resource)resources.iterator().next();
            this.attributes.remove(predicate, r);
            r.objects(predicate).forEach(object -> this.attributes.put(predicate, (Node)object));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public Resource setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Resource newResource(IRI predicate) {
        DefaultAnonymousResource r = new DefaultAnonymousResource();
        this.children.put(r.id(), r);
        this.attributes.put(predicate, r);
        return r;
    }

    @Override
    public Resource newResource(String predicate) {
        return this.newResource(this.newPredicate(predicate));
    }

    @Override
    public List<Triple> triples() {
        return new Triples(this, true).list();
    }

    @Override
    public List<Triple> properties() {
        return new Triples(this, false).list();
    }

    @Override
    public Resource newSubject(Object subject) {
        return subject == null ? null : (subject instanceof Resource ? (Resource)subject : (subject instanceof IRI ? new DefaultResource((IRI)subject) : new DefaultResource(IRI.builder().curie(subject.toString()).build())));
    }

    @Override
    public IRI newPredicate(Object predicate) {
        return predicate == null ? null : (predicate instanceof IRI ? (IRI)predicate : IRI.builder().curie(predicate.toString()).build());
    }

    @Override
    public Node newObject(Object object) {
        return object == null ? null : (object instanceof Literal ? (Literal)object : (object instanceof IRI ? new DefaultResource((IRI)object) : new DefaultLiteral(object)));
    }

    @Override
    public Literal newLiteral(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Literal) {
            return (Literal)value;
        }
        if (value instanceof Double) {
            return new DefaultLiteral(value).type(DOUBLE);
        }
        if (value instanceof Float) {
            return new DefaultLiteral(value).type(FLOAT);
        }
        if (value instanceof Long) {
            return new DefaultLiteral(value).type(LONG);
        }
        if (value instanceof Integer) {
            return new DefaultLiteral(value).type(INT);
        }
        if (value instanceof Boolean) {
            return new DefaultLiteral(value).type(BOOLEAN);
        }
        return new DefaultLiteral(value);
    }

    public List<Triple> find(IRI predicate, Literal literal) {
        return new Triples(this, predicate, literal).list();
    }

    private static class Triples {
        private final List<Triple> tripleList;
        private final boolean recursive;

        Triples(Resource resource, boolean recursive) {
            this.recursive = recursive;
            this.tripleList = this.unfold(resource);
        }

        Triples(Resource resource, IRI predicate, Literal literal) {
            this.recursive = true;
            this.tripleList = this.find(resource, predicate, literal);
        }

        List<Triple> list() {
            return this.tripleList;
        }

        private List<Triple> unfold(Resource resource) {
            ArrayList<Triple> list = new ArrayList<Triple>();
            if (resource == null) {
                return list;
            }
            for (IRI pred : resource.predicates()) {
                resource.objects(pred).forEach(node -> {
                    DefaultTriple defaultTriple = new DefaultTriple(resource, pred, (Node)node);
                    list.add(defaultTriple);
                    if (this.recursive && node instanceof Resource) {
                        list.addAll(this.unfold((Resource)node));
                    }
                });
            }
            return list;
        }

        private List<Triple> find(Resource resource, IRI predicate, Literal literal) {
            ArrayList<Triple> list = new ArrayList<Triple>();
            if (resource == null) {
                return list;
            }
            if (resource.predicates().contains(predicate)) {
                resource.objects(predicate).forEach(node -> {
                    if (literal.equals(node)) {
                        list.add(new DefaultTriple(resource, predicate, (Node)node));
                    }
                });
                if (!list.isEmpty()) {
                    return list;
                }
            } else {
                for (IRI pred : resource.predicates()) {
                    resource.objects(pred).forEach(node -> {
                        if (node instanceof Resource) {
                            list.addAll(this.find((Resource)node, predicate, literal));
                        }
                    });
                }
            }
            return list;
        }
    }
}

