/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.rdf.io.json;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.rdf.RdfContentGenerator;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.Triple;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.internal.DefaultResource;
import org.xbib.content.rdf.io.json.JsonContentParams;
import org.xbib.content.resource.IRI;

public class JsonContentGenerator
implements RdfContentGenerator<JsonContentParams>,
Flushable {
    private static final Logger logger = Logger.getLogger(JsonContentGenerator.class.getName());
    private final Writer writer;
    private boolean nsWritten;
    private Resource resource;
    private JsonContentParams params = JsonContentParams.JSON_CONTENT_PARAMS;

    JsonContentGenerator(OutputStream out) throws IOException {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    JsonContentGenerator(Writer writer) throws IOException {
        this.writer = writer;
        this.nsWritten = false;
        this.resource = new DefaultAnonymousResource();
    }

    @Override
    public JsonContentParams getParams() {
        return this.params;
    }

    @Override
    public void close() throws IOException {
        this.receive(this.resource);
    }

    public JsonContentGenerator receive(IRI iri) {
        if (!iri.equals((Object)this.resource.id())) {
            try {
                if (!this.nsWritten) {
                    this.writeNamespaces();
                }
                this.resource = new DefaultResource(iri);
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public RdfContentGenerator<JsonContentParams> setParams(JsonContentParams rdfContentParams) {
        this.params = rdfContentParams;
        return this;
    }

    public JsonContentGenerator startStream() {
        return this;
    }

    @Override
    public RdfContentGenerator<JsonContentParams> setBaseUri(String baseUri) {
        return this;
    }

    public JsonContentGenerator startPrefixMapping(String prefix, String uri) {
        return this;
    }

    public JsonContentGenerator endPrefixMapping(String prefix) {
        return this;
    }

    public JsonContentGenerator receive(Triple triple) {
        this.resource.add(triple);
        return this;
    }

    public JsonContentGenerator endStream() {
        return this;
    }

    private JsonContentGenerator writeNamespaces() throws IOException {
        this.nsWritten = false;
        for (Map.Entry entry : this.params.getNamespaceContext().getNamespaces().entrySet()) {
            String nsURI;
            if (((String)entry.getValue()).length() <= 0 || "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(nsURI = (String)entry.getValue())) continue;
            this.nsWritten = true;
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public JsonContentGenerator receive(Resource resource) throws IOException {
        return this;
    }
}

